/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.mcm.shuttersim;

import java.time.Duration;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.lsst.ccs.UsesSubsystem;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystem.mcm.shuttersim.ShutterInternalState;
import org.lsst.ccs.utilities.logging.Logger;

public class ShutterSim
extends Module
implements UsesSubsystem {
    private ShutterInternalState state = ShutterInternalState.CLOSED_OFF;
    private final ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(4);
    protected static final Logger log = Logger.getLogger((String)"org.lsst.ccs.subsystem.mcm");

    public void initModule() {
        this.getSubsystem().updateAgentState(new Enum[]{this.state.getPublicState(), this.state.getPublicReadinessState()});
    }

    @Command
    public void prepare() {
        log.info((Object)"ShutterSim command: prepare");
        this.setState(this.state.prepare(this));
    }

    @Command
    public void expose(long millis) {
        log.info((Object)("ShutterSim command: expose " + millis));
        this.setState(this.state.expose(this, Duration.ofMillis(millis)));
    }

    @Command
    public void close() {
        log.info((Object)"ShutterSim command: close");
        this.setState(this.state.close(this));
    }

    public long getLastEffectiveExposureTime() {
        return this.state.getLastEffectiveExposureTime();
    }

    public long getLastTotalOpeningTime() {
        return this.state.getLastTotalOpeningTime();
    }

    public void setState(ShutterInternalState s) {
        if (this.state == s) {
            return;
        }
        this.state.exit(this);
        this.state = s;
        this.state.enter(this);
        this.getSubsystem().updateAgentState(new Enum[]{this.state.getPublicState(), this.state.getPublicReadinessState()});
        log.info((Object)("ShutterSim state: " + this.state.getPublicState() + " " + this.state.getPublicReadinessState()));
    }

    public ShutterInternalState getState() {
        return this.state;
    }

    public ScheduledFuture<ShutterInternalState> scheduleTransition(Duration delay, ShutterInternalState from, ShutterInternalState to) {
        log.info((Object)(" scheduling to " + to + " delay " + delay + " from " + from));
        return this.scheduler.schedule(() -> ShutterInternalState.scheduled(this, from, to), delay.toMillis(), TimeUnit.MILLISECONDS);
    }

    public void clearSchedule() {
        for (Runnable r : this.scheduler.getQueue()) {
            if (!(r instanceof ScheduledFuture)) continue;
            ((ScheduledFuture)((Object)r)).cancel(false);
        }
    }

    Logger getLogger() {
        return log;
    }

    public void tick() {
    }
}

