/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.console.jython;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.net.util.SubnetUtils;
import org.lsst.ccs.BusMaster;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.scripting.CCS;
import org.lsst.ccs.scripting.jython.JythonScriptExecutorUtils;
import org.lsst.ccs.subsystems.console.jython.JythonConsoleNetworkUtilities;
import org.lsst.ccs.utilities.logging.Logger;
import org.python.core.PyCode;
import org.python.core.PyObject;
import org.python.core.PySystemState;
import org.python.util.PythonInterpreter;

public class JythonInterpreterConsole
extends BusMaster {
    private static final Options commandLineOptions = new Options();
    private static final String PORT_OPTION = "port";
    private static final String HELP_OPTION = "help";
    private final HashMap<Long, InternalJythonInterpreterThread> openSocketConnections = new HashMap();
    private final int maxNumberSocketConnections = Integer.valueOf(System.getProperty("org.lsst.ccs.subsystem.console.jython.interpreter.max.sockets", "20"));
    private final Logger logger = Logger.getLogger((String)"org.lsst.ccs.console.jython");
    private boolean shuttingDown = false;
    private Thread socketThread;
    private final ServerSocket serverSocket;
    private final int portNumber;
    private final List<SubnetUtils> allowedIps;

    JythonInterpreterConsole(int portNumber) throws IOException {
        super("JythonInterpreterConsole", AgentInfo.AgentType.SERVICE);
        Properties props = System.getProperties();
        PythonInterpreter.initialize((Properties)props, (Properties)props, null);
        this.serverSocket = new ServerSocket(portNumber);
        this.portNumber = portNumber;
        this.allowedIps = JythonConsoleNetworkUtilities.loadNetworkAccessInformation();
        this.start();
    }

    @Override
    public void doStart() {
        this.startListeningOnSocket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doShutdown() {
        this.shuttingDown = true;
        boolean canShutdown = true;
        HashMap<Long, InternalJythonInterpreterThread> hashMap = this.openSocketConnections;
        synchronized (hashMap) {
            for (InternalJythonInterpreterThread thread : this.openSocketConnections.values()) {
                if (!thread.getInterpreter().isExecuting()) continue;
                canShutdown = false;
                break;
            }
            if (canShutdown) {
                for (InternalJythonInterpreterThread thread : Arrays.asList(this.openSocketConnections.values().toArray(new InternalJythonInterpreterThread[0]))) {
                    thread.interrupt();
                }
            }
        }
        if (!canShutdown) {
            throw new RuntimeException("Cannot shutdown JythonInterpreterConsole. There is at least an active thread. It needs to be aborted first.");
        }
        this.shuttingDown = false;
    }

    private void refuseSocketConnection(PrintWriter out, Socket socket, String message) throws IOException {
        this.logger.warn((Object)message);
        out.println("ConnectionRefused");
        out.flush();
        out.close();
        socket.close();
    }

    private void startListeningOnSocket() {
        this.socketThread = new Thread(){
            Socket clientSocket;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                try {
                    while ((this.clientSocket = JythonInterpreterConsole.this.serverSocket.accept()) != null) {
                        PrintWriter out = new PrintWriter(this.clientSocket.getOutputStream(), true);
                        InetAddress clientAddress = this.clientSocket.getInetAddress();
                        if (JythonInterpreterConsole.this.shuttingDown) {
                            JythonInterpreterConsole.this.refuseSocketConnection(out, this.clientSocket, "The Jython Console is shutting down");
                            continue;
                        }
                        HashMap hashMap = JythonInterpreterConsole.this.openSocketConnections;
                        synchronized (hashMap) {
                            if (JythonConsoleNetworkUtilities.isInetAddressLocalhost(clientAddress) || JythonConsoleNetworkUtilities.isIpAddressAllowed(clientAddress.getHostAddress(), JythonInterpreterConsole.this.allowedIps)) {
                                if (JythonInterpreterConsole.this.openSocketConnections.size() >= JythonInterpreterConsole.this.maxNumberSocketConnections) {
                                    JythonInterpreterConsole.this.refuseSocketConnection(out, this.clientSocket, "Socket connection from " + clientAddress.getHostAddress() + " refused as the maximum number of allowed connections (" + JythonInterpreterConsole.this.maxNumberSocketConnections + ") has already been reached.");
                                } else {
                                    InternalJythonInterpreter interpreter = new InternalJythonInterpreter(this.clientSocket);
                                    InternalJythonInterpreterThread interpreterThread = new InternalJythonInterpreterThread(interpreter);
                                    out.println("ConnectionOK " + interpreterThread.getId());
                                    out.flush();
                                    JythonInterpreterConsole.this.openSocketConnections.put(interpreterThread.getId(), interpreterThread);
                                    interpreterThread.start();
                                }
                            } else {
                                JythonInterpreterConsole.this.refuseSocketConnection(out, this.clientSocket, "Socket connection from " + clientAddress.getHostAddress() + " closed as it's neither localhost nor in the list of accepted IP addresses.");
                            }
                        }
                    }
                    return;
                }
                catch (IOException ioe) {
                    throw new RuntimeException("Problems while establishing a socket connection", ioe);
                }
            }
        };
        this.socketThread.setDaemon(true);
        this.socketThread.start();
        while (this.socketThread.getState() != Thread.State.RUNNABLE) {
        }
    }

    @Command(description="Get interpreter threads", type=Command.CommandType.QUERY)
    public String getInterpreterThreads() {
        String result = "";
        for (Long id : this.openSocketConnections.keySet()) {
            result = result + " " + id + " " + this.openSocketConnections.get(id).getThreadName() + "\n";
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(description="Abort an interpreter thread by Name", type=Command.CommandType.ACTION)
    public void abortInterpreterThread(String name) {
        InternalJythonInterpreterThread interpreterThread = null;
        HashMap<Long, InternalJythonInterpreterThread> hashMap = this.openSocketConnections;
        synchronized (hashMap) {
            for (InternalJythonInterpreterThread interpreter : this.openSocketConnections.values()) {
                if (!interpreter.getThreadName().equals(name)) continue;
                interpreterThread = interpreter;
                break;
            }
        }
        if (interpreterThread == null) {
            throw new RuntimeException("Cannot find Thread with name " + name);
        }
        interpreterThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interpreterThreadTerminated(Long id) {
        HashMap<Long, InternalJythonInterpreterThread> hashMap = this.openSocketConnections;
        synchronized (hashMap) {
            this.openSocketConnections.remove(id);
        }
    }

    public static void main(String[] args) throws ParseException {
        BasicParser parser = new BasicParser();
        CommandLine line = parser.parse(commandLineOptions, args, true);
        if (line.hasOption(HELP_OPTION)) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(100, "CCS Jython Interpreter Console", "", commandLineOptions, "", true);
        } else {
            JythonScriptExecutorUtils.loadPythonSystemProperties();
            int portNumber = 4444;
            if (line.hasOption(PORT_OPTION)) {
                portNumber = Integer.parseInt(line.getOptionValue(PORT_OPTION));
            }
            try {
                JythonInterpreterConsole jythonInterpreterConsole = new JythonInterpreterConsole(portNumber);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
    }

    static {
        commandLineOptions.addOption("p", PORT_OPTION, true, "Port to run the interpreter on.");
        commandLineOptions.addOption("h", HELP_OPTION, false, "Print the help message");
    }

    private class JythonProcessingThread
    extends Thread {
        private final InternalJythonInterpreter interpreter;
        private final String contentId;
        private final String bufferContent;

        JythonProcessingThread(InternalJythonInterpreter interpreter, String bufferContent, String contentId) {
            this.interpreter = interpreter;
            this.contentId = contentId;
            this.bufferContent = bufferContent;
            JythonInterpreterConsole.this.logger.info((Object)("Executing contentId: " + contentId));
            JythonInterpreterConsole.this.logger.info((Object)bufferContent);
        }

        @Override
        public void run() {
            try {
                PyCode code = this.interpreter.getPythonInterpreter().compile(this.bufferContent);
                this.interpreter.getPythonInterpreter().exec((PyObject)code);
            }
            catch (Exception executionException) {
                executionException.printStackTrace(this.interpreter.getOutputWriter());
            }
            finally {
                this.interpreter.getOutputWriter().println("doneExecution:" + this.contentId);
                this.interpreter.setIsExecuting(false);
            }
            JythonInterpreterConsole.this.logger.info((Object)("Done executing contentId: " + this.contentId));
        }
    }

    class InternalJythonInterpreter
    implements Runnable {
        private final Socket clientSocket;
        private final BufferedReader in;
        private final PrintWriter out;
        private boolean executing = false;
        private Thread executionThread = null;
        private final PythonInterpreter pyInterpreter;

        public InternalJythonInterpreter(Socket socket) throws IOException {
            this.clientSocket = socket;
            this.out = new PrintWriter(socket.getOutputStream(), true);
            this.in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            PySystemState state = new PySystemState();
            this.pyInterpreter = new PythonInterpreter(null, state);
            this.pyInterpreter.setOut((Writer)this.out);
            this.pyInterpreter.setErr((Writer)this.out);
        }

        private PythonInterpreter getPythonInterpreter() {
            return this.pyInterpreter;
        }

        private void interrupt() {
            if (this.executionThread != null) {
                this.executionThread.interrupt();
            }
        }

        private PrintWriter getOutputWriter() {
            return this.out;
        }

        private boolean isExecuting() {
            return this.executing;
        }

        private void setIsExecuting(boolean executing) {
            this.executing = executing;
        }

        @Override
        public void run() {
            String contentId = null;
            StringBuilder executionBuffer = new StringBuilder();
            try {
                String inputLine;
                boolean isValidBuffer = false;
                while ((inputLine = this.in.readLine()) != null) {
                    if (inputLine.startsWith("startContent:")) {
                        isValidBuffer = true;
                        contentId = inputLine.replace("startContent:", "");
                        executionBuffer.setLength(0);
                        continue;
                    }
                    if (inputLine.startsWith("endContent:")) {
                        RuntimeException e;
                        String name;
                        String bufferContent = executionBuffer.toString();
                        if (bufferContent.startsWith("abortInterpreter")) {
                            name = bufferContent.replace("abortInterpreter", "").trim();
                            if (name.isEmpty()) {
                                name = ((InternalJythonInterpreterThread)JythonInterpreterConsole.this.openSocketConnections.get(Thread.currentThread().getId())).getThreadName();
                            }
                            JythonInterpreterConsole.this.abortInterpreterThread(name);
                            this.out.println("doneExecution:" + contentId);
                            this.out.flush();
                        } else if (bufferContent.startsWith("initializeInterpreter")) {
                            name = bufferContent.replace("initializeInterpreter", "").trim();
                            ((InternalJythonInterpreterThread)JythonInterpreterConsole.this.openSocketConnections.get(Thread.currentThread().getId())).setThreadName(name);
                            this.out.println("doneExecution:" + contentId);
                            this.out.flush();
                        } else if (!this.executing) {
                            if (!JythonInterpreterConsole.this.shuttingDown) {
                                this.executing = true;
                                this.executionThread = new JythonProcessingThread(this, bufferContent, contentId);
                                this.executionThread.start();
                            } else {
                                e = new RuntimeException("The console is shutting down. It cannot execute any content");
                                e.printStackTrace(this.out);
                                JythonInterpreterConsole.this.logger.warn((Object)e.getMessage());
                            }
                        } else {
                            e = new RuntimeException("There is already an execution for this socket connection. Only one execution at a time is allowed");
                            e.printStackTrace(this.out);
                            JythonInterpreterConsole.this.logger.warn((Object)e.getMessage());
                        }
                        isValidBuffer = false;
                        continue;
                    }
                    if (isValidBuffer) {
                        executionBuffer.append(inputLine).append("\n");
                        continue;
                    }
                    throw new RuntimeException("Invalid Socket Protocol. The content was not initialized.");
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.pyInterpreter.cleanup();
            CCS.cleanUp();
            JythonInterpreterConsole.this.interpreterThreadTerminated(Thread.currentThread().getId());
            try {
                this.clientSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    class InternalJythonInterpreterThread
    extends Thread {
        private final InternalJythonInterpreter interpreter;
        private String name;

        InternalJythonInterpreterThread(InternalJythonInterpreter interpreter) {
            super(interpreter);
            this.name = this.getName();
            this.interpreter = interpreter;
        }

        private InternalJythonInterpreter getInterpreter() {
            return this.interpreter;
        }

        private void setThreadName(String name) {
            this.name = name;
        }

        String getThreadName() {
            return this.name;
        }

        @Override
        public void interrupt() {
            this.interpreter.interrupt();
            super.interrupt();
        }
    }
}

