package org.lsst.ccs.subsystem.mcm.shuttersim;

import java.time.Duration;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.utilities.logging.Logger;

public class ShutterSim extends Module {

	private ShutterInternalState state = ShutterInternalState.CLOSED_OFF;

	private final ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(4);

	protected static final Logger log = Logger.getLogger("org.lsst.ccs.subsystem.mcm");

	public ShutterSim(String name, int tickMillis) {
		super(name, tickMillis);
	}

	@Override
	public void initModule() {
		getSubsystem().updateAgentState("", state.getPublicState(), state.getPublicReadinessState());
	}

	@Command
	public void prepare() {
		log.info("ShutterSim command: prepare");
		setState(state.prepare(this));
	}

	@Command
	public void expose(long millis) {
		log.info("ShutterSim command: expose " + millis);
		setState(state.expose(this, Duration.ofMillis(millis)));
	}

	public long getLastEffectiveExposureTime() {
		return state.getLastEffectiveExposureTime();
	}

	public long getLastTotalOpeningTime() {
		return state.getLastTotalOpeningTime();
	}

	public void setState(ShutterInternalState s) {
		if (state == s)
			return;

		state.exit(this);
		state = s;
		state.enter(this);

		getSubsystem().updateAgentState("", state.getPublicState(), state.getPublicReadinessState());

		log.info("ShutterSim state: " + state.getPublicState() + " " + state.getPublicReadinessState());

	}

	public ScheduledFuture<ShutterInternalState> scheduleTransition(Duration delay, ShutterInternalState to) {
		log.debug(" scheduling to " + to + " delay " + delay);
		return scheduler.schedule(() -> ShutterInternalState.scheduled(this, state, to), delay.toMillis(),
				TimeUnit.MILLISECONDS);
	}

	Logger getLogger() {
		return log;
	}

	@Override
	public void tick() {
		// empty
	}

}
