/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config.remote;

import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.config.ConfigProfile;
import org.lsst.ccs.config.ConfigurationFacade;
import org.lsst.ccs.config.DBInterface;
import org.lsst.ccs.config.DeprecationListener;
import org.lsst.ccs.config.FIleBasedDAO;
import org.lsst.ccs.config.LocalConfigurationProxy;
import org.lsst.ccs.config.ParameterConfiguration;
import org.lsst.ccs.config.PersistenceLayerException;
import org.lsst.ccs.config.SubsystemDescription;
import org.lsst.ccs.config.remote.ConfigurationService;
import org.lsst.ccs.config.remote.DescriptionDeprecationEvent;
import org.lsst.ccs.config.remote.DescriptionResult;
import org.lsst.ccs.config.remote.ProfileDeprecationEvent;
import org.lsst.ccs.config.remote.ProfileResult;
import org.lsst.ccs.config.utilities.ConfigUtils;

public class ConfigurationServiceImpl
implements ConfigurationService {
    ConfigurationFacade facade;
    public static ConfigurationServiceImpl ON_DATABASE;
    public static ConfigurationServiceImpl ON_LOCAL_FILES;

    public ConfigurationServiceImpl(ConfigurationFacade facade) {
        this.facade = facade;
    }

    public ConfigurationFacade getFacade() {
        return this.facade;
    }

    @Override
    public synchronized DescriptionResult registerSubsystemDescription(SubsystemDescription newDescription) throws RemoteException {
        final DescriptionResult res = new DescriptionResult();
        this.facade.setDeprecationListener(new DeprecationListener(){

            @Override
            public void subsystemDeprecating(SubsystemDescription description) {
                res.setDescriptionDeprecationEvent(new DescriptionDeprecationEvent(description, ""));
            }

            @Override
            public void configProfileDeprecating(ConfigProfile profile) {
                res.addProfileDeprecationEvent(new ProfileDeprecationEvent(profile, ""));
            }
        });
        try {
            SubsystemDescription description = this.facade.registerSubsystemDescription(newDescription, new ConfigurationFacade.Profiles());
            res.setResult(description);
            return res;
        }
        catch (PersistenceLayerException e) {
            throw new RemoteException("server registration fail", e);
        }
    }

    @Override
    public synchronized DescriptionResult deprecateSubsystemDescription(String subsystemName, String tag) throws RemoteException {
        final DescriptionResult res = new DescriptionResult();
        this.facade.setDeprecationListener(new DeprecationListener(){

            @Override
            public void subsystemDeprecating(SubsystemDescription description) {
                res.setDescriptionDeprecationEvent(new DescriptionDeprecationEvent(description, ""));
            }

            @Override
            public void configProfileDeprecating(ConfigProfile profile) {
                res.addProfileDeprecationEvent(new ProfileDeprecationEvent(profile, ""));
            }
        });
        try {
            SubsystemDescription deprecated = this.facade.deprecateSubsystemDescription(subsystemName, tag, new ConfigurationFacade.Profiles());
            res.setResult(deprecated);
            DescriptionResult descriptionResult = res;
            return descriptionResult;
        }
        catch (PersistenceLayerException e) {
            throw new RemoteException("server deprecation fail", e);
        }
        finally {
            this.facade.setDeprecationListener(null);
        }
    }

    @Override
    public SubsystemDescription getActiveSubsystemDescription(String name, String tag) throws RemoteException {
        try {
            return this.facade.getActiveSubsystemDescription(name, tag);
        }
        catch (PersistenceLayerException e) {
            throw new RemoteException("description query", e);
        }
    }

    @Override
    public synchronized ProfileResult registerConfigProfile(ConfigProfile newProfile) throws RemoteException {
        final ProfileResult res = new ProfileResult();
        this.facade.setDeprecationListener(new DeprecationListener(){

            @Override
            public void subsystemDeprecating(SubsystemDescription description) {
            }

            @Override
            public void configProfileDeprecating(ConfigProfile profile) {
                res.setProfileDeprecationEvent(new ProfileDeprecationEvent(profile, ""));
            }
        });
        try {
            ConfigProfile profile = this.facade.registerConfigProfile(newProfile);
            res.setResult(profile);
            return res;
        }
        catch (PersistenceLayerException e) {
            throw new RemoteException("server registration fail", e);
        }
    }

    @Override
    public ProfileResult registerConfiguration(String subsystemName, String categoryName, String configurationName, String tag, String user, int level) throws RemoteException {
        SubsystemDescription description = this.getActiveSubsystemDescription(subsystemName, tag);
        LocalConfigurationProxy configurationProxy = new LocalConfigurationProxy(description);
        try {
            Map<String, String> taggedCategories = ConfigUtils.parseConfigurationString(description.getCategorySet(), categoryName + ":" + configurationName);
            configurationProxy.loadCategories(taggedCategories);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        ConfigProfile profile = configurationProxy.getProfileForCat(categoryName);
        return this.registerConfigProfile(profile);
    }

    @Override
    public synchronized ProfileResult deprecateConfigProfile(String subsystemName, String name, String tag) throws RemoteException {
        final ProfileResult res = new ProfileResult();
        this.facade.setDeprecationListener(new DeprecationListener(){

            @Override
            public void subsystemDeprecating(SubsystemDescription description) {
            }

            @Override
            public void configProfileDeprecating(ConfigProfile profile) {
                res.setProfileDeprecationEvent(new ProfileDeprecationEvent(profile, ""));
            }
        });
        try {
            ConfigProfile deprecated = this.facade.deprecateConfigProfile(subsystemName, name, tag);
            res.setResult(deprecated);
            ProfileResult profileResult = res;
            return profileResult;
        }
        catch (PersistenceLayerException exc) {
            throw new RemoteException("server deprecation fail", exc);
        }
        finally {
            this.facade.setDeprecationListener(null);
        }
    }

    @Override
    public ConfigProfile getActiveConfigProfile(String subsystemName, String name, String tag) throws RemoteException {
        try {
            return this.facade.getActiveConfigProfile(subsystemName, name, tag);
        }
        catch (PersistenceLayerException e) {
            throw new RemoteException("configuration query", e);
        }
    }

    @Override
    public ParameterConfiguration modifyParmConf(ParameterConfiguration engineeringModeParm) throws RemoteException {
        try {
            ParameterConfiguration res = this.facade.engineerParmConfig(engineeringModeParm);
            return res;
        }
        catch (PersistenceLayerException exc) {
            throw new RemoteException("parameter configuration fail :", exc);
        }
    }

    @Override
    public ConfigProfile getConfigRunningAt(String subsystemName, long date) throws RemoteException {
        try {
            return this.facade.getConfigRunningAt(subsystemName, date);
        }
        catch (PersistenceLayerException e) {
            throw new RemoteException("server get fail", e);
        }
    }

    @Override
    public String getActiveValueAt(String subsystemName, String parameterPath, long date) throws RemoteException {
        try {
            return this.facade.getActiveValueAt(subsystemName, parameterPath, date);
        }
        catch (PersistenceLayerException e) {
            throw new RemoteException("server get fail", e);
        }
    }

    @Override
    public ConfigProfile getConfigValidAt(String subsystemName, String name, String tag, long date) throws RemoteException {
        try {
            return this.facade.getConfigValidAt(subsystemName, name, tag, date);
        }
        catch (PersistenceLayerException e) {
            throw new RemoteException("server get fail", e);
        }
    }

    @Override
    public String getValueValidAt(String subsystemName, String profileName, String profileTag, String parameterPath, long date) throws RemoteException {
        try {
            return this.facade.getValueValidAt(subsystemName, profileName, profileTag, parameterPath, date);
        }
        catch (PersistenceLayerException e) {
            throw new RemoteException("server get fail", e);
        }
    }

    @Override
    public ConfigProfile getPrevious(ConfigProfile current) throws RemoteException {
        try {
            return this.facade.getPrevious(current);
        }
        catch (PersistenceLayerException e) {
            throw new RemoteException("server get fail", e);
        }
    }

    @Override
    public ConfigProfile getNext(ConfigProfile current) throws RemoteException {
        try {
            return this.facade.getNext(current);
        }
        catch (PersistenceLayerException e) {
            throw new RemoteException("server get fail", e);
        }
    }

    @Override
    public SubsystemDescription getPrevious(SubsystemDescription current) throws RemoteException {
        try {
            return this.facade.getPrevious(current);
        }
        catch (PersistenceLayerException e) {
            throw new RemoteException("server get fail", e);
        }
    }

    @Override
    public List<?> simpleHQLRequest(String hqlString) throws RemoteException {
        try {
            return this.facade.simpleHQLRequest(hqlString);
        }
        catch (PersistenceLayerException e) {
            throw new RemoteException("server request fail", e);
        }
    }

    static {
        String clazzName = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.configDAO", "org.lsst.ccs.config.dao.hibernate.HibernateDAO");
        DBInterface dao = null;
        try {
            dao = (DBInterface)Class.forName(clazzName).newInstance();
            ON_DATABASE = new ConfigurationServiceImpl(new ConfigurationFacade(dao));
        }
        catch (Exception e) {
            throw new Error(e);
        }
        ON_LOCAL_FILES = new ConfigurationServiceImpl(new ConfigurationFacade(new FIleBasedDAO()));
    }
}

