/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.mcm.shuttersim;

import java.time.Duration;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystem.mcm.shuttersim.ShutterInternalState;
import org.lsst.ccs.utilities.logging.Logger;

public class ShutterSim
extends Module {
    private ShutterInternalState state = ShutterInternalState.CLOSED_OFF;
    private final ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(4);
    protected static final Logger log = Logger.getLogger((String)"org.lsst.ccs.subsystem.mcm");

    public ShutterSim(String name, int tickMillis) {
        super(name, tickMillis);
    }

    public void initModule() {
        this.getSubsystem().updateAgentState("", new Enum[]{this.state.getPublicState(), this.state.getPublicReadinessState()});
    }

    @Command
    public void prepare() {
        log.info((Object)"ShutterSim command: prepare");
        this.setState(this.state.prepare(this));
    }

    @Command
    public void expose(long millis) {
        log.info((Object)("ShutterSim command: expose " + millis));
        this.setState(this.state.expose(this, Duration.ofMillis(millis)));
    }

    public long getLastEffectiveExposureTime() {
        return this.state.getLastEffectiveExposureTime();
    }

    public long getLastTotalOpeningTime() {
        return this.state.getLastTotalOpeningTime();
    }

    public void setState(ShutterInternalState s) {
        if (this.state == s) {
            return;
        }
        this.state.exit(this);
        this.state = s;
        this.state.enter(this);
        this.getSubsystem().updateAgentState("", new Enum[]{this.state.getPublicState(), this.state.getPublicReadinessState()});
        log.info((Object)("ShutterSim state: " + this.state.getPublicState() + " " + this.state.getPublicReadinessState()));
    }

    public ScheduledFuture<ShutterInternalState> scheduleTransition(Duration delay, ShutterInternalState to) {
        log.debug((Object)(" scheduling to " + to + " delay " + delay));
        return this.scheduler.schedule(() -> ShutterInternalState.scheduled(this, this.state, to), delay.toMillis(), TimeUnit.MILLISECONDS);
    }

    Logger getLogger() {
        return log;
    }

    public void tick() {
    }
}

