/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.bus.states.ConfigurationState;

public final class ConfigurationInfo
implements Serializable {
    private static final long serialVersionUID = 349664303742923784L;
    private final String descriptionName;
    private final Map<String, Boolean> hasCategoryChanged = new HashMap<String, Boolean>();
    private final Map<String, String> tags = new HashMap<String, String>();
    private final ConfigurationState configState;
    private final List<String> recentChanges = new ArrayList<String>();
    private final List<ConfigurationParameterInfo> parametersView = new ArrayList<ConfigurationParameterInfo>();

    protected ConfigurationInfo(ConfigurationState configState, String tagName) {
        this.configState = configState;
        this.descriptionName = tagName;
    }

    public ConfigurationInfo(ConfigurationState configState, String tagName, Map<String, String> tags, Map<String, Boolean> hasCategoryChanged, List<ConfigurationParameterInfo> parametersView) {
        this(configState, tagName);
        this.tags.putAll(tags);
        this.hasCategoryChanged.putAll(hasCategoryChanged);
        this.parametersView.addAll(parametersView);
    }

    public ConfigurationInfo(ConfigurationState configState, String tagName, Map<String, String> tags, Map<String, Boolean> hasCategoryChanged, List<ConfigurationParameterInfo> parametersView, List<String> recentChanges) {
        this(configState, tagName, tags, hasCategoryChanged, parametersView);
        this.recentChanges.addAll(recentChanges);
    }

    public String getDescriptionName() {
        return this.descriptionName;
    }

    public String getConfigurationName() {
        String res = this.descriptionName + "[";
        res = res + this.getTaggedCategories() + "]";
        return res;
    }

    private String getTaggedCategories() {
        String res = "";
        for (Map.Entry<String, String> entry : new TreeMap<String, String>(this.tags).entrySet()) {
            boolean hasChanges = this.hasChangesForCategory(entry.getKey());
            res = res + (entry.getKey().isEmpty() ? "" : entry.getKey() + ":") + entry.getValue() + (hasChanges ? "*" : "") + ",";
        }
        if (!res.isEmpty()) {
            res = res.substring(0, res.length() - 1);
        }
        return res;
    }

    public boolean hasChangesForCategory(String category) {
        return this.hasCategoryChanged.get(category);
    }

    public boolean hasChanges() {
        for (boolean b : this.hasCategoryChanged.values()) {
            if (!b) continue;
            return true;
        }
        return false;
    }

    public String getConfigNameForCategory(String category) {
        return this.tags.get(category);
    }

    public boolean hasCategory(String category) {
        return this.tags.containsKey(category);
    }

    public Set<String> getCategorySet() {
        return this.tags.keySet();
    }

    public ConfigurationState getConfigurationState() {
        return this.configState;
    }

    public String toString() {
        return "Configuration state : " + this.getConfigurationName() + " Description " + this.getDescriptionName();
    }

    public List<ConfigurationParameterInfo> getAllParameterInfo() {
        return Collections.unmodifiableList(this.parametersView);
    }

    public List<ConfigurationParameterInfo> getLatestChanges() {
        return Collections.unmodifiableList(this.parametersView.stream().filter(configParmInfo -> this.recentChanges.contains(configParmInfo.getPathName())).collect(Collectors.toList()));
    }

    public Map<String, String> getCurrentValuesForCategory(String category) {
        return Collections.unmodifiableMap(this.parametersView.stream().filter(parmInfo -> parmInfo.getCategoryName().equals(category)).collect(Collectors.toMap(ConfigurationParameterInfo::getPathName, ConfigurationParameterInfo::getCurrentValue)));
    }

    @Deprecated
    public Map<String, String> getCurrentValuesForComponent(String componentName) {
        return Collections.unmodifiableMap(this.parametersView.stream().filter(parmInfo -> parmInfo.getPathName().startsWith(componentName + "/")).collect(Collectors.toMap(ConfigurationParameterInfo::getPathName, ConfigurationParameterInfo::getCurrentValue)));
    }

    public Map<String, String> getCurrentValuesFor(String componentName) {
        return Collections.unmodifiableMap(this.parametersView.stream().filter(parmInfo -> parmInfo.getComponentName().equals(componentName)).collect(Collectors.toMap(ConfigurationParameterInfo::getParameterName, ConfigurationParameterInfo::getCurrentValue)));
    }

    public String getCurrentValueForParameter(String pathName) {
        return this.parametersView.stream().filter(parmInfo -> parmInfo.getPathName().equals(pathName)).map(ConfigurationParameterInfo::getCurrentValue).findFirst().get();
    }

    public static Map<String, List<ConfigurationParameterInfo>> getParameterInfoGroupByComponent(List<ConfigurationParameterInfo> parmList) {
        return parmList.stream().collect(Collectors.groupingBy(ConfigurationParameterInfo::getComponentName, Collectors.toList()));
    }

    public static Map<String, List<ConfigurationParameterInfo>> getParameterInfoGroupByCategory(List<ConfigurationParameterInfo> parmList) {
        return parmList.stream().collect(Collectors.groupingBy(ConfigurationParameterInfo::getCategoryName, Collectors.toList()));
    }
}

