/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.framework.annotations;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.framework.Configurable;
import org.lsst.ccs.framework.annotations.ComponentParameterSetter;
import org.lsst.ccs.framework.annotations.ConfigChanger;
import org.lsst.ccs.framework.annotations.ConfigurableParameterSetter;
import org.lsst.ccs.framework.annotations.ParameterSetter;

public class ParameterSetterBuilder {
    private static final Map<String, Map<String, Method>> CONFIG_CHANGER_MAP = new HashMap<String, Map<String, Method>>();
    private static final Map<String, Map<String, Field>> PARAMETER_MAP = new HashMap<String, Map<String, Field>>();

    private ParameterSetterBuilder() {
    }

    public static ParameterSetter buildParameterSetterFromObject(Object obj) {
        ParameterSetter res = ParameterSetterBuilder.buildParameterSetterFromClass(obj.getClass());
        res.setTarget(obj);
        return res;
    }

    public static ParameterSetter buildParameterSetterFromClass(Class<?> klass) {
        Map<String, Method> configChangerMap = ParameterSetterBuilder.buildConfigChangerMap(klass);
        Map<String, Field> fieldsMap = ParameterSetterBuilder.buildParameterFieldsMap(klass);
        if (Configurable.class.isAssignableFrom(klass)) {
            return new ConfigurableParameterSetter(configChangerMap, fieldsMap);
        }
        return new ComponentParameterSetter(configChangerMap, fieldsMap);
    }

    private static Map<String, Method> buildConfigChangerMap(Class klass) {
        String klassName = klass.getName();
        Map<String, Method> configMethods = CONFIG_CHANGER_MAP.get(klassName);
        if (configMethods == null) {
            configMethods = new HashMap<String, Method>();
            CONFIG_CHANGER_MAP.put(klassName, configMethods);
            for (Method method : klass.getMethods()) {
                String propertyName;
                String methodName = method.getName();
                ConfigChanger configChanger = method.getAnnotation(ConfigChanger.class);
                if (configChanger != null) {
                    String propertyName2;
                    if (methodName.startsWith("set")) {
                        char firstLetter = methodName.charAt(3);
                        propertyName = Character.toLowerCase(firstLetter) + methodName.substring(4);
                        configMethods.put(propertyName, method);
                    }
                    if ("".equals(propertyName2 = configChanger.propertyName())) continue;
                    configMethods.put(propertyName2, method);
                    continue;
                }
                ConfigurationParameterChanger parameterChanger = method.getAnnotation(ConfigurationParameterChanger.class);
                if (parameterChanger == null) continue;
                if (methodName.startsWith("set")) {
                    char firstLetter = methodName.charAt(3);
                    String propertyName3 = Character.toLowerCase(firstLetter) + methodName.substring(4);
                    configMethods.put(propertyName3, method);
                }
                if ("".equals(propertyName = parameterChanger.propertyName())) continue;
                configMethods.put(propertyName, method);
            }
        }
        return configMethods;
    }

    private static Map<String, Field> buildParameterFieldsMap(Class klass) {
        String className = klass.getName();
        Map<String, Field> res = PARAMETER_MAP.get(className);
        if (res == null) {
            Field[] fields;
            res = new HashMap<String, Field>();
            PARAMETER_MAP.put(className, res);
            for (Field f : fields = klass.getDeclaredFields()) {
                ConfigurationParameter a = f.getAnnotation(ConfigurationParameter.class);
                if (a == null) continue;
                String parmName = a.name().isEmpty() ? f.getName() : a.name();
                res.put(parmName, f);
            }
        }
        return res;
    }
}

