/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.compression.algorithm.hcompress;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import nom.tam.fits.compression.algorithm.api.ICompressor;
import nom.tam.fits.compression.algorithm.hcompress.HCompress;
import nom.tam.fits.compression.algorithm.hcompress.HCompressorOption;
import nom.tam.fits.compression.algorithm.hcompress.HCompressorQuantizeOption;
import nom.tam.fits.compression.algorithm.hcompress.HDecompress;
import nom.tam.fits.compression.algorithm.quant.QuantizeProcessor;
import nom.tam.util.ArrayFuncs;

public abstract class HCompressor<T extends Buffer>
implements ICompressor<T> {
    private HCompress compress;
    private HDecompress decompress;
    private final HCompressorOption options;

    public HCompressor(HCompressorOption options) {
        this.options = options;
    }

    private HCompress compress() {
        if (this.compress == null) {
            this.compress = new HCompress();
        }
        return this.compress;
    }

    protected void compress(long[] longArray, ByteBuffer compressed) {
        this.compress().compress(longArray, this.options.getTileHeight(), this.options.getTileWidth(), this.options.getScale(), compressed);
    }

    private HDecompress decompress() {
        if (this.decompress == null) {
            this.decompress = new HDecompress();
        }
        return this.decompress;
    }

    @Override
    protected void decompress(ByteBuffer compressed, long[] aa) {
        this.decompress().decompress(compressed, this.options.isSmooth(), aa);
    }

    public static class ShortHCompressor
    extends HCompressor<ShortBuffer> {
        public ShortHCompressor(HCompressorOption options) {
            super(options);
        }

        @Override
        public boolean compress(ShortBuffer buffer, ByteBuffer compressed) {
            short[] shortArray = new short[buffer.limit()];
            buffer.get(shortArray);
            long[] longArray = new long[shortArray.length];
            ArrayFuncs.copyInto(shortArray, longArray);
            this.compress(longArray, compressed);
            return true;
        }

        @Override
        public void decompress(ByteBuffer compressed, ShortBuffer buffer) {
            long[] longArray = new long[buffer.limit()];
            this.decompress(compressed, longArray);
            for (long element : longArray) {
                buffer.put((short)element);
            }
        }
    }

    public static class IntHCompressor
    extends HCompressor<IntBuffer> {
        public IntHCompressor(HCompressorOption options) {
            super(options);
        }

        @Override
        public boolean compress(IntBuffer buffer, ByteBuffer compressed) {
            int[] intArray = new int[buffer.limit()];
            buffer.get(intArray);
            long[] longArray = new long[intArray.length];
            ArrayFuncs.copyInto(intArray, longArray);
            this.compress(longArray, compressed);
            return true;
        }

        @Override
        public void decompress(ByteBuffer compressed, IntBuffer buffer) {
            long[] longArray = new long[buffer.limit()];
            this.decompress(compressed, longArray);
            for (long element : longArray) {
                buffer.put((int)element);
            }
        }
    }

    public static class FloatHCompressor
    extends QuantizeProcessor.FloatQuantCompressor {
        public FloatHCompressor(HCompressorQuantizeOption options) {
            super(options, new IntHCompressor(options.getHCompressorOption()));
        }
    }

    public static class DoubleHCompressor
    extends QuantizeProcessor.DoubleQuantCompressor {
        public DoubleHCompressor(HCompressorQuantizeOption options) {
            super(options, new IntHCompressor(options.getHCompressorOption()));
        }
    }

    public static class ByteHCompressor
    extends HCompressor<ByteBuffer> {
        private static final long BYTE_MASK_FOR_LONG = 255L;

        public ByteHCompressor(HCompressorOption options) {
            super(options);
        }

        @Override
        public boolean compress(ByteBuffer buffer, ByteBuffer compressed) {
            byte[] byteArray = new byte[buffer.limit()];
            buffer.get(byteArray);
            long[] longArray = new long[byteArray.length];
            for (int index = 0; index < longArray.length; ++index) {
                longArray[index] = (long)byteArray[index] & 0xFFL;
            }
            this.compress(longArray, compressed);
            return true;
        }

        @Override
        public void decompress(ByteBuffer compressed, ByteBuffer buffer) {
            long[] longArray = new long[buffer.limit()];
            this.decompress(compressed, longArray);
            for (long element : longArray) {
                buffer.put((byte)element);
            }
        }
    }
}

