/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.RaisedAlertInstance;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public final class RaisedAlertHistory
implements Serializable {
    private static final long serialVersionUID = 423621057372456934L;
    private Alert latestAlert;
    private final List<RaisedAlertInstance> instances;
    private AlertState highestSeverity = AlertState.NOMINAL;

    public RaisedAlertHistory() {
        this.instances = new ArrayList<RaisedAlertInstance>(1);
    }

    public Alert getLatestAlert() {
        return this.latestAlert;
    }

    public void addAlertInstance(AlertState severity, Alert alert, CCSTimeStamp ccsTimeStamp, String cause, int count) {
        if (severity.compareTo(this.highestSeverity) > 0) {
            this.highestSeverity = severity;
        }
        this.instances.add(new RaisedAlertInstance(severity, ccsTimeStamp, cause, count));
        this.latestAlert = alert;
    }

    public int getNumberOfInstances() {
        return this.instances.size();
    }

    public int getAccumulatedNumberOfInstances() {
        return this.instances.stream().collect(Collectors.summingInt(RaisedAlertInstance::getCount));
    }

    public AlertState getLatestAlertState() {
        int n = this.getNumberOfInstances();
        switch (n) {
            case 0: {
                return AlertState.NOMINAL;
            }
        }
        return this.instances.get(n - 1).getAlertState();
    }

    public CCSTimeStamp getLatestAlertCCSTimeStamp() {
        int n = this.getNumberOfInstances();
        switch (n) {
            case 0: {
                return null;
            }
        }
        return this.instances.get(n - 1).getCCSTimeStamp();
    }

    public String getLatestAlertCause() {
        int n = this.getNumberOfInstances();
        switch (n) {
            case 0: {
                return "";
            }
        }
        return this.instances.get(n - 1).getCause();
    }

    public RaisedAlertInstance getLatestAlertInstance() {
        int n = this.getNumberOfInstances();
        switch (n) {
            case 0: {
                return null;
            }
        }
        return this.instances.get(n - 1);
    }

    public AlertState getHighestAlertState() {
        return this.highestSeverity;
    }

    public ArrayList<RaisedAlertInstance> getRaisedAlertInstancesList() {
        return new ArrayList<RaisedAlertInstance>(this.instances);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Raised Alarms for id ").append(this.getLatestAlert().getAlertId()).append("\n");
        sb.append("Overall Severity: ").append(this.getHighestAlertState());
        return sb.toString();
    }
}

