/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.XSLTFunction;
import net.sf.saxon.instruct.NumberInstruction;
import net.sf.saxon.number.Numberer;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.TimeValue;
import net.sf.saxon.value.Whitespace;

public class FormatDate
extends SystemFunction
implements XSLTFunction {
    private static Pattern componentPattern = Pattern.compile("([YMDdWwFHhmsfZzPCE])\\s*(.*)");
    private static Pattern formatPattern = Pattern.compile("([^,]*)(,.*)?");
    private static Pattern widthPattern = Pattern.compile(",(\\*|[0-9]+)(\\-(\\*|[0-9]+))?");
    private static Pattern alphanumericPattern = Pattern.compile("([A-Za-z0-9]|\\p{L}|\\p{N})*");

    public void checkArguments(StaticContext staticContext) throws XPathException {
        int n = this.argument.length;
        if (n != 2 && n != 5) {
            throw new StaticError("Function " + this.getDisplayName(staticContext.getNamePool()) + " must have either two or five arguments", ExpressionTool.getLocator(this));
        }
        super.checkArguments(staticContext);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        String string;
        String string2;
        Object object;
        CalendarValue calendarValue = (CalendarValue)this.argument[0].evaluateItem(xPathContext);
        if (calendarValue == null) {
            return null;
        }
        String string3 = this.argument[1].evaluateItem(xPathContext).getStringValue();
        StringValue stringValue = null;
        StringValue stringValue2 = null;
        if (this.argument.length > 2) {
            object = (AtomicValue)this.argument[2].evaluateItem(xPathContext);
            stringValue = (StringValue)this.argument[3].evaluateItem(xPathContext);
            stringValue2 = (StringValue)this.argument[4].evaluateItem(xPathContext);
            string2 = object == null ? Locale.getDefault().getLanguage() : ((string2 = ((AtomicValue)object).getStringValue()).length() >= 2 ? string2.substring(0, 2) : Locale.getDefault().getLanguage());
        } else {
            string2 = Locale.getDefault().getLanguage();
        }
        object = stringValue2 == null ? null : stringValue2.getStringValue();
        CharSequence charSequence = FormatDate.formatDate(calendarValue, string3, string2, (String)object, xPathContext);
        if (stringValue != null && !(string = stringValue.getStringValue()).equals("AD") && !string.equals("ISO")) {
            charSequence = "[Calendar: AD]" + ((Object)charSequence).toString();
        }
        return new StringValue(charSequence);
    }

    private static CharSequence formatDate(CalendarValue calendarValue, String string, String string2, String string3, XPathContext xPathContext) throws XPathException {
        Numberer numberer = NumberInstruction.makeNumberer(string2, string3, xPathContext);
        FastStringBuffer fastStringBuffer = new FastStringBuffer(32);
        if (!numberer.getClass().getName().endsWith("Numberer_" + string2)) {
            fastStringBuffer.append("[Language: en]");
        }
        int n = 0;
        while (true) {
            Object object;
            if (n < string.length() && string.charAt(n) != '[') {
                fastStringBuffer.append(string.charAt(n));
                if (string.charAt(n) == ']' && (++n == string.length() || string.charAt(n) != ']')) {
                    DynamicError dynamicError = new DynamicError("Closing ']' in date picture must be written as ']]'");
                    dynamicError.setErrorCode("XTDE1340");
                    dynamicError.setXPathContext(xPathContext);
                    throw dynamicError;
                }
                ++n;
                continue;
            }
            if (n == string.length()) break;
            if (string.charAt(++n) == '[') {
                fastStringBuffer.append('[');
                ++n;
                continue;
            }
            int n2 = string.indexOf("]", n);
            if (n2 == -1) {
                object = new DynamicError("Date format contains a '[' with no matching ']'");
                ((XPathException)object).setErrorCode("XTDE1340");
                ((DynamicError)object).setXPathContext(xPathContext);
                throw object;
            }
            object = string.substring(n, n2);
            fastStringBuffer.append(FormatDate.formatComponent(calendarValue, Whitespace.removeAllWhitespace((CharSequence)object), numberer, xPathContext));
            n = n2 + 1;
        }
        return fastStringBuffer;
    }

    private static CharSequence formatComponent(CalendarValue calendarValue, CharSequence charSequence, Numberer numberer, XPathContext xPathContext) throws XPathException {
        boolean bl = calendarValue instanceof TimeValue;
        boolean bl2 = calendarValue instanceof DateValue;
        DateTimeValue dateTimeValue = calendarValue.toDateTime();
        Matcher matcher = componentPattern.matcher(charSequence);
        if (!matcher.matches()) {
            DynamicError dynamicError = new DynamicError("Unrecognized date/time component [" + charSequence + ']');
            dynamicError.setErrorCode("XTDE1340");
            dynamicError.setXPathContext(xPathContext);
            throw dynamicError;
        }
        String string = matcher.group(1);
        String string2 = matcher.group(2);
        if (string2 == null) {
            string2 = "";
        }
        boolean bl3 = false;
        if ("".equals(string2) || string2.startsWith(",")) {
            bl3 = true;
            switch (string.charAt(0)) {
                case 'F': {
                    string2 = "Nn" + string2;
                    break;
                }
                case 'P': {
                    string2 = 'n' + string2;
                    break;
                }
                case 'C': 
                case 'E': {
                    string2 = 'N' + string2;
                    break;
                }
                case 'm': 
                case 's': {
                    string2 = "01" + string2;
                    break;
                }
                default: {
                    string2 = '1' + string2;
                }
            }
        }
        switch (string.charAt(0)) {
            case 'Y': {
                if (bl) {
                    DynamicError dynamicError = new DynamicError("In formatTime(): an xs:time value does not contain a year component");
                    dynamicError.setErrorCode("XTDE1350");
                    dynamicError.setXPathContext(xPathContext);
                    throw dynamicError;
                }
                int n = dateTimeValue.getYear();
                if (n < 0) {
                    n = 1 - n;
                }
                return FormatDate.formatNumber(string, n, string2, bl3, numberer, xPathContext);
            }
            case 'M': {
                if (bl) {
                    DynamicError dynamicError = new DynamicError("In formatTime(): an xs:time value does not contain a month component");
                    dynamicError.setErrorCode("XTDE1350");
                    dynamicError.setXPathContext(xPathContext);
                    throw dynamicError;
                }
                byte by = dateTimeValue.getMonth();
                return FormatDate.formatNumber(string, by, string2, bl3, numberer, xPathContext);
            }
            case 'D': {
                if (bl) {
                    DynamicError dynamicError = new DynamicError("In formatTime(): an xs:time value does not contain a day component");
                    dynamicError.setErrorCode("XTDE1350");
                    dynamicError.setXPathContext(xPathContext);
                    throw dynamicError;
                }
                byte by = dateTimeValue.getDay();
                return FormatDate.formatNumber(string, by, string2, bl3, numberer, xPathContext);
            }
            case 'd': {
                if (bl) {
                    DynamicError dynamicError = new DynamicError("In formatTime(): an xs:time value does not contain a day component");
                    dynamicError.setErrorCode("XTDE1350");
                    dynamicError.setXPathContext(xPathContext);
                    throw dynamicError;
                }
                int n = DateValue.getDayWithinYear(dateTimeValue.getYear(), dateTimeValue.getMonth(), dateTimeValue.getDay());
                return FormatDate.formatNumber(string, n, string2, bl3, numberer, xPathContext);
            }
            case 'W': {
                if (bl) {
                    DynamicError dynamicError = new DynamicError("In formatTime(): cannot obtain the week number from an xs:time value");
                    dynamicError.setErrorCode("XTDE1350");
                    dynamicError.setXPathContext(xPathContext);
                    throw dynamicError;
                }
                int n = DateValue.getWeekNumber(dateTimeValue.getYear(), dateTimeValue.getMonth(), dateTimeValue.getDay());
                return FormatDate.formatNumber(string, n, string2, bl3, numberer, xPathContext);
            }
            case 'w': {
                if (bl) {
                    DynamicError dynamicError = new DynamicError("In formatTime(): cannot obtain the week number from an xs:time value");
                    dynamicError.setErrorCode("XTDE1350");
                    dynamicError.setXPathContext(xPathContext);
                    throw dynamicError;
                }
                int n = DateValue.getWeekNumberWithinMonth(dateTimeValue.getYear(), dateTimeValue.getMonth(), dateTimeValue.getDay());
                return FormatDate.formatNumber(string, n, string2, bl3, numberer, xPathContext);
            }
            case 'H': {
                if (bl2) {
                    DynamicError dynamicError = new DynamicError("In formatDate(): an xs:date value does not contain an hour component");
                    dynamicError.setErrorCode("XTDE1350");
                    dynamicError.setXPathContext(xPathContext);
                    throw dynamicError;
                }
                IntegerValue integerValue = (IntegerValue)calendarValue.getComponent(4);
                return FormatDate.formatNumber(string, (int)integerValue.longValue(), string2, bl3, numberer, xPathContext);
            }
            case 'h': {
                if (bl2) {
                    DynamicError dynamicError = new DynamicError("In formatDate(): an xs:date value does not contain an hour component");
                    dynamicError.setErrorCode("XTDE1350");
                    dynamicError.setXPathContext(xPathContext);
                    throw dynamicError;
                }
                IntegerValue integerValue = (IntegerValue)calendarValue.getComponent(4);
                int n = (int)integerValue.longValue();
                if (n > 12) {
                    n -= 12;
                }
                if (n == 0) {
                    n = 12;
                }
                return FormatDate.formatNumber(string, n, string2, bl3, numberer, xPathContext);
            }
            case 'm': {
                if (bl2) {
                    DynamicError dynamicError = new DynamicError("In formatDate(): an xs:date value does not contain a minutes component");
                    dynamicError.setErrorCode("XTDE1350");
                    dynamicError.setXPathContext(xPathContext);
                    throw dynamicError;
                }
                IntegerValue integerValue = (IntegerValue)calendarValue.getComponent(5);
                return FormatDate.formatNumber(string, (int)integerValue.longValue(), string2, bl3, numberer, xPathContext);
            }
            case 's': {
                if (bl2) {
                    DynamicError dynamicError = new DynamicError("In formatDate(): an xs:date value does not contain a seconds component");
                    dynamicError.setErrorCode("XTDE1350");
                    dynamicError.setXPathContext(xPathContext);
                    throw dynamicError;
                }
                DecimalValue decimalValue = (DecimalValue)calendarValue.getComponent(6);
                return FormatDate.formatNumber(string, decimalValue.getValue().intValue(), string2, bl3, numberer, xPathContext);
            }
            case 'f': {
                if (bl2) {
                    DynamicError dynamicError = new DynamicError("In formatDate(): an xs:date value does not contain a fractional seconds component");
                    dynamicError.setErrorCode("XTDE1350");
                    dynamicError.setXPathContext(xPathContext);
                    throw dynamicError;
                }
                int n = (int)((IntegerValue)calendarValue.getComponent(11)).longValue();
                return FormatDate.formatNumber(string, n, string2, bl3, numberer, xPathContext);
            }
            case 'Z': {
                if (calendarValue.hasTimezone()) {
                    if (string2.startsWith("N")) {
                        return numberer.getTimezoneName(calendarValue.getTimezoneInMinutes());
                    }
                    if (string2.startsWith("n")) {
                        return numberer.getTimezoneName(calendarValue.getTimezoneInMinutes()).toLowerCase();
                    }
                    FastStringBuffer fastStringBuffer = new FastStringBuffer(8);
                    calendarValue.appendTimezone(fastStringBuffer);
                    return fastStringBuffer.toString();
                }
                return "";
            }
            case 'z': {
                if (calendarValue.hasTimezone()) {
                    int n = calendarValue.getTimezoneInMinutes();
                    return "GMT" + (n == 0 ? "" : (n > 0 ? "+" : "-") + Math.abs(n / 60) + (n % 60 == 0 ? "" : ".5"));
                }
                return "";
            }
            case 'F': {
                if (bl) {
                    DynamicError dynamicError = new DynamicError("In formatTime(): an xs:time value does not contain day-of-week component");
                    dynamicError.setErrorCode("XTDE1350");
                    dynamicError.setXPathContext(xPathContext);
                    throw dynamicError;
                }
                int n = DateValue.getDayOfWeek(dateTimeValue.getYear(), dateTimeValue.getMonth(), dateTimeValue.getDay());
                return FormatDate.formatNumber(string, n, string2, bl3, numberer, xPathContext);
            }
            case 'P': {
                if (bl2) {
                    DynamicError dynamicError = new DynamicError("In formatDate(): an xs:date value does not contain an am/pm component");
                    dynamicError.setErrorCode("XTDE1350");
                    dynamicError.setXPathContext(xPathContext);
                    throw dynamicError;
                }
                int n = dateTimeValue.getHour() * 60 + dateTimeValue.getMinute();
                return FormatDate.formatNumber(string, n, string2, bl3, numberer, xPathContext);
            }
            case 'C': {
                return "Gregorian";
            }
            case 'E': {
                if (bl) {
                    DynamicError dynamicError = new DynamicError("In formatTime(): an xs:time value does not contain an AD/BC component");
                    dynamicError.setErrorCode("XTDE1350");
                    dynamicError.setXPathContext(xPathContext);
                    throw dynamicError;
                }
                int n = dateTimeValue.getYear();
                return numberer.getEraName(n);
            }
        }
        DynamicError dynamicError = new DynamicError("Unknown formatDate/time component specifier '" + string2.charAt(0) + '\'');
        dynamicError.setErrorCode("XTDE1340");
        dynamicError.setXPathContext(xPathContext);
        throw dynamicError;
    }

    private static CharSequence formatNumber(String string, int n, String string2, boolean bl, Numberer numberer, XPathContext xPathContext) throws XPathException {
        Object object;
        int n2;
        int n3;
        Matcher matcher = formatPattern.matcher(string2);
        if (!matcher.matches()) {
            DynamicError dynamicError = new DynamicError("Unrecognized format picture [" + string + string2 + ']');
            dynamicError.setErrorCode("XTDE1340");
            dynamicError.setXPathContext(xPathContext);
            throw dynamicError;
        }
        String string3 = matcher.group(1);
        String string4 = null;
        if (string3.endsWith("t")) {
            string3 = string3.substring(0, string3.length() - 1);
            string4 = "t";
        } else if (string3.endsWith("o")) {
            string3 = string3.substring(0, string3.length() - 1);
            string4 = "o";
        }
        String string5 = "t".equals(string4) ? "traditional" : null;
        String string6 = "o".equals(string4) ? numberer.getOrdinalSuffixForDateTime(string) : null;
        String string7 = matcher.group(2);
        if (!alphanumericPattern.matcher(string3).matches()) {
            DynamicError dynamicError = new DynamicError("In format picture at '" + string3 + "', primary format must be alphanumeric");
            dynamicError.setErrorCode("XTDE1340");
            dynamicError.setXPathContext(xPathContext);
            throw dynamicError;
        }
        if (string7 == null || "".equals(string7)) {
            n3 = 1;
            n2 = Integer.MAX_VALUE;
        } else {
            object = FormatDate.getWidths(string7, xPathContext);
            n3 = object[0];
            n2 = object[1];
            if (bl && string3.endsWith("1") && n3 != string3.length()) {
                FastStringBuffer fastStringBuffer = new FastStringBuffer(n3 + 1);
                for (int i = 1; i < n3; ++i) {
                    fastStringBuffer.append('0');
                }
                fastStringBuffer.append('1');
                string3 = fastStringBuffer.toString();
            }
        }
        if ("P".equals(string)) {
            if (!("N".equals(string3) || "n".equals(string3) || "Nn".equals(string3))) {
                string3 = "n";
            }
        } else if ("f".equals(string)) {
            object = (1000000 + n + "").substring(1);
            if (((String)object).length() > n2) {
                object = ((String)object).substring(0, n2);
            }
            while (((String)object).length() < n3) {
                object = (String)object + '0';
            }
            while (((String)object).length() > n3 && ((String)object).charAt(((String)object).length() - 1) == '0') {
                object = ((String)object).substring(0, ((String)object).length() - 1);
            }
            return object;
        }
        if ("N".equals(string3) || "n".equals(string3) || "Nn".equals(string3)) {
            object = "";
            if ("M".equals(string)) {
                object = numberer.monthName(n, n3, n2);
            } else if ("F".equals(string)) {
                object = numberer.dayName(n, n3, n2);
            } else if ("P".equals(string)) {
                object = numberer.halfDayName(n, n3, n2);
            } else {
                string3 = "1";
            }
            if ("N".equals(string3)) {
                return ((String)object).toUpperCase();
            }
            if ("n".equals(string3)) {
                return ((String)object).toLowerCase();
            }
            return object;
        }
        object = numberer.format(n, string3, 0, ",", string5, string6);
        while (((String)object).length() < n3) {
            object = ("00000000" + (String)object).substring(((String)object).length() + 8 - n3);
        }
        if (((String)object).length() > n2 && string.charAt(0) == 'Y') {
            object = ((String)object).substring(((String)object).length() - n2);
        }
        return object;
    }

    private static int[] getWidths(String string, XPathContext xPathContext) throws XPathException {
        try {
            Object object;
            int n = -1;
            int n2 = -1;
            if (!"".equals(string)) {
                object = widthPattern.matcher(string);
                if (((Matcher)object).matches()) {
                    String string2 = ((Matcher)object).group(1);
                    n = string2 == null || "".equals(string2) || "*".equals(string2) ? 1 : Integer.parseInt(string2);
                    String string3 = ((Matcher)object).group(3);
                    n2 = string3 == null || "".equals(string3) || "*".equals(string3) ? Integer.MAX_VALUE : Integer.parseInt(string3);
                } else {
                    DynamicError dynamicError = new DynamicError("Unrecognized width specifier");
                    dynamicError.setErrorCode("XTDE1340");
                    dynamicError.setXPathContext(xPathContext);
                    throw dynamicError;
                }
            }
            if (n > n2 && n2 != -1) {
                object = new DynamicError("Minimum width in date/time picture exceeds maximum width");
                ((XPathException)object).setErrorCode("XTDE1340");
                ((DynamicError)object).setXPathContext(xPathContext);
                throw object;
            }
            object = new int[2];
            object[0] = n;
            object[1] = n2;
            return object;
        }
        catch (NumberFormatException numberFormatException) {
            DynamicError dynamicError = new DynamicError("Invalid integer used as width in date/time picture");
            dynamicError.setErrorCode("XTDE1340");
            dynamicError.setXPathContext(xPathContext);
            throw dynamicError;
        }
    }
}

