/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.mcm.raftsim;

import java.io.Serializable;
import java.time.Duration;
import java.util.Random;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.lsst.ccs.UsesSubsystem;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystem.mcm.data.RaftState;
import org.lsst.ccs.subsystem.mcm.data.RaftStatus;
import org.lsst.ccs.subsystem.mcm.raftsim.RaftInternalState;
import org.lsst.ccs.utilities.logging.Logger;

public class RaftSim
extends Module
implements UsesSubsystem {
    private RaftInternalState state = RaftInternalState.NEEDS_CLEAR;
    private final ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(4);
    protected static final Logger log = Logger.getLogger((String)"org.lsst.ccs.subsystem.mcm");
    private double temp = -100.0;
    private double dtemp = 0.0;
    private double d2temp = 0.0;
    private Random random = new Random();

    public void initModule() {
        this.getSubsystem().updateAgentState(new Enum[]{this.getPublicState()});
    }

    @Command
    public void clear() {
        log.info((Object)"RaftSim command: clear");
        this.setState(this.state.clear(this));
    }

    @Command
    public void clear(int n) {
        log.info((Object)("RaftSim command: clear repeat " + n));
        this.setState(this.state.clear(this));
    }

    @Command
    public void discardRows(int n) {
        log.info((Object)"RaftSim command: discardRows");
        this.setState(this.state.discardRows(this));
    }

    @Command
    public void integrate() {
        log.info((Object)"RaftSim command: integrate");
        this.setState(this.state.integrate(this));
    }

    @Command
    public void readout() {
        log.info((Object)"RaftSim command: readout");
        this.setState(this.state.readout(this));
    }

    @Command
    public void triggerAlarm() {
        this.getSubsystem().raiseAlert(new Alert("RAFT001", "raft alarm"), AlertState.ALARM, "raft alarm");
    }

    @Command
    public void clearAlarm() {
        this.getSubsystem().clearAlerts(new String[]{"RAFT001"});
    }

    RaftState getPublicState() {
        return RaftState.valueOf((String)this.state.toString());
    }

    public void setState(RaftInternalState s) {
        if (this.state == s) {
            return;
        }
        this.state.exit(this);
        this.state = s;
        this.state.enter(this);
        this.getSubsystem().updateAgentState(new Enum[]{this.state, this.getPublicState()});
        log.info((Object)("RaftSim state: " + this.getPublicState()));
    }

    public ScheduledFuture<RaftInternalState> scheduleTransition(Duration delay, RaftInternalState to) {
        log.debug((Object)(" scheduling to " + to + " delay " + delay));
        return this.scheduler.schedule(() -> RaftInternalState.scheduled(this, this.state, to), delay.toMillis(), TimeUnit.MILLISECONDS);
    }

    Logger getLogger() {
        return log;
    }

    public void tick() {
        this.d2temp = 1.0 - 2.0 * this.random.nextDouble();
        this.d2temp /= 5.0;
        if (this.temp < -110.0) {
            this.d2temp += 0.2;
            this.dtemp = 0.0;
        } else if (this.temp > -90.0) {
            this.d2temp += -0.2;
            this.dtemp = 0.0;
        }
        this.dtemp += this.d2temp;
        this.temp += this.dtemp;
        RaftStatus s = new RaftStatus();
        s.setTemperature(this.temp);
        log.debug((Object)("publish temp " + this.temp + "(" + this.dtemp + "," + this.d2temp + ")"));
        KeyValueData d = new KeyValueData("raftStatus", (Serializable)s);
        this.getSubsystem().publishSubsystemDataOnStatusBus(d);
    }
}

