/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.startup;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Resource;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.bus.messages.StatusHeartBeat;
import org.lsst.ccs.bus.states.AgentState;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.CommandSetBuilder;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.config.ConfigurableSubsystem;
import org.lsst.ccs.config.ConfigurationProxy;
import org.lsst.ccs.config.ParameterPath;
import org.lsst.ccs.description.ComponentLookupService;
import org.lsst.ccs.description.EffectiveNode;
import org.lsst.ccs.framework.BulkSettingException;
import org.lsst.ccs.framework.Configurable;
import org.lsst.ccs.framework.HardwareController;
import org.lsst.ccs.framework.PackCst;
import org.lsst.ccs.framework.Signal;
import org.lsst.ccs.framework.SignalHandler;
import org.lsst.ccs.framework.SignalLevel;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.framework.annotations.ParameterSetter;
import org.lsst.ccs.startup.ConfigurationEnvironment;
import org.lsst.ccs.utilities.logging.Logger;

public class NodeModularSubsystem
extends ConfigurableSubsystem {
    private final ComponentLookupService lookup;
    private static final Logger mod_log = Logger.getLogger((String)"org.lsst.ccs.startup");

    NodeModularSubsystem(String subsystemName, ConfigurationProxy configurationProxy, EffectiveNode effectiveNode, ConfigurationState initialState, Map<String, ParameterSetter> configChangerDictionary) {
        super(subsystemName, configurationProxy, initialState, configChangerDictionary);
        this.lookup = new ComponentLookupService(effectiveNode);
        this.lookup.proceduralNodeWalk(null, null, node -> {
            String key = node.getKey();
            Object value = node.getRealValue();
            if (value instanceof Configurable) {
                Configurable configurable = (Configurable)value;
                configurable.setEnvironment((Configurable.Environment)new ConfigurationEnvironment(key, this.getConfigurationProxy(), this.lookup, this));
            }
        });
        this.doInitComponents();
    }

    protected void updateHeartBeat(StatusHeartBeat s) {
    }

    public ComponentLookupService getLookup() {
        return this.lookup;
    }

    private void doInitComponents() {
        this.lookup.proceduralNodeWalk(null, node -> {
            String nodeName = node.getKey();
            Object component = node.getRealValue();
            this.injectResources(component, nodeName);
            if (component instanceof Configurable) {
                ((Configurable)component).init();
            }
            CommandSet commandSet = new CommandSetBuilder().buildCommandSet(node.getRealValue());
            String fullPath = this.lookup.getFullPathFor(node.getKey());
            this.addCommandSet(fullPath, commandSet);
        }, null);
    }

    private void injectResources(Object obj, String nodeName) {
        Class<?> clazz = obj.getClass();
        while (clazz.getCanonicalName().startsWith("org.lsst")) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                Object toInject;
                Resource resource = field.getAnnotation(Resource.class);
                if (resource == null) continue;
                String name = resource.name();
                if (name == null || "".equals(name)) {
                    name = field.getName();
                }
                if ((toInject = this.lookup.getComponentByName(name)) == null) {
                    PackCst.CURLOG.warn((Object)("In " + nodeName + " : No component found for " + name));
                    continue;
                }
                try {
                    field.setAccessible(true);
                    field.set(obj, toInject);
                    PackCst.CURLOG.info((Object)(toInject + " object injected in " + name + "field  "));
                }
                catch (IllegalAccessException e) {
                    PackCst.CURLOG.warn((Object)(nodeName + " No possible injection for " + name), (Throwable)e);
                }
            }
            clazz = clazz.getSuperclass();
        }
    }

    public void doStart() {
        super.doStart();
        this.lookup.proceduralWalk(null, Configurable.class, Configurable::start, null);
    }

    public void postStart() throws HardwareException {
        HardwareException[] exc = new HardwareException[]{null};
        this.lookup.proceduralWalk(null, Configurable.class, c -> {
            try {
                c.postStart();
            }
            catch (HardwareException e) {
                exc[0] = new HardwareException(c.toString() + " at postStart", (Throwable)e, exc[0]);
            }
        }, null);
        if (exc[0] != null) {
            throw exc[0];
        }
    }

    public void doShutdown() {
        mod_log.fine((Object)("Subsystem " + this.getName() + " shutdown starting"));
        this.lookup.proceduralWalk(null, Configurable.class, Configurable::shutdownNow, null);
    }

    @Command(description="halt", type=Command.CommandType.SIGNAL)
    public void abort() {
        super.abort();
        this.sendSignal(new Signal(SignalLevel.HALT));
    }

    @Command(description="halt with expected max delay", type=Command.CommandType.SIGNAL)
    public void abort(long expectedMaxDelay) {
        super.abort();
        this.sendSignal(new Signal(SignalLevel.HALT, expectedMaxDelay));
    }

    @Command(description="stops with expected max delay", type=Command.CommandType.ACTION)
    public void stop(long expectedMaxDelay) throws HardwareException {
        super.stop(expectedMaxDelay);
        this.sendSignal(new Signal(SignalLevel.STOP, expectedMaxDelay));
    }

    @Command(description="stops hardware", type=Command.CommandType.ACTION)
    public void stop() throws HardwareException {
        this.stop(Long.MAX_VALUE);
    }

    private void sendSignal(Signal signal) {
        this.lookup.treeWalk(null, SignalHandler.class, sh -> sh.signal(signal), null);
    }

    @Command(description="waits until all the hardware devices are actually stopped", type=Command.CommandType.ACTION)
    public void stopAndWait(long expectedMaxDelay) throws HardwareException, InterruptedException {
        this.stop(expectedMaxDelay);
        int step = 10;
        long fracDelay = expectedMaxDelay / (long)step;
        HardwareException lastExc = null;
        for (int i = 0; i < step; ++i) {
            try {
                Thread.sleep(fracDelay);
                this.checkAllHardwareStopped();
                return;
            }
            catch (HardwareException e) {
                lastExc = e;
                continue;
            }
        }
        throw lastExc;
    }

    public void checkHardware() throws HardwareException {
        HardwareException[] exc = new HardwareException[]{null};
        this.lookup.treeWalk(null, HardwareController.class, hc -> {
            try {
                return hc.checkHardware();
            }
            catch (HardwareException e) {
                exc[0] = new HardwareException(hc.toString() + "not started ", (Throwable)e, exc[0]);
                if (e.isFatal()) {
                    return TreeWalkerDiag.STOP;
                }
                return TreeWalkerDiag.GO;
            }
        }, null);
        if (exc[0] != null) {
            throw exc[0];
        }
    }

    public void checkAllHardwareStarted() throws HardwareException {
        HardwareException[] exc = new HardwareException[]{null};
        this.lookup.proceduralWalk(null, HardwareController.class, hc -> {
            try {
                hc.checkStarted();
            }
            catch (HardwareException e) {
                exc[0] = new HardwareException(hc.toString() + "not started ", (Throwable)e, exc[0]);
            }
        }, null);
        if (exc[0] != null) {
            throw exc[0];
        }
    }

    public void checkAllHardwareStopped() throws HardwareException {
        HardwareException[] exc = new HardwareException[]{null};
        this.lookup.proceduralWalk(null, HardwareController.class, hc -> {
            try {
                hc.checkStopped();
            }
            catch (HardwareException e) {
                exc[0] = new HardwareException(hc.toString() + "not started ", (Throwable)e, exc[0]);
            }
        }, null);
        if (exc[0] != null) {
            throw exc[0];
        }
    }

    @Command(description="processes the bulk change", type=Command.CommandType.CONFIGURATION)
    public void commitBulkChange() {
        this.validateBulkChanges();
        Set<ParameterPath> processedParms = this.bulkChange();
        this.updateStateAndSendStatusConfigurationInfo("", processedParms);
        mod_log.info((Object)(processedParms.size() + " successfully set parameters"));
    }

    protected void validateBulkChanges() {
        this.lookup.proceduralNodeWalk(null, null, node -> {
            String nodeName = node.getKey();
            ParameterSetter parmSetter = (ParameterSetter)this.parameterSetterDictionary.get(nodeName);
            if (!parmSetter.hasSubmittedChanges()) {
                return;
            }
            Map parametersView = this.configurationProxy.getCurrentValuesForComponent(nodeName, Collections.emptySet());
            parmSetter.invokeValidateBulkChange(parametersView, this.isInState((Enum)PhaseState.OPERATIONAL));
        });
    }

    protected Set<ParameterPath> bulkChange() {
        this.updateInternalState("", new AgentState[]{ConfigurationState.CONFIGURING});
        final HashSet<ParameterPath> processedParms = new HashSet<ParameterPath>();
        this.lookup.proceduralNodeWalk(null, null, (Consumer)new Consumer<EffectiveNode>(){

            @Override
            public void accept(EffectiveNode node) {
                String nodeName = node.getKey();
                ParameterSetter parmSetter = (ParameterSetter)NodeModularSubsystem.this.parameterSetterDictionary.get(nodeName);
                try {
                    Map processedParmsForComponent = parmSetter.invokeSetParameters();
                    for (Map.Entry entry : processedParmsForComponent.entrySet()) {
                        NodeModularSubsystem.this.configurationProxy.notifyParameterChange(nodeName, (String)entry.getKey(), (String)entry.getValue());
                        processedParms.add(new ParameterPath(nodeName, "", (String)entry.getKey()));
                    }
                }
                catch (BulkSettingException ex) {
                    if (ex.isFatal()) {
                        NodeModularSubsystem.this.updateInternalState("", new AgentState[]{ConfigurationState.UNCONFIGURED});
                        throw ex;
                    }
                    Map processedParmsForComponent = ex.getProcessedParms();
                    for (Map.Entry entry : processedParmsForComponent.entrySet()) {
                        NodeModularSubsystem.this.configurationProxy.notifyParameterChange(nodeName, (String)entry.getKey(), (String)entry.getValue());
                        processedParms.add(new ParameterPath(nodeName, "", (String)entry.getKey()));
                    }
                    NodeModularSubsystem.this.updateStateAndSendStatusConfigurationInfo(ex.getMessage(), processedParms);
                    throw ex;
                }
            }
        });
        return processedParms;
    }
}

