/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.startup;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.lsst.ccs.CCSCst;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.config.AParameterDescription;
import org.lsst.ccs.config.ConfigProfile;
import org.lsst.ccs.config.ConfigurableSubsystem;
import org.lsst.ccs.config.ConfigurationProxy;
import org.lsst.ccs.config.Factories;
import org.lsst.ccs.config.LocalConfigurationProxy;
import org.lsst.ccs.config.ParameterBase;
import org.lsst.ccs.config.ParameterConfiguration;
import org.lsst.ccs.config.ParameterDescription;
import org.lsst.ccs.config.ParameterPath;
import org.lsst.ccs.config.SubsystemDescription;
import org.lsst.ccs.config.utilities.ConfigUtils;
import org.lsst.ccs.description.ComponentNodeBuilder;
import org.lsst.ccs.description.DescriptiveNode;
import org.lsst.ccs.description.EffectiveNode;
import org.lsst.ccs.framework.annotations.ParameterSetter;
import org.lsst.ccs.framework.annotations.ParameterSetterBuilder;
import org.lsst.ccs.startup.NodeModularSubsystem;
import org.lsst.ccs.utilities.constraints.Constraints;
import org.lsst.ccs.utilities.conv.InputConversionEngine;
import org.lsst.ccs.utilities.conv.TypeConversionException;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.reflect.ConstructorUtils;
import org.lsst.gruth.jutils.HollowParm;
import org.lsst.gruth.jutils.NamedRefParm;

public class BootUtils {
    private static final Map<String, ParameterSetter> PARAMETER_SETTER_DICTIONARY = new HashMap<String, ParameterSetter>();

    private BootUtils() {
    }

    public static SubsystemDescription buildSubsystemDescription(String subsystemName, String tagName, DescriptiveNode descriptiveNode) {
        SubsystemDescription res = Factories.createRawSubsystemDescription((String)subsystemName, (String)tagName, (Serializable)descriptiveNode);
        ArrayList list = new ArrayList();
        descriptiveNode.proceduralNodeWalk(node -> list.addAll(BootUtils.parameterDescriptionsFromNode(node)), null);
        res.addParameterDescriptions(list);
        return res;
    }

    private static Collection<ParameterDescription> parameterDescriptionsFromNode(DescriptiveNode node) {
        ArrayList<ParameterDescription> res = new ArrayList<ParameterDescription>();
        Map attributes = node.getAttributes();
        String nodeKey = node.getKey();
        Class klass = (Class)node.getRealValue();
        ParameterSetter parmSetterForNode = ParameterSetterBuilder.buildParameterSetterFromClass((Class)klass);
        PARAMETER_SETTER_DICTIONARY.put(nodeKey, parmSetterForNode);
        Set entrySet = parmSetterForNode.getParameterFields().entrySet();
        for (Map.Entry entry : entrySet) {
            String parmName = (String)entry.getKey();
            ConfigurationParameter a = ((Field)entry.getValue()).getAnnotation(ConfigurationParameter.class);
            String defaultValue = "";
            ParameterBase base = new ParameterBase(nodeKey, "", parmName, ((Field)entry.getValue()).getGenericType().getTypeName(), defaultValue);
            String description = a.description();
            String simpleName = "";
            String category = a.category();
            AParameterDescription parmDescription = new AParameterDescription(base, description, simpleName, category, 0);
            res.add((ParameterDescription)parmDescription);
        }
        if (attributes != null) {
            ArrayList<String> unannotatedparms = new ArrayList<String>();
            Constructor ctorForNode = node.getConstructor();
            int attributeIndex = 0;
            for (Map.Entry entry : attributes.entrySet()) {
                HollowParm hollow;
                Object val = entry.getValue();
                String parmName = (String)entry.getKey();
                if ("name".equalsIgnoreCase(parmName) || val instanceof NamedRefParm) {
                    ++attributeIndex;
                    continue;
                }
                if (val instanceof HollowParm && !(hollow = (HollowParm)val).isReadOnly() && !parmSetterForNode.getParameterFields().containsKey(parmName)) {
                    unannotatedparms.add(parmName);
                    Type type = ConstructorUtils.getParameterType((Constructor)ctorForNode, (int)attributeIndex);
                    parmSetterForNode.addTypeForParm(parmName, type);
                    ParameterBase base = new ParameterBase(nodeKey, "", parmName, type.getTypeName(), hollow.toString());
                    String description = "";
                    String simpleName = "";
                    String constraints = "";
                    String category = "";
                    boolean notModifiableAtRuntime = false;
                    int level = 0;
                    Properties props = hollow.getProperties();
                    if (props != null) {
                        String isStatic;
                        description = props.getProperty("description", "");
                        simpleName = props.getProperty("simpleName", "");
                        constraints = props.getProperty("constraints", "");
                        try {
                            Constraints.check((Object)new InputConversionEngine().convertArgToType(base.getDefaultValue(), type), (String)constraints);
                        }
                        catch (TypeConversionException ex) {
                            throw new IllegalArgumentException(ex.getMessage(), ex);
                        }
                        parmSetterForNode.addConstraint(parmName, constraints);
                        category = props.getProperty("category", "");
                        String request = props.getProperty("level");
                        if (request != null) {
                            level = Integer.parseInt(request);
                        }
                        if ((isStatic = props.getProperty("static")) != null) {
                            notModifiableAtRuntime = Boolean.valueOf(isStatic);
                        }
                    }
                    parmSetterForNode.addFinalPropForParm(parmName, notModifiableAtRuntime);
                    AParameterDescription parmDescription = new AParameterDescription(base, description, simpleName, category, level);
                    res.add((ParameterDescription)parmDescription);
                }
                ++attributeIndex;
            }
            if (!unannotatedparms.isEmpty()) {
                Logger.getLogger((String)"org.lsst.ccs.startup").fine((Object)("unannotated parameters for component " + nodeKey + " : " + unannotatedparms));
            }
        }
        return res;
    }

    public static Subsystem getSubsystemFromFile(String descriptionName) throws Exception {
        return BootUtils.getSubsystemFromFile(descriptionName, null);
    }

    public static Subsystem getSubsystemFromFile(String descriptionName, String configName) throws Exception {
        return BootUtils.getSubsystemFromFile(descriptionName, configName, null);
    }

    public static Subsystem getSubsystemFromFile(String pathName, String propertiesFileName, String subsystemAlias) throws Exception {
        return new LocalBootObject(pathName, propertiesFileName, subsystemAlias).getSubsystem();
    }

    public static void saveInCache(DescriptiveNode node, String subsystemName, String configName, String tag) {
    }

    public static DescriptiveNode getLatestInCache() {
        return null;
    }

    public static void bootFromCache() {
        throw new UnsupportedOperationException("bootFromCache");
    }

    public static void modifyDescriptiveNode(DescriptiveNode topNode, Set<? extends ParameterConfiguration> parmConfigs) {
        Iterator<? extends ParameterConfiguration> iterator = parmConfigs.iterator();
        while (iterator.hasNext()) {
            ParameterConfiguration parameterConfiguration = iterator.next();
            ParameterPath path = parameterConfiguration.getPath();
            String componentName = path.getComponentName();
            String codeName = path.getCodeName();
            if (codeName != null && !"".equals(codeName)) {
                throw new UnsupportedOperationException(" no change on methods yet --> " + codeName);
            }
            String parameterName = path.getParameterName();
            DescriptiveNode goalComponent = (DescriptiveNode)topNode.getNodeByName(componentName);
            if (goalComponent == null) {
                throw new IllegalArgumentException("no component for name :" + componentName);
            }
            Map mapAttributes = goalComponent.getAttributes();
            if (mapAttributes == null) {
                throw new IllegalArgumentException("incompatible attribute list for component//parameter " + path);
            }
            Object rawParm = mapAttributes.get(parameterName);
            if (rawParm == null || PARAMETER_SETTER_DICTIONARY.get(componentName).getParameterFields().containsKey(parameterName)) continue;
            if (rawParm instanceof HollowParm) {
                HollowParm hollow = (HollowParm)rawParm;
                ParameterSetter parmSetter = PARAMETER_SETTER_DICTIONARY.get(componentName);
                try {
                    hollow.modifyChecked((Serializable)new InputConversionEngine().convertArgToType(parameterConfiguration.getConfiguredValue(), parmSetter.getTypeForParm(parameterName)));
                }
                catch (TypeConversionException ex) {
                    throw new IllegalArgumentException(ex.getMessage(), ex);
                }
                iterator.remove();
                continue;
            }
            throw new IllegalArgumentException("parameter not modifiable" + rawParm);
        }
    }

    static void modifyEffectiveNode(EffectiveNode node, Set<ParameterConfiguration> parmConfigs, ConfigurationProxy proxy) {
        Map<String, Map<String, String>> parmConfigByComponent = parmConfigs.stream().collect(Collectors.groupingBy(pc -> pc.getPath().getComponentName(), Collectors.toMap(pc -> pc.getPath().getParameterName(), pc -> pc.getConfiguredValue())));
        node.proceduralNodeWalk(n -> {
            Object innerObj = n.getRealValue();
            String nodeName = n.getKey();
            ParameterSetter parmSetter = PARAMETER_SETTER_DICTIONARY.get(nodeName);
            parmSetter.setTarget(innerObj);
            Map annotatedFields = parmSetter.getParameterFields();
            for (Map.Entry entry : annotatedFields.entrySet()) {
                Object val;
                String string = (String)entry.getKey();
                Field f = (Field)entry.getValue();
                try {
                    f.setAccessible(true);
                    val = f.get(innerObj);
                }
                catch (IllegalAccessException ex) {
                    throw new RuntimeException("failure setting parameter : " + ex.getMessage(), ex);
                }
                String constraint = parmSetter.getConstraintFor(string);
                if (constraint != null) {
                    Constraints.check((Object)val, (String)constraint);
                }
                proxy.setDefaultValueForParameter(nodeName, string, val);
            }
            Map toValidate = (Map)parmConfigByComponent.get(nodeName);
            if (toValidate == null || toValidate.isEmpty()) {
                return;
            }
            for (Map.Entry entry : toValidate.entrySet()) {
                try {
                    parmSetter.submitChange((String)entry.getKey(), entry.getValue());
                }
                catch (TypeConversionException ex) {
                    throw new IllegalArgumentException("wrong parameter string representation for : " + (String)entry.getKey(), ex);
                }
            }
            parmSetter.invokeValidateBulkChange(proxy.getCurrentValuesForComponent(nodeName, Collections.emptySet()), false);
            try {
                parmSetter.invokeSetParameters();
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("failure setting parameter : " + exception.getMessage(), exception);
            }
        }, null);
    }

    public static void checkStaticCompatibleConfiguration(ConfigProfile profile) throws Exception {
        DescriptiveNode node = (DescriptiveNode)profile.getSubsystemDescription().getDescriptionData();
        Set parmConfigs = profile.getModifiedParameters();
        HashSet modifiableParmConfigs = new HashSet(parmConfigs);
        BootUtils.modifyDescriptiveNode(node, modifiableParmConfigs);
        ComponentNodeBuilder.buildEffectiveNode((DescriptiveNode)node);
    }

    private static class LocalBootObject {
        private DescriptiveNode descriptiveNode;
        private EffectiveNode effectiveNode;
        private ConfigurableSubsystem subsystem;
        private final String subsystemName;
        private final String[] taggedCategories;
        private String tagName;

        LocalBootObject(String pathName) throws Exception {
            this(pathName, "");
        }

        LocalBootObject(String fullDescription, String config) throws Exception {
            this(fullDescription, config, null);
        }

        LocalBootObject(String fullDescription, String config, String subsystemAlias) throws Exception {
            if (config == null) {
                config = "";
            }
            if (config.contains("/")) {
                throw new IllegalArgumentException("configuration files must be located at the root of a resource directory");
            }
            if (config.contains(".")) {
                throw new IllegalArgumentException("configuration input must be the name of the configuration only");
            }
            this.descriptiveNode = ComponentNodeBuilder.buildDescriptiveNode((String)fullDescription);
            this.subsystemName = subsystemAlias == null ? this.descriptiveNode.getSubsystemName() : subsystemAlias;
            this.taggedCategories = config.split(",");
            this.tagName = fullDescription;
            if (fullDescription.contains(":")) {
                this.tagName = fullDescription.substring(fullDescription.indexOf(58) + 1);
            }
            CCSCst.LOG_TODO.fine((Object)"TODO: Configuration proxy should also be able to interact with remote database (switch between local and remote?)");
            SubsystemDescription subsystemDescription = BootUtils.buildSubsystemDescription(this.subsystemName, this.tagName, this.descriptiveNode);
            LocalConfigurationProxy proxy = new LocalConfigurationProxy(subsystemDescription);
            Map.Entry stateAndParmConfigs = proxy.getInitialParameterConfigurations(ConfigUtils.parseConfigurationStringWithDefaults((Set)subsystemDescription.getCategorySet(), (String[])this.taggedCategories));
            BootUtils.modifyDescriptiveNode(this.descriptiveNode, (Set)stateAndParmConfigs.getValue());
            this.effectiveNode = ComponentNodeBuilder.buildEffectiveNode((DescriptiveNode)this.descriptiveNode);
            BootUtils.modifyEffectiveNode(this.effectiveNode, (Set)stateAndParmConfigs.getValue(), (ConfigurationProxy)proxy);
            this.subsystem = new NodeModularSubsystem(this.subsystemName, (ConfigurationProxy)proxy, this.effectiveNode, (ConfigurationState)stateAndParmConfigs.getKey(), PARAMETER_SETTER_DICTIONARY);
        }

        public Subsystem getSubsystem() {
            return this.subsystem;
        }

        public String getSubsystemName() {
            return this.subsystemName;
        }

        public String getTagName() {
            return this.tagName;
        }
    }
}

