/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.gruth.jutils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.runtime.GStringImpl;
import org.lsst.ccs.description.IndirectMap;
import org.lsst.ccs.utilities.conv.TypeUtils;
import org.lsst.gruth.jutils.ArrayParm;
import org.lsst.gruth.jutils.BoolParm;
import org.lsst.gruth.jutils.BuiltParm;
import org.lsst.gruth.jutils.DblParm;
import org.lsst.gruth.jutils.EmptyParmException;
import org.lsst.gruth.jutils.HollowParm;
import org.lsst.gruth.jutils.IntParm;
import org.lsst.gruth.jutils.ListParm;
import org.lsst.gruth.jutils.MapParm;
import org.lsst.gruth.jutils.NamedRefParm;
import org.lsst.gruth.jutils.ParmStructureException;
import org.lsst.gruth.jutils.Property;
import org.lsst.gruth.jutils.StringParm;
import org.lsst.gruth.jutils.ValParm;

public class MapArgs
implements Map<String, Object>,
Iterable<Object>,
Serializable,
Cloneable {
    private final LEntry[] entries;
    private final Object[] vals;
    public static final MapArgs EMPTY_MAPARGS = new MapArgs(new LEntry[0]);

    private MapArgs(LEntry ... entries) {
        this.entries = entries;
        int size = entries.length;
        this.vals = new Object[size];
        int ix = 0;
        while (ix < size) {
            LEntry lentry = entries[ix];
            if (lentry == null) {
                throw new IllegalArgumentException("ambiguous null value in arg number " + (ix + 1) + ": use declaration such as 'null as String'");
            }
            this.vals[ix] = lentry.value;
            ++ix;
        }
    }

    private MapArgs(Object ... values) {
        this.vals = values;
        this.entries = new LEntry[0];
    }

    private static LEntry _m(String key, Object value) {
        return new LEntry(key, value);
    }

    public static MapArgs argMap() {
        return new MapArgs(new LEntry[0]);
    }

    public static MapArgs argMap(LEntry ... args) {
        return new MapArgs(args);
    }

    public static MapArgs argMap(Object ... args) {
        LEntry[] entries = new LEntry[args.length];
        int ix = 0;
        while (ix < args.length) {
            Object obj = args[ix];
            if (obj instanceof LEntry) {
                entries[ix] = (LEntry)obj;
            } else {
                if (obj instanceof GStringImpl) {
                    obj = ((GStringImpl)obj).toString();
                }
                entries[ix] = MapArgs.a(String.valueOf(ix), obj);
            }
            ++ix;
        }
        return new MapArgs(entries);
    }

    public static LEntry a(String key, Object value) {
        return MapArgs._m(key, value);
    }

    public static LEntry aString(String key, String value) {
        return MapArgs._m(key, new StringParm(value));
    }

    public static LEntry aString(String key, String value, Map<?, ?> map) {
        return MapArgs._m(key, new StringParm(value, map));
    }

    public static LEntry aString(String key) {
        return MapArgs._m(key, new StringParm());
    }

    public static LEntry aRef(String key, String value) {
        return MapArgs._m(key, new NamedRefParm(value));
    }

    public static LEntry aRef(String key, String value, Map<?, ?> map) {
        return MapArgs._m(key, new NamedRefParm(value, map));
    }

    public static LEntry ref(String key) {
        return MapArgs._m(key, new NamedRefParm(true, key));
    }

    public static LEntry aRef(String key) {
        return MapArgs._m(key, new NamedRefParm());
    }

    public static LEntry anInt(String key, Integer value) {
        return MapArgs._m(key, new IntParm(value));
    }

    public static LEntry anInt(String key, Integer value, Map<?, ?> map) {
        return MapArgs._m(key, new IntParm(value, map));
    }

    public static LEntry anInt(String key, String strVal) {
        return MapArgs._m(key, new IntParm(strVal));
    }

    public static LEntry anInt(String key, String strVal, Map<?, ?> map) {
        return MapArgs._m(key, new IntParm(strVal, map));
    }

    public static LEntry anInt(String key) {
        return MapArgs._m(key, new IntParm());
    }

    public static LEntry aBool(String key, Boolean value) {
        return MapArgs._m(key, new BoolParm(value));
    }

    public static LEntry aBool(String key, Boolean value, Map<?, ?> map) {
        return MapArgs._m(key, new BoolParm(value, map));
    }

    public static LEntry aBool(String key, String strVal) {
        return MapArgs._m(key, new BoolParm(strVal));
    }

    public static LEntry aBool(String key, String strVal, Map<?, ?> map) {
        return MapArgs._m(key, new BoolParm(strVal, map));
    }

    public static LEntry aBool(String key) {
        return MapArgs._m(key, new BoolParm());
    }

    public static LEntry aDbl(String key, Double value) {
        return MapArgs._m(key, new DblParm(value));
    }

    public static LEntry aDbl(String key, Double value, Map<?, ?> map) {
        return MapArgs._m(key, new DblParm(value, map));
    }

    public static LEntry aDbl(String key, BigDecimal value) {
        return MapArgs._m(key, new DblParm(value));
    }

    public static LEntry aDbl(String key, BigDecimal value, Map<?, ?> map) {
        return MapArgs._m(key, new DblParm(value, map));
    }

    public static LEntry aDbl(String key, String strVal) {
        return MapArgs._m(key, new DblParm(strVal));
    }

    public static LEntry aDbl(String key, String strVal, Map<?, ?> map) {
        return MapArgs._m(key, new DblParm(strVal, map));
    }

    public static LEntry aDbl(String key) {
        return MapArgs._m(key, new DblParm());
    }

    public static LEntry aList(String key, List list) {
        return MapArgs._m(key, new ListParm(list));
    }

    public static LEntry aList(String key, double[] arrayDouble) {
        return MapArgs.aList(key, Arrays.asList(new double[][]{arrayDouble}));
    }

    public static LEntry aList(String key, float[] arrayFloat) {
        return MapArgs.aList(key, Arrays.asList(new float[][]{arrayFloat}));
    }

    public static LEntry aList(String key, List list, Map<?, ?> map) {
        return MapArgs._m(key, new ListParm(list, map));
    }

    public static LEntry aMap(String key, Map map) {
        return MapArgs._m(key, new MapParm(map));
    }

    public static LEntry aMap(String key, Map map, Map props) {
        return MapArgs._m(key, new MapParm(map, props));
    }

    public static LEntry anArray(String key, int[] array) {
        return MapArgs._m(key, new ArrayParm<int[]>(int[].class, array));
    }

    public static LEntry anArray(String key, int[] array, Map map) {
        return MapArgs._m(key, new ArrayParm<int[]>(int[].class, array, map));
    }

    public static LEntry anArray(String key, byte[] array) {
        return MapArgs._m(key, new ArrayParm<byte[]>(byte[].class, array));
    }

    public static LEntry anArray(String key, byte[] array, Map map) {
        return MapArgs._m(key, new ArrayParm<byte[]>(byte[].class, array, map));
    }

    public static LEntry anArray(String key, char[] array) {
        return MapArgs._m(key, new ArrayParm<char[]>(char[].class, array));
    }

    public static LEntry anArray(String key, char[] array, Map map) {
        return MapArgs._m(key, new ArrayParm<char[]>(char[].class, array, map));
    }

    public static LEntry anArray(String key, float[] array) {
        return MapArgs._m(key, new ArrayParm<float[]>(float[].class, array));
    }

    public static LEntry anArray(String key, float[] array, Map map) {
        return MapArgs._m(key, new ArrayParm<float[]>(float[].class, array, map));
    }

    public static LEntry anArray(String key, double[] array) {
        return MapArgs._m(key, new ArrayParm<double[]>(double[].class, array));
    }

    public static LEntry anArray(String key, double[] array, Map map) {
        return MapArgs._m(key, new ArrayParm<double[]>(double[].class, array, map));
    }

    public static LEntry anArray(String key, boolean[] array) {
        return MapArgs._m(key, new ArrayParm<boolean[]>(boolean[].class, array));
    }

    public static LEntry anArray(String key, boolean[] array, Map map) {
        return MapArgs._m(key, new ArrayParm<boolean[]>(boolean[].class, array, map));
    }

    public static LEntry anArray(String key, Object[] array) {
        return MapArgs._m(key, new ArrayParm<Object[]>(Object[].class, array));
    }

    public static LEntry anArray(String key, Object[] array, Map map) {
        return MapArgs._m(key, new ArrayParm<Object[]>(Object[].class, array, map));
    }

    public static LEntry aVal(String key, Serializable val) {
        return MapArgs._m(key, new ValParm(val));
    }

    public static LEntry aVal(String key, Serializable val, Map properties) {
        return MapArgs._m(key, new ValParm(val, properties));
    }

    public static LEntry aVal(Serializable val) {
        String name = val.getClass().getSimpleName();
        char firstLetter = name.charAt(0);
        String key = String.valueOf(Character.toLowerCase(firstLetter)) + name.substring(1);
        return MapArgs._m(key, new ValParm(val));
    }

    public static LEntry aVal(Serializable val, Map properties) {
        String name = val.getClass().getSimpleName();
        char firstLetter = name.charAt(0);
        String key = String.valueOf(Character.toLowerCase(firstLetter)) + name.substring(1);
        return MapArgs._m(key, new ValParm(val, properties));
    }

    public static Property kv(String key, String value) {
        return new Property(key, value);
    }

    public String toString() {
        if (this.entries.length != 0) {
            return Arrays.toString(this.entries);
        }
        return Arrays.toString(this.vals);
    }

    public MapArgs clone() {
        if (this.entries.length == 0) {
            Object[] newVals = new Object[this.vals.length];
            int ix = 0;
            while (ix < this.vals.length) {
                Object curObj = this.vals[ix];
                newVals[ix] = curObj instanceof HollowParm ? ((HollowParm)curObj).clone() : curObj;
                ++ix;
            }
            return new MapArgs(newVals);
        }
        LEntry[] newEnt = new LEntry[this.entries.length];
        int ix = 0;
        while (ix < this.entries.length) {
            newEnt[ix] = this.entries[ix].clone();
            ++ix;
        }
        return new MapArgs(newEnt);
    }

    public boolean prefersList() {
        return this.entries.length == 0;
    }

    @Override
    public int size() {
        return this.vals.length;
    }

    @Override
    public boolean isEmpty() {
        return this.vals.length == 0;
    }

    @Override
    public boolean containsKey(Object o) {
        int ix = 0;
        while (ix < this.entries.length) {
            if (this.entries[ix].key.equals(o)) {
                return true;
            }
            ++ix;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object o) {
        int ix = 0;
        while (ix < this.vals.length) {
            if (this.vals[ix].equals(o)) {
                return true;
            }
            ++ix;
        }
        return false;
    }

    @Override
    public Object get(Object o) {
        int ix = 0;
        while (ix < this.entries.length) {
            LEntry entry = this.entries[ix];
            if (entry.key.equals(o)) {
                return entry.value;
            }
            ++ix;
        }
        return null;
    }

    public Object get(int index) {
        return this.vals[index];
    }

    @Override
    public Object put(String s, Object o) {
        Object obj = this.get(s);
        if (obj instanceof HollowParm) {
            HollowParm hollowParm = (HollowParm)obj;
            if (hollowParm.isReadOnly()) {
                throw new IllegalArgumentException(" unmodifiable parameter " + s);
            }
            Object res = hollowParm.getValue();
            hollowParm.modifyChecked((Serializable)obj);
            return res;
        }
        throw new UnsupportedOperationException("immutable map");
    }

    @Override
    public Object remove(Object o) {
        throw new UnsupportedOperationException("immutable map");
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> map) {
        throw new UnsupportedOperationException("immutable map");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("immutable map");
    }

    @Override
    public Set<String> keySet() {
        String[] keys = new String[this.entries.length];
        int ix = 0;
        while (ix < this.entries.length) {
            keys[ix] = this.entries[ix].key;
            ++ix;
        }
        return new HashSet<String>(Arrays.asList(keys));
    }

    @Override
    public Collection<Object> values() {
        return Arrays.asList(this.vals);
    }

    public Object[] toArray() {
        return this.vals;
    }

    public List<Object> asList() {
        return Arrays.asList(this.vals);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return new LinkedHashSet<Map.Entry<String, Object>>(Arrays.asList(this.entries));
    }

    public LEntry[] getEntries() {
        return this.entries;
    }

    @Override
    public Iterator<Object> iterator() {
        return Arrays.asList(this.vals).iterator();
    }

    public boolean isSafe() {
        int ix = 0;
        while (ix < this.vals.length) {
            HollowParm parm;
            Object arg = this.vals[ix];
            if (arg instanceof HollowParm ? !(parm = (HollowParm)arg).isSet() : arg instanceof BuiltParm && !((BuiltParm)arg).isSafe()) {
                return false;
            }
            ++ix;
        }
        return true;
    }

    public boolean isValuesOnly() {
        int ix = 0;
        while (ix < this.vals.length) {
            Object arg = this.vals[ix];
            if (arg instanceof HollowParm) {
                return false;
            }
            if (arg instanceof BuiltParm && !((BuiltParm)arg).isValuesOnly()) {
                return false;
            }
            ++ix;
        }
        return true;
    }

    public MapArgs asFullMap(IndirectMap objectDictionary) {
        if (this.entries.length == 0) {
            return new MapArgs(this.asFullArray(objectDictionary));
        }
        LEntry[] newEntries = new LEntry[this.entries.length];
        int ix = 0;
        while (ix < this.entries.length) {
            LEntry curEntry = this.entries[ix];
            Object curObj = curEntry.getValue();
            if (objectDictionary != null && curObj instanceof HollowParm) {
                HollowParm parm = (HollowParm)curObj;
                if (!parm.isSet()) {
                    throw new EmptyParmException(curEntry.getKey(), parm);
                }
                curObj = parm instanceof NamedRefParm ? objectDictionary.getIndirect(parm.getValue()) : parm.getValue();
            } else if (curObj instanceof BuiltParm) {
                curObj = ((BuiltParm)curObj).fullValue(objectDictionary);
            }
            newEntries[ix] = new LEntry(curEntry.getKey(), curObj);
            ++ix;
        }
        return new MapArgs(newEntries);
    }

    public Object[] asFullArray(IndirectMap objectDictionary) {
        Object[] newValues = new Object[this.vals.length];
        int ix = 0;
        while (ix < this.vals.length) {
            Object curObj = this.vals[ix];
            if (objectDictionary != null && curObj instanceof HollowParm) {
                HollowParm parm = (HollowParm)curObj;
                if (!parm.isSet()) {
                    throw new EmptyParmException(parm);
                }
                curObj = parm instanceof NamedRefParm ? objectDictionary.getIndirect(parm.getValue()) : parm.getValue();
            } else if (curObj instanceof BuiltParm) {
                curObj = ((BuiltParm)curObj).fullValue(objectDictionary);
            } else if (curObj instanceof BigDecimal) {
                curObj = ((BigDecimal)curObj).doubleValue();
            }
            newValues[ix] = curObj;
            ++ix;
        }
        return newValues;
    }

    public List<Object> asFullList(IndirectMap objectDictionary) {
        return Arrays.asList(this.asFullArray(objectDictionary));
    }

    public boolean overlap(boolean acceptNullValues, LEntry entry) {
        Object value = entry.value;
        if (value instanceof HollowParm) {
            value = ((HollowParm)value).getValue();
        }
        if (!acceptNullValues && value == null) {
            return false;
        }
        Object stored = this.get(entry.getKey());
        if (stored == null) {
            return false;
        }
        if (stored instanceof HollowParm) {
            HollowParm parm = (HollowParm)stored;
            parm.modifyChecked((Serializable)value);
            return true;
        }
        return false;
    }

    public MapArgs overlap(boolean acceptNullvalues, MapArgs other) {
        if (other.entries.length == 0) {
            return this.overlap(acceptNullvalues, other.vals);
        }
        int ix = 0;
        while (ix < other.entries.length) {
            if (ix >= this.entries.length) {
                throw new ParmStructureException(ix);
            }
            LEntry curEntry = this.entries[ix];
            LEntry otherEntry = other.entries[ix];
            if (!curEntry.key.equals(otherEntry.key)) {
                throw new ParmStructureException(ix);
            }
            ++ix;
        }
        MapArgs res = this.overlap(acceptNullvalues, other.vals);
        return res;
    }

    public MapArgs overlap(boolean acceptNullvalues, Object[] array) {
        MapArgs res = this.clone();
        int ix = 0;
        while (ix < array.length) {
            Object val;
            Object obj = array[ix];
            if (obj instanceof HollowParm) {
                if (ix >= res.vals.length) {
                    throw new ParmStructureException(ix);
                }
                val = res.vals[ix];
                if (!(val instanceof HollowParm)) {
                    throw new ParmStructureException(ix);
                }
                if (!val.getClass().equals(obj.getClass())) {
                    throw new ParmStructureException(ix);
                }
                Object newValue = ((HollowParm)obj).getValue();
                if (newValue != null || acceptNullvalues) {
                    ((HollowParm)val).modifyChecked(((HollowParm)obj).getValue());
                }
            } else if (obj instanceof BuiltParm) {
                if (ix >= res.vals.length) {
                    throw new ParmStructureException(ix);
                }
                val = res.vals[ix];
                if (!(val instanceof BuiltParm)) {
                    throw new ParmStructureException(ix);
                }
                BuiltParm builtL = (BuiltParm)val;
                BuiltParm builtR = (BuiltParm)obj;
                if (builtL.getType() != builtR.getType()) {
                    throw new ParmStructureException(ix);
                }
                builtL.overlap(acceptNullvalues, builtR.getArgs());
            } else if (ix < res.vals.length && res.vals[ix] instanceof HollowParm) {
                HollowParm valParm = (HollowParm)res.vals[ix];
                if (obj != null || acceptNullvalues) {
                    valParm.modifyChecked((Serializable)obj);
                }
            }
            ++ix;
        }
        ix = 0;
        while (ix < res.entries.length) {
            LEntry entry = res.entries[ix];
            res.entries[ix] = new LEntry(entry.getKey(), res.vals[ix]);
            ++ix;
        }
        return res;
    }

    public MapArgs overlap(boolean acceptNullValues, List<Object> list) {
        return this.overlap(acceptNullValues, list.toArray());
    }

    public static class LEntry
    implements Map.Entry<String, Object>,
    Serializable,
    Cloneable {
        String key;
        Object value;

        public LEntry(String key, Object value) {
            if (key == null) {
                throw new IllegalArgumentException("no null key");
            }
            this.key = key;
            this.value = value;
        }

        public LEntry() {
        }

        public void setKey(String key) {
            this.key = key;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public Object setValue(Object o) {
            throw new UnsupportedOperationException("immutable entry");
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof LEntry)) {
                return false;
            }
            LEntry other = (LEntry)obj;
            if (this.value == null) {
                return this.key.equals(other.key) && other.value == null;
            }
            return this.key.equals(other.key) && this.value.equals(other.value);
        }

        @Override
        public int hashCode() {
            return this.key.hashCode();
        }

        public LEntry clone() {
            LEntry res = null;
            if (this.value instanceof HollowParm) {
                HollowParm data = (HollowParm)this.value;
                res = new LEntry(this.key, data.clone());
            } else {
                try {
                    res = (LEntry)super.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {}
            }
            return res;
        }

        public String toString() {
            String vlstr = this.value instanceof String ? "'" + this.value + "'" : TypeUtils.stringify((Object)this.value);
            return String.valueOf(this.key) + ": " + vlstr;
        }
    }
}

