/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config.remote;

import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.config.ConfigurationFacade;
import org.lsst.ccs.config.DBInterface;
import org.lsst.ccs.config.FIleBasedDAO;
import org.lsst.ccs.config.remote.ConfigurationServerModule;
import org.lsst.ccs.config.remote.ConfigurationServiceImpl;
import org.lsst.ccs.messaging.StatusMessageListener;

public class ConfigurationServerSystem
extends Subsystem {
    ConfigurationServiceImpl service;
    ConfigurationFacade facade;
    ConfigurationServerModule serverModule;
    private final StatusMessageListener bootStatusListener = s -> {
        String initiatorName = s.getOriginAgentInfo().getName();
    };

    public ConfigurationServerSystem(ConfigurationFacade facade) {
        super("configServer", AgentInfo.AgentType.SERVICE);
        this.facade = facade;
        this.service = new ConfigurationServiceImpl(facade);
        this.serverModule = new ConfigurationServerModule(this.service);
        this.getMessagingAccess().addStatusMessageListener(this.bootStatusListener);
    }

    public static void main(String[] args) throws Exception {
        ConfigurationFacade facade;
        String testContext = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.testcontext", "false");
        if ("true".equals(testContext.toLowerCase())) {
            facade = new ConfigurationFacade(new FIleBasedDAO());
        } else {
            String clazzName = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.configDAO", "org.lsst.ccs.config.dao.hibernate.HibernateDAO");
            DBInterface dao = (DBInterface)Class.forName(clazzName).newInstance();
            facade = new ConfigurationFacade(dao);
        }
        ConfigurationServerSystem system = new ConfigurationServerSystem(facade);
        system.start();
    }
}

