/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shell;

import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;

class SynchronousCommandInvoker {
    private int timeoutMillis;
    private final ConcurrentMessagingUtils sca;

    SynchronousCommandInvoker(ConcurrentMessagingUtils sca, int defaultTimeoutMillis) {
        this.timeoutMillis = defaultTimeoutMillis;
        this.sca = sca;
    }

    public int getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public void setTimeoutMillis(int timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
    }

    public Object invoke(CommandRequest cmd, int timeoutMillis) throws Exception {
        return this.sca.sendSynchronousCommand(cmd, (long)timeoutMillis);
    }

    public Object invoke(CommandRequest cmd) throws Exception {
        return this.sca.sendSynchronousCommand(cmd, (long)this.timeoutMillis);
    }
}

