/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config.utilities;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.lsst.ccs.config.NamesAndTag;

public class ConfigUtils {
    public static final String DEFAULT_CONFIG_NAME = "";
    public static final String DEFAULT_CAT = "";

    private ConfigUtils() {
    }

    public static NamesAndTag namesFromPath(String pathName) {
        String subsystemName = "";
        String configName = "";
        String tag = "";
        String cat = "";
        if (ConfigUtils.isAPath(pathName)) {
            int indexDot = pathName.lastIndexOf(46);
            int lastPath = pathName.lastIndexOf(47);
            String rawName = pathName.substring(lastPath + 1, indexDot);
            String[] elements = rawName.split("_");
            switch (elements.length) {
                case 3: {
                    configName = elements[2] + ":";
                    cat = elements[2];
                }
                case 2: {
                    configName = configName + elements[1];
                }
                case 1: {
                    tag = elements[0];
                }
            }
        } else {
            configName = pathName;
        }
        return new NamesAndTag(subsystemName, configName, tag, cat);
    }

    public static NamesAndTag namesFromDescriptionPath(String pathName) {
        String subsystemName = "";
        String configName = "";
        String tag = "";
        tag = pathName.substring(pathName.lastIndexOf("/") + 1);
        return new NamesAndTag(subsystemName, configName, tag);
    }

    public static NamesAndTag namesFromPaths(String descriptionName, String configurationName) {
        NamesAndTag descNT = ConfigUtils.namesFromDescriptionPath(descriptionName);
        String subsystemName = descNT.getSubsystemName();
        String configName = descNT.getConfigName();
        String tagName = descNT.getTag();
        String catName = descNT.getCat();
        if (configurationName != null) {
            NamesAndTag confNT = ConfigUtils.namesFromPath(configurationName);
            if (!confNT.getSubsystemName().isEmpty() && !subsystemName.equals(confNT.getSubsystemName())) {
                throw new IllegalArgumentException(" subsystem names differs :" + subsystemName + " <> " + confNT.getSubsystemName());
            }
            String newConfigName = confNT.getConfigName();
            if (configName.length() != 0 && newConfigName.length() != 0 && !configName.equals(newConfigName)) {
                throw new IllegalArgumentException(" configuration name clash :" + configName + " <> " + newConfigName);
            }
            if (newConfigName.length() != 0) {
                configName = newConfigName;
            }
            String newTagName = confNT.getTag();
            if (tagName.length() != 0 && newTagName.length() != 0 && !descNT.getTag().equals(newTagName)) {
                throw new IllegalArgumentException(" tag name clash :" + tagName + " <> " + newTagName);
            }
            if (newTagName.length() != 0) {
                tagName = newTagName;
            }
            catName = confNT.getCat();
        }
        return new NamesAndTag(subsystemName, configName, tagName, catName);
    }

    public static String baseNameFromNames(String configName, String tagName) {
        return ConfigUtils.baseNameFromNames(configName, tagName, "");
    }

    public static String baseNameFromNames(String configName, String tagName, String catName) {
        if (ConfigUtils.isAPath(configName)) {
            return configName;
        }
        String part1 = tagName;
        String part2 = configName;
        String part3 = catName;
        String baseName = part1;
        if (part2.isEmpty()) {
            if (!part3.isEmpty()) {
                baseName = baseName + "__" + part3;
            }
        } else {
            baseName = baseName + "_" + part2;
            if (!part3.isEmpty()) {
                baseName = baseName + "_" + part3;
            }
        }
        return baseName;
    }

    private static boolean isAPath(String string) {
        int lastPath;
        if (string == null) {
            return false;
        }
        int lastDot = string.lastIndexOf(46);
        return lastDot > (lastPath = string.lastIndexOf(47));
    }

    public static Map<String, String> rawParseConfigurationString(String ... configNames) {
        return ConfigUtils.parseConfigurationString(null, configNames);
    }

    public static Map<String, String> parseConfigurationString(Set<String> categorySet, String ... configNames) {
        HashMap<String, String> res = new HashMap<String, String>();
        for (String s : configNames) {
            if (s.isEmpty()) {
                res.put("", "");
                continue;
            }
            if (!s.contains(":")) {
                res.put("", s);
                continue;
            }
            String[] keyVal = s.split(":", -1);
            if (keyVal.length != 2) {
                throw new IllegalArgumentException("configuration " + keyVal.length);
            }
            if (categorySet != null && !categorySet.contains(keyVal[0])) {
                throw new IllegalArgumentException("unexisting category " + keyVal[0]);
            }
            res.put(keyVal[0], keyVal[1]);
        }
        return res;
    }

    public static Map<String, String> parseConfigurationStringWithDefaults(Set<String> categories, String ... taggedCategories) {
        HashMap<String, String> res = new HashMap<String, String>();
        for (String cat : categories) {
            res.put(cat, "");
        }
        res.putAll(ConfigUtils.parseConfigurationString(categories, taggedCategories));
        return res;
    }

    public static Set<String> parseCategories(Set<String> categorySet, String ... categories) {
        HashSet<String> res = new HashSet<String>();
        for (String cat : categories) {
            if (!categorySet.contains(cat)) {
                throw new IllegalArgumentException("unexisting category " + cat);
            }
            res.add(cat);
        }
        return res;
    }
}

