/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.mcm;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.StatusEnum;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusRaisedAlert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.OperationalState;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.AgentPresenceManager;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.messaging.StateBundleAggregator;
import org.lsst.ccs.messaging.StatusAggregator;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.mcm.AlertException;
import org.lsst.ccs.subsystem.mcm.AlertNotifier;
import org.lsst.ccs.subsystem.mcm.alerts.McmAlerts;
import org.lsst.ccs.subsystem.mcm.data.CCSOperationalState;
import org.lsst.ccs.subsystem.mcm.data.CCSSalState;
import org.lsst.ccs.subsystem.mcm.data.CameraOperationalState;
import org.lsst.ccs.subsystem.mcm.data.InvalidStateException;
import org.lsst.ccs.subsystem.mcm.data.OperationTimeoutException;
import org.lsst.ccs.utilities.logging.Logger;

public final class MCMUtilities<MinionT extends Enum<MinionT>, GroupT extends Enum<GroupT>, EventT extends Enum<EventT>>
implements AgentPresenceListener {
    private ConcurrentMessagingUtils cmu;
    private AgentPresenceManager apm;
    private StatusAggregator sa = new StatusAggregator();
    private StateBundleAggregator sba;
    private long defaultTimeout = 1000L;
    private Logger log = Logger.getLogger((String)"org.lsst.ccs.subsystem.mcm");
    private Agent mcm;
    private AgentMessagingLayer agentMessagingLayer;
    private MinionT minionInstance = null;
    private AlertNotifier an;
    private EnumMap<GroupT, EnumMap<MinionT, String>> groupTypeNameMap = null;
    private final Map<String, MinionT> minionNameToMinionEnumMap = new HashMap<String, MinionT>();
    private final Map<String, GroupT> groupNameToGroupEnumMap = new HashMap<String, GroupT>();
    private final Map<String, GroupT> subsystemNameGroupMap = new HashMap<String, GroupT>();
    private final Set<String> optionalMinions = new HashSet<String>();
    private final Set<String> presentMinions = new HashSet<String>();
    private final Map<GroupT, Set<MinionT>> abortingOnAlarmMinions = new HashMap<GroupT, Set<MinionT>>();
    private Predicate<BusMessage<? extends Serializable, ?>> alarmFilter;
    List<StateChangeToEventRule> eventRules = new ArrayList<StateChangeToEventRule>();
    private CCSOperationalState ccsState = CCSOperationalState.NORMAL;
    private CameraOperationalState camState = CameraOperationalState.NORMAL;
    private CCSSalState salState = CCSSalState.PUBLISH_ONLY;
    private Map<Enum, List<String>> currentlyMissing = new HashMap<Enum, List<String>>();

    public StatusAggregator getStatusAggregator() {
        return this.sa;
    }

    public MCMUtilities(Agent agent) {
        this.mcm = agent;
    }

    void init() {
        this.agentMessagingLayer = this.mcm.getMessagingAccess();
        this.cmu = new ConcurrentMessagingUtils(this.agentMessagingLayer);
        this.apm = this.agentMessagingLayer.getAgentPresenceManager();
        this.agentMessagingLayer.addStatusMessageListener((StatusMessageListener)this.sa);
        this.sba = new StateBundleAggregator(this.agentMessagingLayer);
        this.agentMessagingLayer.addStatusMessageListener((StatusMessageListener)this.sba);
        this.an = new AlertNotifier(this, this.mcm);
    }

    void addMinion(GroupT g, MinionT m, String name) {
        EnumMap<Object, String> minionMap;
        String groupName;
        if (this.minionInstance == null) {
            this.minionInstance = m;
            this.groupTypeNameMap = new EnumMap(((Enum)g).getDeclaringClass());
        }
        if (!this.groupNameToGroupEnumMap.containsKey(groupName = ((Enum)g).name().toLowerCase())) {
            this.groupNameToGroupEnumMap.put(groupName, g);
        }
        if ((minionMap = this.groupTypeNameMap.get(g)) == null) {
            minionMap = new EnumMap(((Enum)m).getDeclaringClass());
            this.groupTypeNameMap.put(g, minionMap);
        }
        this.minionNameToMinionEnumMap.put(name, m);
        this.addSubsystemToGroup(g, name);
    }

    void addSubsystemToGroup(GroupT group, String subsystemName) {
        EnumMap<MinionT, String> minionsInGroup = this.groupTypeNameMap.get(group);
        try {
            MinionT minion = this.getSubsystemType(subsystemName);
            if (minionsInGroup.containsKey(minion)) {
                throw new RuntimeException("Subsystem with type " + minion + " (" + minionsInGroup.get(minion) + ") is already part of this group. It first has to be removed.");
            }
            minionsInGroup.put(minion, subsystemName);
            Enum originalGroup = (Enum)this.subsystemNameGroupMap.get(subsystemName);
            if (originalGroup != null) {
                this.groupTypeNameMap.get(originalGroup).remove(minion);
            }
            this.subsystemNameGroupMap.put(subsystemName, group);
        }
        catch (UnknownMinionException e) {
            throw new RuntimeException(e);
        }
    }

    public GroupT getSubsystemGroup(String subsystemName) {
        return (GroupT)((Enum)this.subsystemNameGroupMap.get(subsystemName));
    }

    private GroupT getGroup(String groupName) {
        Enum gt = (Enum)this.groupNameToGroupEnumMap.get(groupName);
        if (gt == null) {
            throw new RuntimeException("Group " + groupName + " is not a valid value.");
        }
        return (GroupT)gt;
    }

    public MinionT getSubsystemType(String subsystemName) throws UnknownMinionException {
        Enum mt = (Enum)this.minionNameToMinionEnumMap.get(subsystemName);
        if (mt == null) {
            this.log.warning((Object)("Could not find subsystem type for " + subsystemName));
            throw new UnknownMinionException("Subsystem " + subsystemName + " is not a valid value.");
        }
        return (MinionT)mt;
    }

    @Command(type=Command.CommandType.QUERY)
    public List<String> getAvailableGroups() {
        ArrayList<String> result = new ArrayList<String>();
        for (String k : this.groupNameToGroupEnumMap.keySet()) {
            result.add(k);
        }
        return result;
    }

    @Command(type=Command.CommandType.QUERY)
    public List<String> getSubsystemsInGroup(String group) {
        ArrayList<String> result = new ArrayList<String>();
        Map set = this.groupTypeNameMap.get(this.getGroup(group));
        for (Map.Entry e : set.entrySet()) {
            result.add((String)e.getValue());
        }
        return result;
    }

    @Command
    public void addSubsystemToGroup(String subsystemName, String group) {
        this.addSubsystemToGroup(this.getGroup(group), subsystemName);
        this.checkPresence();
    }

    @Command
    public void setOptionalSubsystemGroup(String groupName) {
        GroupT g = this.getGroup(groupName);
        EnumMap<MinionT, String> map = this.groupTypeNameMap.get(g);
        if (map != null) {
            for (String subsystemName : map.values()) {
                this.setOptionalSubsystem(subsystemName, false);
            }
            this.checkPresence();
        }
    }

    @Command
    public void setRequiredSubsystemGroup(String groupName) {
        GroupT g = this.getGroup(groupName);
        EnumMap<MinionT, String> map = this.groupTypeNameMap.get(g);
        if (map != null) {
            for (String subsystemName : map.values()) {
                this.setRequiredSubsystem(subsystemName, false);
            }
            this.checkPresence();
        }
    }

    private void setOptionalSubsystem(String subsystemName, boolean check) {
        this.optionalMinions.add(subsystemName);
        if (check) {
            this.checkPresence();
        }
    }

    private void setRequiredSubsystem(String subsystemName, boolean check) {
        this.optionalMinions.remove(subsystemName);
        if (check) {
            this.checkPresence();
        }
    }

    @Command
    public void setOptionalSubsystem(String subsystemName) {
        this.setOptionalSubsystem(subsystemName, true);
    }

    @Command
    public void setRequiredSubsystem(String subsystemName) {
        this.setRequiredSubsystem(subsystemName, true);
    }

    private void updatePresentMinions() {
        for (AgentInfo i : this.apm.listConnectedAgents()) {
            if (!this.subsystemNameGroupMap.containsKey(i.getName())) continue;
            this.presentMinions.add(i.getName());
        }
    }

    public void activate() {
        for (String s : this.subsystemNameGroupMap.keySet()) {
            this.sba.addOrigin(s);
        }
        this.execute(() -> {
            this.waitMillis(2000L);
            this.updatePresentMinions();
            this.apm.addAgentPresenceListener((AgentPresenceListener)this);
            this.checkCamOpState();
            this.checkPresence();
        });
        this.sba.addObserver((source, old, change) -> this.minionStateChange(source, old, change));
    }

    public Object send(GroupT group, MinionT dst, String command, Object ... parms) throws Exception {
        CommandRequest cmd = new CommandRequest(this.getDestination(group, dst), command, parms);
        return this.cmu.sendSynchronousCommand(cmd, Duration.ofMillis(this.defaultTimeout));
    }

    public Object send(String dst, String command, Object ... parms) throws Exception {
        CommandRequest cmd = new CommandRequest(dst, command, parms);
        return this.cmu.sendSynchronousCommand(cmd, Duration.ofMillis(this.defaultTimeout));
    }

    public String getDestination(GroupT group, MinionT minion) {
        return this.groupTypeNameMap.get(group).get(minion);
    }

    public Object sendLongCommand(GroupT group, MinionT dst, long timeout, String command, Object ... parms) throws Exception {
        CommandRequest cmd = new CommandRequest(this.getDestination(group, dst), command, parms);
        return this.cmu.sendSynchronousCommand(cmd, Duration.ofMillis(timeout));
    }

    public Object sendLongCommand(String dst, long timeout, String command, Object ... parms) throws Exception {
        CommandRequest cmd = new CommandRequest(dst, command, parms);
        return this.cmu.sendSynchronousCommand(cmd, Duration.ofMillis(timeout));
    }

    public Future<Object> sendAsync(GroupT group, MinionT dst, String command, Object ... parms) {
        CommandRequest cmd = new CommandRequest(this.getDestination(group, dst), command, parms);
        return this.cmu.sendAsynchronousCommand(cmd);
    }

    public Future<Object> sendAsync(String dst, String command, Object ... parms) {
        CommandRequest cmd = new CommandRequest(dst, command, parms);
        return this.cmu.sendAsynchronousCommand(cmd);
    }

    @SafeVarargs
    public final void setAbortingOnAlarmMinions(GroupT group, MinionT ... m) {
        Set<MinionT> set = this.abortingOnAlarmMinions.get(group);
        if (set == null) {
            set = new HashSet<MinionT>();
            this.abortingOnAlarmMinions.put(group, set);
        }
        set.clear();
        set.addAll(Arrays.asList(m));
        this.createAlarmFilter(group);
    }

    private void createAlarmFilter(GroupT group) {
        this.alarmFilter = this.abortingOnAlarmMinions.get(group).stream().map(mm -> BusMessageFilterFactory.messageOrigin((String)this.getDestination(group, mm))).reduce(Predicate::or).orElse(x -> false).and(BusMessageFilterFactory.embeddedObjectClass(Alert.class));
    }

    public ScheduledFuture<?> schedule(Runnable r, Duration delay) {
        return this.mcm.getScheduler().schedule(r, delay.toMillis(), TimeUnit.MILLISECONDS);
    }

    public Future<?> execute(Runnable r) {
        return this.mcm.getScheduler().schedule(r, 0L, TimeUnit.MILLISECONDS);
    }

    public Future<StatusMessage> watchForState(GroupT group, MinionT sys, Enum state) {
        Predicate<Object> f = BusMessageFilterFactory.messageOrigin((String)this.getDestination(group, sys)).and(BusMessageFilterFactory.messageClass(StatusMessage.class));
        Predicate<BusMessage> p = m -> ((StatusMessage)m).getState().isInState(state);
        f = f.and(p);
        for (Enum m2 : this.abortingOnAlarmMinions.get(group)) {
            Predicate x = BusMessageFilterFactory.embeddedObjectClass(Alert.class).and(BusMessageFilterFactory.messageOrigin((String)this.getDestination(group, m2)));
            f = f.or(x);
        }
        return this.cmu.startListeningForStatusBusMessage(f);
    }

    public <StateT extends Enum<StateT>> void checkState(GroupT g, MinionT sys, StateT state) {
        StateBundle current = this.sba.getState(this.getDestination(g, sys));
        if (current == null || !current.isInState(state)) {
            throw new InvalidStateException(current == null ? "null" : current.toString(), " expecting " + state);
        }
    }

    @SafeVarargs
    public final <StateT extends Enum<StateT>> void checkState(GroupT g, MinionT sys, StateT ... state) {
        StateBundle current = this.sba.getState(this.getDestination(g, sys));
        if (current != null) {
            for (StateT s : state) {
                if (!current.isInState(s)) continue;
                return;
            }
        }
        StringBuilder expected = new StringBuilder("current state ");
        expected.append(current == null ? "null" : current.toString());
        expected.append(" expecting one of [");
        for (int i = 0; i < state.length; ++i) {
            expected.append(((Enum)state[i]).toString());
            if (i >= state.length - 1) continue;
            expected.append(", ");
        }
        expected.append("]");
        throw new InvalidStateException(expected.toString());
    }

    public <StateT extends Enum<StateT>> boolean isInState(GroupT g, MinionT sys, StateT state) {
        StateBundle current = this.sba.getState(this.getDestination(g, sys));
        if (current == null) {
            return false;
        }
        return current.isInState(state);
    }

    public StateBundle getState(GroupT g, MinionT sys) {
        return this.sba.getState(this.getDestination(g, sys));
    }

    public <StateT extends Enum<StateT>> void waitForState(GroupT g, MinionT sys, StateT state, long timeout) {
        Future<StatusMessage> f = this.watchForState(g, sys, state);
        StateBundle current = this.sba.getState(this.getDestination(g, sys));
        if (current != null && current.isInState(state)) {
            this.log.info((Object)("state for " + sys + " already ok for " + state));
            return;
        }
        this.log.debug((Object)("current state for " + sys + " : " + current));
        try {
            StatusMessage m = f.get(timeout, TimeUnit.MILLISECONDS);
            if (m != null) {
                this.log.debug((Object)("received " + m.getState()));
            }
            if (m == null) {
                if (this.sba.getState(this.getDestination(g, sys)).isInState(state)) {
                    this.log.info((Object)"null future, but in state");
                } else {
                    this.log.info((Object)"null future, not in state");
                    this.log.info((Object)this.sba.getState(this.getDestination(g, sys)));
                    throw new OperationTimeoutException("waiting for state " + state + " on " + sys);
                }
            }
            if (m instanceof StatusRaisedAlert) {
                throw new AlertException("interrupted waitForState", (Alert)((StatusRaisedAlert)m).getObject());
            }
        }
        catch (TimeoutException e) {
            throw new OperationTimeoutException("waiting for state " + state + " on " + sys, (Throwable)e);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public <StateT extends Enum<StateT>> ExpectedStateCombination<StateT> expectingState(GroupT g, MinionT m, StateT state) {
        return new ExpectedStateCombination(this, (Enum)g, (Enum)m, state);
    }

    public void waitMillis(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            this.log.error((Object)"wait interrupted ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void connecting(AgentInfo ... agents) {
        for (AgentInfo agent : agents) {
            Enum m = (Enum)this.minionNameToMinionEnumMap.get(agent.getName());
            if (m == null) continue;
            this.presentMinions.add(agent.getName());
            this.checkPresence();
        }
    }

    public void disconnecting(AgentInfo agent) {
        Enum m = (Enum)this.minionNameToMinionEnumMap.get(agent.getName());
        if (m != null) {
            this.presentMinions.remove(agent.getName());
            this.checkPresence();
        }
    }

    public <StateT extends Enum<StateT>> void addSingleStateChangeToEventRule(MinionT minion, StateT state, EventT event) {
        this.eventRules.add(new SingleStateChangeToEventRule(this, minion, state, event));
    }

    public <StateT extends Enum<StateT>> void addSingleStateChangeOutToEventRule(MinionT minion, StateT state, EventT event) {
        this.eventRules.add(new SingleStateChangeOutToEventRule(this, minion, state, event));
    }

    public <StateT extends Enum<StateT>> void addDefaultStateChangeToEventRule(MinionT minion, Class<StateT> stateClass, EventT event) {
        this.eventRules.add(new DefaultStateChangeToEventRule(this, minion, stateClass, event));
    }

    public void checkEventRules(StateBundle out, StateBundle change) {
        Enum bestEvent = null;
        int level = 0;
        for (StateChangeToEventRule rule : this.eventRules) {
            int l = rule.matches(out, change);
            if (l <= level) continue;
            level = l;
            bestEvent = (Enum)rule.getEvent();
        }
        if (bestEvent != null) {
            this.log.info((Object)("sending MCM event " + bestEvent));
            StatusEnum message = new StatusEnum(bestEvent, this.mcm.getState());
            this.mcm.getMessagingAccess().sendStatusMessage((StatusMessage)message);
        }
    }

    public void minionStateChange(String source, StateBundle out, StateBundle change) {
        this.log.info((Object)("from " + source + " state change " + change));
        if (change.getState(OperationalState.class) != null) {
            this.checkCamOpState();
        }
        this.checkEventRules(out, change);
    }

    synchronized void checkPresence() {
        CCSOperationalState newS = CCSOperationalState.NORMAL;
        HashMap<Enum, List<String>> missing = new HashMap<Enum, List<String>>();
        for (String subsystemName : this.subsystemNameGroupMap.keySet()) {
            if (this.optionalMinions.contains(subsystemName) || this.presentMinions.contains(subsystemName) || subsystemName.equals(this.mcm.getName())) continue;
            newS = CCSOperationalState.MISSING_SUBSYSTEM;
            Enum group = (Enum)this.subsystemNameGroupMap.get(subsystemName);
            this.log.warn((Object)("Missing Subsystem " + subsystemName + "  " + group));
            ArrayList<String> missingForGroup = (ArrayList<String>)missing.get(group);
            if (missingForGroup == null) {
                missingForGroup = new ArrayList<String>();
                missing.put(group, missingForGroup);
            }
            missingForGroup.add(subsystemName);
        }
        if (this.ccsState != newS || !this.currentlyMissing.equals(missing)) {
            Enum group;
            this.ccsState = newS;
            this.mcm.updateAgentState(new Enum[]{this.ccsState});
            this.log.info((Object)("MCM state: " + this.ccsState));
            HashMap<Enum, List<String>> currentlyMissingCopy = new HashMap<Enum, List<String>>(this.currentlyMissing);
            for (Map.Entry e : missing.entrySet()) {
                group = (Enum)e.getKey();
                List missingSubsystems = (List)e.getValue();
                boolean raiseAlert = false;
                if (currentlyMissingCopy.containsKey(group)) {
                    List alreadyMissing = (List)currentlyMissingCopy.remove(group);
                    if (!alreadyMissing.equals(missingSubsystems)) {
                        raiseAlert = true;
                    }
                } else {
                    raiseAlert = true;
                }
                if (!raiseAlert) continue;
                this.log.warn((Object)("MCM raising alert for missing : " + group + " " + missingSubsystems));
                Alert alert = McmAlerts.MissingSubsystem.getAlert(group, new Object[]{missingSubsystems});
                ((AlertService)this.mcm.getAgentService(AlertService.class)).raiseAlert(alert, AlertState.ALARM, "MCM: Missing subsystem for group: " + group + " (" + missingSubsystems + ")");
            }
            for (Map.Entry e : currentlyMissingCopy.entrySet()) {
                group = (Enum)e.getKey();
                Alert alert = McmAlerts.MissingSubsystem.getAlert(group, new Object[]{new ArrayList()});
                ((AlertService)this.mcm.getAgentService(AlertService.class)).raiseAlert(alert, AlertState.NOMINAL, "MCM: All required subsystems are present for group: " + group);
            }
            this.currentlyMissing = missing;
        }
    }

    void checkCamOpState() {
        CameraOperationalState newS = this.camState;
        for (String mn : this.subsystemNameGroupMap.keySet()) {
            StateBundle sb = this.sba.getState(mn);
            if (sb != null) {
                OperationalState s = (OperationalState)sb.getState(OperationalState.class);
                if (s == null) {
                    newS = CameraOperationalState.ENGINEERING_FAULT;
                    break;
                }
                if (s.equals((Object)OperationalState.ENGINEERING_FAULT)) {
                    newS = CameraOperationalState.ENGINEERING_FAULT;
                    break;
                }
                if (!s.equals((Object)OperationalState.ENGINEERING_OK)) continue;
                newS = CameraOperationalState.ENGINEERING_OK;
                continue;
            }
            newS = CameraOperationalState.ENGINEERING_FAULT;
            break;
        }
        if (!newS.equals((Object)this.camState)) {
            this.log.info((Object)("camera operational state " + this.camState + " -> " + newS));
            this.camState = newS;
            this.mcm.updateAgentState(new Enum[]{this.camState});
        }
    }

    void checkSalState() {
        CCSSalState newS = this.salState;
        if (this.camState == CameraOperationalState.ENGINEERING_FAULT) {
            this.salState = CCSSalState.FAULT;
        }
        if (!newS.equals((Object)this.salState)) {
            this.log.info((Object)("camera SAL state " + this.salState + " -> " + newS));
            this.salState = newS;
            this.mcm.updateAgentState(new Enum[]{this.salState});
        }
    }

    public void addAlertObserver(AlertNotifier.Observer o) {
        this.an.addObserver(o);
    }

    public void deleteAlertObserver(AlertNotifier.Observer o) {
        this.an.deleteObserver(o);
    }

    private static class CombinedStatesChangeToEventRule<T extends Enum<T>>
    extends StateChangeToEventRule {
        private Map<MinionT, T> states;
        final /* synthetic */ MCMUtilities this$0;

        private Map<MinionT, T> getStates() {
            if (this.states == null) {
                this.states = new EnumMap(this.this$0.minionInstance.getDeclaringClass());
            }
            return this.states;
        }

        public CombinedStatesChangeToEventRule(MinionT m, T state, EventT e) {
            this.this$0 = var1_1;
            super((MCMUtilities)var1_1, e);
            this.states = null;
            this.getStates().put(m, state);
        }

        public CombinedStatesChangeToEventRule<T> addState(MinionT m, T state) {
            this.getStates().put(m, state);
            return this;
        }

        @Override
        public int matches(StateBundle out, StateBundle changes) {
            throw new RuntimeException("not implemented");
        }
    }

    private static class SingleStateChangeOutToEventRule<T extends Enum<T>>
    extends StateChangeToEventRule {
        MinionT minion;
        T outState;
        final /* synthetic */ MCMUtilities this$0;

        public SingleStateChangeOutToEventRule(MinionT m, T out, EventT e) {
            this.this$0 = var1_1;
            super((MCMUtilities)var1_1, e);
            this.minion = m;
            this.outState = out;
        }

        @Override
        public int matches(StateBundle out, StateBundle changes) {
            return out.isInState(this.outState) ? 2 : 0;
        }
    }

    private static class SingleStateChangeToEventRule<T extends Enum<T>>
    extends StateChangeToEventRule {
        MinionT minion;
        T state;
        final /* synthetic */ MCMUtilities this$0;

        public SingleStateChangeToEventRule(MinionT m, T s, EventT e) {
            this.this$0 = var1_1;
            super((MCMUtilities)var1_1, e);
            this.minion = m;
            this.state = s;
        }

        @Override
        public int matches(StateBundle out, StateBundle changes) {
            return changes.isInState(this.state) ? 2 : 0;
        }
    }

    private static class DefaultStateChangeToEventRule<T extends Enum<T>>
    extends StateChangeToEventRule {
        MinionT minion;
        Class<T> stateClass;
        final /* synthetic */ MCMUtilities this$0;

        public DefaultStateChangeToEventRule(MinionT m, Class<T> s, EventT e) {
            this.this$0 = var1_1;
            super((MCMUtilities)var1_1, e);
            this.stateClass = s;
            this.minion = m;
        }

        @Override
        public int matches(StateBundle out, StateBundle changes) {
            return changes.getState(this.stateClass) == null ? 0 : 1;
        }
    }

    private static abstract class StateChangeToEventRule {
        protected EventT event;
        final /* synthetic */ MCMUtilities this$0;

        public StateChangeToEventRule(EventT e) {
            this.this$0 = var1_1;
            this.event = e;
        }

        public EventT getEvent() {
            return this.event;
        }

        public abstract int matches(StateBundle var1, StateBundle var2);
    }

    public static final class ExpectedStateCombination<T extends Enum<T>> {
        private Map<MinionT, T> states = null;
        private final GroupT group;
        final /* synthetic */ MCMUtilities this$0;

        private Map<MinionT, T> getStates() {
            if (this.states == null) {
                this.states = new EnumMap(this.this$0.minionInstance.getDeclaringClass());
            }
            return this.states;
        }

        private ExpectedStateCombination(GroupT g, MinionT m, T state) {
            this.this$0 = this$0;
            this.getStates().put(m, state);
            this.group = g;
        }

        private ExpectedStateCombination(GroupT g, ExpectedStateCombination<T> src, MinionT m, T state) {
            this.this$0 = this$0;
            this.getStates().putAll(super.getStates());
            this.getStates().put(m, state);
            this.group = g;
        }

        public ExpectedStateCombination<T> expectingState(GroupT g, MinionT m, T state) {
            return new ExpectedStateCombination(this.this$0, g, this, m, state);
        }

        private Predicate<BusMessage<? extends Serializable, ?>> filter(MinionT sys, T state) {
            return BusMessageFilterFactory.messageOrigin((String)this.this$0.getDestination(this.group, sys)).and(m -> ((StatusMessage)m).getState().isInState(state));
        }

        private Predicate<BusMessage<? extends Serializable, ?>> createFilter(MinionT sys) {
            return this.filter(sys, (Enum)this.getStates().get(sys)).or(this.this$0.alarmFilter);
        }

        public void waitForAllStatesHappening(long timeout) {
            HashSet waitingFor = new HashSet(this.states.keySet());
            for (Map.Entry e : this.states.entrySet()) {
                if (!this.this$0.sba.getState(this.this$0.getDestination(this.group, (Enum)e.getKey())).isInState((Enum)e.getValue())) continue;
                waitingFor.remove(e.getKey());
            }
            this.this$0.log.debug((Object)("waiting for subsystems " + waitingFor + " timeout " + timeout));
            if (waitingFor.isEmpty()) {
                this.this$0.log.debug((Object)"waitForAllStatesHappening: already all in state");
                return;
            }
            int timeoutseconds = timeout > 1000L ? (int)timeout / 1000 : 1;
            HashSet<Future> futures = new HashSet<Future>();
            for (Enum m : waitingFor) {
                Predicate<BusMessage<Serializable, ?>> f = this.createFilter(m);
                futures.add(this.this$0.cmu.startListeningForStatusBusMessage(f, Duration.ofMillis(timeoutseconds)));
            }
            for (Future f : futures) {
                try {
                    f.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    this.this$0.log.warn((Object)"interrupted");
                    throw new RuntimeException(e);
                }
            }
        }

        public void waitForAllStates(long timeout) {
            long endTimeout = System.currentTimeMillis() + timeout;
            block0: while (System.currentTimeMillis() < endTimeout) {
                this.waitForAllStatesHappening(endTimeout - System.currentTimeMillis());
                for (Map.Entry e : this.states.entrySet()) {
                    if (this.this$0.sba.getState(this.this$0.getDestination(this.group, (Enum)e.getKey())).isInState((Enum)e.getValue())) continue;
                    continue block0;
                }
                return;
            }
            throw new OperationTimeoutException("waitForAllStates");
        }
    }

    public static class UnknownMinionException
    extends Exception {
        public UnknownMinionException(String cause) {
            super(cause);
        }
    }
}

