/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.mcm;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.subsystem.mcm.AlertNotification;
import org.lsst.ccs.subsystem.mcm.GenericMCM;
import org.lsst.ccs.subsystem.mcm.MCMUtilities;
import org.lsst.ccs.utilities.logging.Logger;

public class AlertDispatcher
implements HasLifecycle {
    @LookupField(strategy=LookupField.Strategy.ANCESTORS)
    GenericMCM mcm;
    @LookupName
    String name;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    protected Map<String, AlertHandler> handlers = new HashMap<String, AlertHandler>();
    boolean isEnabled = true;
    private MCMUtilities<?, ?, ?> mu;
    private final Enum group;
    private final String groupName;
    private static Logger log = Logger.getLogger((String)"org.lsst.ccs.subsystem.mcm");

    public AlertDispatcher(Enum group) {
        this(null, group);
    }

    AlertDispatcher(MCMUtilities<?, ?, ?> mu2, Enum group) {
        this.mu = mu2;
        this.group = group;
        this.groupName = group.name();
    }

    public MCMUtilities getMcmUtilities() {
        return this.mu;
    }

    public void postInit() {
        if (this.mcm != null) {
            if (this.mu != null) {
                throw new RuntimeException("**** Something went very wrong. This AlertDispatcher has already been initialized");
            }
            this.mu = this.mcm.getMcmUtilities();
        }
    }

    @Command
    public void enable() {
        this.isEnabled = true;
    }

    @Command
    public void disable(@Argument(defaultValue="true") boolean disable) {
        this.isEnabled = !disable;
    }

    @Command
    public String status() {
        return this.status("");
    }

    String status(String indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(indent).append("Name     : ").append(this.isEnabled).append("\n");
        sb.append(indent).append("Enabled  : ").append(this.isEnabled).append("\n");
        sb.append(indent).append("Group    : ").append(this.group).append("\n");
        sb.append(indent).append("Handlers :\n");
        for (AlertHandler h : this.handlers.values()) {
            sb.append(h.status(indent + "\t"));
        }
        return sb.toString();
    }

    public Enum getGroup() {
        return this.group;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void onAlert(AlertNotification notif) {
        if (this.isEnabled) {
            for (AlertHandler h : this.handlers.values()) {
                h.onAlert(notif);
            }
        }
    }

    public static Logger getLogger() {
        return log;
    }

    private void addHandler(AlertHandler h) {
        this.handlers.put(h.getName(), h);
    }

    @Command
    public AlertHandler addAlertHandler(String name) {
        AlertHandler h = new AlertHandler(name);
        this.addHandler(h);
        return h;
    }

    @Command
    public AlertHandler addEmailAction(String handlerName, String email) {
        AlertHandler h = this.handlers.get(handlerName);
        h.addEmailAction(email);
        return h;
    }

    @Command
    public AlertHandler addCommandAction(String handlerName, String destination, String command, Object ... parameters) {
        AlertHandler h = this.handlers.get(handlerName);
        h.addCommandAction(destination, command, parameters);
        return h;
    }

    @Command
    public AlertHandler setOriginSelector(String handlerName, String origin) {
        AlertHandler h = this.handlers.get(handlerName);
        h.setOriginSelector(origin);
        return h;
    }

    @Command
    public AlertHandler setOriginAndAlertIdSelector(String handlerName, String origin, String alertId) {
        AlertHandler h = this.handlers.get(handlerName);
        h.setOriginAndAlertIdSelector(origin, alertId);
        return h;
    }

    @Command
    public String[] getAlertHandlers() {
        return this.handlers.keySet().toArray(new String[0]);
    }

    public static class CommandAlertAction
    extends AlertAction {
        String destination;
        String command;
        Object[] parameters;
        @LookupField(strategy=LookupField.Strategy.TOP)
        private Subsystem s;

        public CommandAlertAction() {
        }

        public CommandAlertAction(String destination, String command, Object ... parameters) {
            this.destination = destination;
            this.command = command;
            this.parameters = parameters;
        }

        @Override
        public String getDescription() {
            return "Command " + this.command + " sent to " + this.destination + " with parameters " + this.parameters;
        }

        @Override
        public void accept(AlertNotification t) {
            log.info((Object)("command on alert    " + t));
            log.info((Object)("command on alert -> " + this.destination + " " + this.command));
            new ConcurrentMessagingUtils(this.s.getMessagingAccess()).sendAsynchronousCommand(new CommandRequest(this.destination, this.command, this.parameters));
        }
    }

    public static class EmailAlertAction
    extends AlertAction {
        protected String fromEmail = "mcm@no-reply.org";
        protected String replyToEmail = null;
        protected String smtpHost = "smtpunix.slac.stanford.edu";
        private DateTimeFormatter dtf = DateTimeFormatter.ofPattern("HH:mm:ss dd MMM yyyy");
        InternetAddress[] address;
        Session session;
        InternetAddress fromAddress;

        public EmailAlertAction(List<String> emails) {
            this.configureEmailAddress(emails);
        }

        @Override
        public String getDescription() {
            String description = "Email notification to [";
            for (InternetAddress email : this.address) {
                description = description + email.getAddress() + ", ";
            }
            description = description.substring(0, description.length() - 2);
            description = description + "]";
            return description;
        }

        public void init() {
            Properties props = System.getProperties();
            props.put("mail.smtp.host", this.smtpHost);
            this.session = Session.getInstance((Properties)props, null);
            try {
                this.fromAddress = new InternetAddress(this.fromEmail);
            }
            catch (AddressException e) {
                log.error((Object)("Error while parsing address " + this.fromEmail), (Throwable)e);
                throw new RuntimeException("Error while parsing address " + this.fromEmail, e);
            }
        }

        protected final void configureEmailAddress(List<String> emails) {
            this.address = new InternetAddress[emails.size()];
            int count = 0;
            for (String email : emails) {
                try {
                    this.address[count++] = new InternetAddress(email);
                }
                catch (AddressException e) {
                    log.error((Object)("Error while parsing address " + email), (Throwable)e);
                    throw new RuntimeException("Error while parsing address " + email, e);
                }
            }
        }

        public EmailAlertAction(String email) {
            this(Arrays.asList(email));
        }

        @Override
        public void accept(AlertNotification notif) {
            try {
                MimeMessage msg = new MimeMessage(this.session);
                msg.setFrom((Address)this.fromAddress);
                msg.setRecipients(Message.RecipientType.TO, (Address[])this.address);
                if (this.replyToEmail != null) {
                    InternetAddress replyTo = new InternetAddress(this.replyToEmail);
                    msg.setReplyTo((Address[])new InternetAddress[]{replyTo});
                }
                String subject = "CCS Alert " + notif.getSeverity() + " " + notif.getOrigin() + " " + notif.getAlert().getAlertId();
                msg.setSubject(subject);
                LocalDateTime date = LocalDateTime.ofInstant(Instant.ofEpochMilli(notif.getTimestamp()), ZoneId.systemDefault());
                String text = "CCS Alert \n  origin:   " + notif.getOrigin() + "\n  cause:    " + notif.getCause() + "\n  id:       " + notif.getAlert().getAlertId() + "\n  severity: " + notif.getSeverity() + "\n  descr:    " + notif.getAlert().getDescription() + "\n  time:     " + date.format(this.dtf) + "\n";
                msg.setText(text);
                msg.setSentDate(new Date());
                log.info((Object)("Sending email: \n" + subject + "\n" + text));
                Transport.send((Message)msg);
            }
            catch (MessagingException e) {
                log.error((Object)("Failed sending email " + (Object)((Object)e)), (Throwable)e);
                e.printStackTrace();
            }
        }
    }

    public static class EmailAlertActionFromFile
    extends EmailAlertAction {
        File file = null;
        long lastModified;
        String filePath;

        EmailAlertActionFromFile() {
            super(new ArrayList<String>());
        }

        @Override
        public void init() {
            super.init();
            if (this.filePath != null) {
                try {
                    this.file = new File(this.filePath);
                    this.updateEmailList(this.file);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private void updateEmailList(File f) {
            log.info((Object)("Updating email list form " + f.getAbsolutePath() + " " + f.lastModified()));
            try {
                String line;
                FileInputStream fis = new FileInputStream(f);
                InputStreamReader in = new InputStreamReader(fis);
                BufferedReader reader = new BufferedReader(in);
                ArrayList<String> addresses = new ArrayList<String>();
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith("#")) continue;
                    int indx = (line = line.trim()).indexOf("#");
                    if (indx > -1) {
                        line = line.substring(0, indx);
                        line = line.trim();
                    }
                    addresses.add(line);
                }
                this.configureEmailAddress(addresses);
                this.lastModified = f.lastModified();
            }
            catch (IOException fnf) {
                fnf.printStackTrace();
            }
        }

        @Override
        public void accept(AlertNotification notif) {
            if (this.file != null && this.file.exists()) {
                if (this.lastModified != this.file.lastModified()) {
                    this.updateEmailList(this.file);
                }
                super.accept(notif);
            }
        }

        @Override
        public String getDescription() {
            return super.getDescription() + " from file " + this.file.getAbsolutePath();
        }
    }

    public static abstract class AlertAction
    implements Consumer<AlertNotification>,
    HasLifecycle {
        final Logger ACTION_LOG = Logger.getLogger((String)"org.lsst.ccs.mcm.action");
        @LookupName
        String name;
        boolean enabled = true;

        protected Logger getLogger() {
            return this.ACTION_LOG;
        }

        @Command
        public String status() {
            return this.status("");
        }

        String status(String indent) {
            StringBuilder sb = new StringBuilder();
            sb.append(indent).append("Name        : ").append(this.name).append("\n");
            sb.append(indent).append("Enabled     : ").append(this.enabled).append("\n");
            sb.append(indent).append("Description : ").append(this.getDescription()).append("\n");
            return sb.toString();
        }

        @Command
        public void enable() {
            this.enabled = true;
        }

        @Command
        public void disable(@Argument(defaultValue="true") boolean disable) {
            this.enabled = !disable;
        }

        public abstract String getDescription();
    }

    public static class AlertHandler {
        String handlerName;
        boolean enabled = true;
        @LookupField(strategy=LookupField.Strategy.CHILDREN)
        List<AlertAction> actions = new ArrayList<AlertAction>();
        Predicate<AlertNotification> selector;

        public AlertHandler(String name) {
            this.handlerName = name;
        }

        public AlertHandler addAction(AlertAction action) {
            this.actions.add(action);
            return this;
        }

        public AlertHandler addEmailAction(String email) {
            return this.addAction(new EmailAlertAction(email));
        }

        public AlertHandler addCommandAction(String destination, String command, Object ... parameters) {
            return this.addAction(new CommandAlertAction(destination, command, parameters));
        }

        public String getName() {
            return this.handlerName;
        }

        public AlertHandler setSelector(Predicate<AlertNotification> selector) {
            this.selector = selector;
            return this;
        }

        public AlertHandler orSelector(Predicate<AlertNotification> or) {
            this.selector = this.selector == null ? or : this.selector.or(or);
            return this;
        }

        public AlertHandler andSelector(Predicate<AlertNotification> and) {
            this.selector = this.selector == null ? and : this.selector.and(and);
            return this;
        }

        public Predicate<AlertNotification> originSelector(String origin) {
            return a -> a.getOrigin().equals(origin);
        }

        public Predicate<AlertNotification> alertIdSelector(String id) {
            return a -> a.getAlert().getAlertId().equals(id);
        }

        public Predicate<AlertNotification> alertLevelSelector(AlertState severity) {
            return a -> a.getSeverity().ordinal() >= severity.ordinal();
        }

        public AlertHandler setOriginSelector(String origin) {
            return this.setSelector(this.originSelector(origin));
        }

        public AlertHandler setOriginAndAlertIdSelector(String origin, String alertId) {
            return this.setSelector(this.originSelector(origin).and(this.alertIdSelector(alertId)));
        }

        @Command
        public void enable() {
            this.enabled = true;
        }

        @Command
        public void disable(@Argument(defaultValue="true") boolean disable) {
            this.enabled = !disable;
        }

        @Command
        public String status() {
            return this.status("");
        }

        String status(String indent) {
            StringBuilder sb = new StringBuilder();
            sb.append(indent).append("Name     : ").append(this.handlerName).append("\n");
            sb.append(indent).append("Enabled  : ").append(this.enabled).append("\n");
            sb.append(indent).append("Selector : ").append(this.selector).append("\n");
            sb.append(indent).append("Actions  :\n");
            if (this.actions.size() > 0) {
                for (AlertAction h : this.actions) {
                    sb.append(h.status(indent + "\t"));
                }
            } else {
                sb.append(indent).append("\tNone defined");
            }
            sb.append("\n");
            return sb.toString();
        }

        public void onAlert(AlertNotification notif) {
            if (!this.enabled) {
                return;
            }
            if (this.selector != null && !this.selector.test(notif)) {
                return;
            }
            for (AlertAction a : this.actions) {
                try {
                    a.accept(notif);
                }
                catch (Throwable e) {
                    log.error((Object)("Error handling action " + e), e);
                    e.printStackTrace();
                }
            }
        }
    }
}

