/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.mcm;

import java.util.ArrayList;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.RaisedAlertHistory;
import org.lsst.ccs.bus.data.RaisedAlertSummary;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.services.alert.AlertEvent;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.mcm.AlertNotification;
import org.lsst.ccs.subsystem.mcm.MCMUtilities;
import org.lsst.ccs.utilities.logging.Logger;

public class AlertNotifier<MinionT extends Enum<MinionT>, GroupT extends Enum<GroupT>> {
    static Logger log = Logger.getLogger((String)"lsst.ccs.bus");
    private final Object updateInProgress = new Object();
    private final MCMUtilities<MinionT, GroupT, ?> mcmUtils;
    private final AlertService alertService;
    ArrayList<Observer> observers = new ArrayList();

    public AlertNotifier(MCMUtilities mcmUtils, Agent agent) {
        this.mcmUtils = mcmUtils;
        this.alertService = agent.getAlertService();
        this.alertService.addListener(event -> this.processEvent(event));
    }

    private void processEvent(AlertEvent event) {
        if (event.getType() == AlertEvent.AlertEventType.ALERT_RAISED) {
            String origin = event.getSource();
            GroupT g = this.mcmUtils.getSubsystemGroup(origin);
            MinionT m = this.mcmUtils.getSubsystemType(origin);
            Alert alert = event.getAlert();
            log.info((Object)("Got a raised alert message from " + origin));
            RaisedAlertHistory hist = event.getSummary().getRaisedAlert(alert.getAlertId());
            this.notifyObservers(new AlertNotification(origin, (Enum)g, (Enum)m, hist.getLatestAlertCause(), hist.getLatestAlert(), hist.getLatestAlertState(), hist.getLatestAlertTimestamp()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserver(Observer o) {
        Object object = this.updateInProgress;
        synchronized (object) {
            this.observers.add(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteObserver(Observer o) {
        Object object = this.updateInProgress;
        synchronized (object) {
            this.observers.remove(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyObservers(AlertNotification notif) {
        Object object = this.updateInProgress;
        synchronized (object) {
            ArrayList<Observer> obs = new ArrayList<Observer>(this.observers);
            obs.forEach(o -> this.notifyObserver((Observer)o, notif));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyObservers(String origin, RaisedAlertSummary summary) {
        Object object = this.updateInProgress;
        synchronized (object) {
            ArrayList<Observer> obs = new ArrayList<Observer>(this.observers);
            obs.forEach(o -> this.notifyObserver((Observer)o, origin, summary));
        }
    }

    private void notifyObserver(Observer o, AlertNotification notif) {
        o.alertRaised(notif);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyObserver(Observer o, String origin, RaisedAlertSummary summary) {
        Object object = this.updateInProgress;
        synchronized (object) {
            for (RaisedAlertHistory hist : summary.getAllRaisedAlertHistories()) {
                if (hist.getLatestAlertState() == AlertState.NOMINAL) continue;
                try {
                    GroupT g = this.mcmUtils.getSubsystemGroup(origin);
                    MinionT m = this.mcmUtils.getSubsystemType(origin);
                    this.notifyObserver(o, new AlertNotification(origin, (Enum)g, (Enum)m, hist.getLatestAlertCause(), hist.getLatestAlert(), hist.getLatestAlertState(), hist.getLatestAlertTimestamp()));
                }
                catch (Exception e) {
                    log.warning((Object)("Could not process alert notification from " + origin), (Throwable)e);
                }
            }
        }
    }

    public static interface Observer {
        public void alertRaised(AlertNotification var1);
    }
}

