/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.ccd;

import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.Segment;
import org.lsst.ccs.utilities.image.ReadOutParameters;

public interface CCDTransform {
    public void setXY(int var1, int var2);

    public int getX();

    public int getY();

    public void setSegmentSerialParallel(Segment var1, int var2, int var3);

    public Segment getSegment();

    public int getSerial();

    public int getParallel();

    public PixelType getPixelType();

    public int getGlobalX();

    public int getGlobalY();

    public ReadOutParameters getReadOutParameters();

    public static CCDTransform getGlobalTransform(CCD ccd, ReadOutParameters readOutParameters) {
        return new GlobalTransform(ccd, readOutParameters);
    }

    public static CCDTransform getGlobalTransform(CCD ccd) {
        return new GlobalTransform(ccd, new ReadOutParameters(ccd.getType()));
    }

    public static CCDTransform getActiveTransform(CCD ccd, ReadOutParameters readOutParameters) {
        return new ActiveTransform(ccd, readOutParameters);
    }

    public static CCDTransform getActiveTransform(CCD ccd) {
        return new ActiveTransform(ccd, new ReadOutParameters(ccd.getType()));
    }

    public static class GlobalTransform
    implements CCDTransform {
        private Segment segment;
        private int serial;
        private int parallel;
        private PixelType pixelType;
        private int x;
        private int y;
        private final CCD ccd;
        private final ReadOutParameters readOutParameters;

        GlobalTransform(CCD ccd, ReadOutParameters readOutParameters) {
            this.ccd = ccd;
            this.readOutParameters = readOutParameters;
        }

        @Override
        public void setXY(int x, int y) {
            assert (x >= 0 && x < ReadOutParameters.getCCDTotalSerialSize(this.ccd, this.readOutParameters));
            assert (y >= 0 && y < ReadOutParameters.getCCDTotalParallelSize(this.ccd, this.readOutParameters));
            this.x = x;
            this.y = y;
            int column = x / this.readOutParameters.getTotalSerialSize();
            int row = y / this.readOutParameters.getTotalParallelSize();
            this.segment = (Segment)this.ccd.getChild(row, column);
            this.parallel = this.segment.isReadoutDown() ? y : this.readOutParameters.getTotalParallelSize() - 1 - (y %= this.readOutParameters.getTotalParallelSize());
            int n = this.serial = this.segment.isReadoutLeft() ? x : this.readOutParameters.getTotalSerialSize() - 1 - (x %= this.readOutParameters.getTotalSerialSize());
            this.pixelType = this.parallel > this.segment.getSegmentParallelActiveSize() ? PixelType.PARALLEL_OVERSCAN : (this.serial < this.readOutParameters.getSerialPrescan() ? PixelType.SERIAL_PRESCAN : (this.serial > this.readOutParameters.getSerialPrescan() + this.segment.getSegmentSerialActiveSize() ? PixelType.SERIAL_OVERSCAN : PixelType.ACTIVE));
        }

        @Override
        public void setSegmentSerialParallel(Segment segment, int serial, int parallel) {
            assert (segment.getParent() == this.ccd);
            assert (0 <= parallel && parallel < this.readOutParameters.getTotalParallelSize());
            assert (0 <= serial && serial < this.readOutParameters.getTotalSerialSize());
            this.segment = segment;
            this.serial = serial;
            this.parallel = parallel;
            this.pixelType = parallel > segment.getSegmentParallelActiveSize() ? PixelType.PARALLEL_OVERSCAN : (serial < this.readOutParameters.getSerialPrescan() ? PixelType.SERIAL_PRESCAN : (serial > this.readOutParameters.getSerialPrescan() + segment.getSegmentSerialActiveSize() ? PixelType.SERIAL_OVERSCAN : PixelType.ACTIVE));
            int xx = segment.isReadoutLeft() ? serial : this.readOutParameters.getTotalSerialSize() - 1 - serial;
            int yy = segment.isReadoutDown() ? parallel : this.readOutParameters.getTotalParallelSize() - 1 - parallel;
            this.x = xx += segment.getSerialPosition() * this.readOutParameters.getTotalSerialSize();
            this.y = yy += segment.getParallelPosition() * this.readOutParameters.getTotalParallelSize();
        }

        @Override
        public Segment getSegment() {
            return this.segment;
        }

        @Override
        public int getSerial() {
            return this.serial;
        }

        @Override
        public int getParallel() {
            return this.parallel;
        }

        @Override
        public PixelType getPixelType() {
            return this.pixelType;
        }

        public String toString() {
            return "GlobalTransform{segment=" + this.segment + ", serial=" + this.serial + ", parallel=" + this.parallel + ", pixelType=" + (Object)((Object)this.pixelType) + ", x=" + this.x + ", y=" + this.y + '}';
        }

        @Override
        public int getGlobalX() {
            return this.x;
        }

        @Override
        public int getGlobalY() {
            return this.y;
        }

        @Override
        public int getX() {
            return this.x;
        }

        @Override
        public int getY() {
            return this.y;
        }

        @Override
        public ReadOutParameters getReadOutParameters() {
            return this.readOutParameters;
        }
    }

    public static class ActiveTransform
    implements CCDTransform {
        private Segment segment;
        private int serial;
        private int parallel;
        private int x;
        private int y;
        private int globalX;
        private int globalY;
        private final CCD ccd;
        private final ReadOutParameters readOutParameters;

        ActiveTransform(CCD ccd, ReadOutParameters readOutParameters) {
            this.ccd = ccd;
            this.readOutParameters = readOutParameters;
        }

        @Override
        public void setXY(int x, int y) {
            assert (x >= 0 && x < this.ccd.getActiveSerialSize());
            assert (y >= 0 && y < this.ccd.getActiveParallelSize());
            this.x = x;
            this.y = y;
            int column = x / this.ccd.getType().getCCDGeometryConstants().getSegmentSerialActiveSize();
            int row = y / this.ccd.getType().getCCDGeometryConstants().getSegmentParallelActiveSize();
            this.segment = (Segment)this.ccd.getChild(row, column);
            this.globalX = x + this.segment.getSerialPosition() * (this.readOutParameters.getSerialPrescan() + this.readOutParameters.getOverCols()) + (!this.segment.isReadoutLeft() ? this.readOutParameters.getSerialPrescan() : this.readOutParameters.getOverCols());
            this.globalY = y + this.segment.getParallelPosition() * this.readOutParameters.getOverRows() + (this.segment.isReadoutDown() ? 0 : this.readOutParameters.getOverRows());
            this.serial = this.readOutParameters.getSerialPrescan() + (!this.segment.isReadoutLeft() ? x : this.segment.getSegmentSerialActiveSize() - 1 - (x %= this.segment.getSegmentSerialActiveSize()));
            this.parallel = this.segment.isReadoutDown() ? y : this.segment.getSegmentParallelActiveSize() - 1 - (y %= this.segment.getSegmentParallelActiveSize());
        }

        @Override
        public Segment getSegment() {
            return this.segment;
        }

        @Override
        public int getSerial() {
            return this.serial;
        }

        @Override
        public int getParallel() {
            return this.parallel;
        }

        @Override
        public PixelType getPixelType() {
            return PixelType.ACTIVE;
        }

        @Override
        public int getGlobalX() {
            return this.globalX;
        }

        @Override
        public int getGlobalY() {
            return this.globalY;
        }

        public String toString() {
            return "ActiveTransform{segment=" + this.segment + ", serial=" + this.serial + ", parallel=" + this.parallel + ", x=" + this.x + ", y=" + this.y + '}';
        }

        @Override
        public void setSegmentSerialParallel(Segment segment, int serial, int parallel) {
            assert (segment.getParent() == this.ccd);
            assert (0 <= parallel && parallel < segment.getSegmentParallelActiveSize());
            assert (this.readOutParameters.getSerialPrescan() <= serial && serial < this.readOutParameters.getSerialPrescan() + segment.getSegmentSerialActiveSize());
            this.segment = segment;
            this.serial = serial;
            this.parallel = parallel;
            int yy = segment.isReadoutDown() ? parallel : segment.getSegmentParallelActiveSize() - 1 - parallel;
            int xx = !segment.isReadoutLeft() ? serial : segment.getSegmentSerialActiveSize() - 1 - (serial -= this.readOutParameters.getSerialPrescan());
            this.x = xx += segment.getSerialPosition() * segment.getSegmentSerialActiveSize();
            this.y = yy += segment.getParallelPosition() * segment.getSegmentParallelActiveSize();
            this.globalX = this.x + segment.getSerialPosition() * (this.readOutParameters.getSerialPrescan() + this.readOutParameters.getOverCols()) + (!segment.isReadoutLeft() ? this.readOutParameters.getSerialPrescan() : this.readOutParameters.getOverCols());
            this.globalY = this.y + segment.getParallelPosition() * this.readOutParameters.getOverRows() + (segment.isReadoutDown() ? 0 : this.readOutParameters.getOverRows());
        }

        @Override
        public int getX() {
            return this.x;
        }

        @Override
        public int getY() {
            return this.y;
        }

        @Override
        public ReadOutParameters getReadOutParameters() {
            return this.readOutParameters;
        }
    }

    public static enum PixelType {
        ACTIVE,
        SERIAL_PRESCAN,
        SERIAL_OVERSCAN,
        PARALLEL_OVERSCAN;

    }
}

