/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.mcm;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import org.lsst.ccs.Agent;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.StatusEnum;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentCommandDictionaryService;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.subsystem.mcm.AlertDispatcher;
import org.lsst.ccs.subsystem.mcm.AlertNotification;
import org.lsst.ccs.subsystem.mcm.MCMUtilities;
import org.lsst.ccs.subsystem.mcm.data.MCMIR2Event;
import org.lsst.ccs.utilities.logging.Logger;

public abstract class GenericMCM<MinionT extends Enum<MinionT>, GroupT extends Enum<GroupT>, EventT extends Enum<EventT>, StateT extends Enum<StateT>, CommandT extends Enum<CommandT>>
extends Subsystem
implements HasLifecycle {
    protected MCMUtilities<MinionT, GroupT, EventT> mu;
    Map<StateT, Set<CommandT>> allowedTransition = new HashMap<StateT, Set<CommandT>>();
    protected Map<GroupT, Map<String, MinionT>> minions;
    @LookupField(strategy=LookupField.Strategy.TOP)
    Subsystem subsystem;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    protected Map<String, AlertDispatcher> dispatchers = new HashMap<String, AlertDispatcher>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    AgentStateService agentStateService;
    protected Random random = new Random();
    protected static final Logger log = Logger.getLogger((String)"org.lsst.ccs.subsystem.mcm");

    public void init() {
        this.mu = new MCMUtilities((Agent)this.subsystem);
        this.initAllowedTransitions();
        for (Map.Entry<GroupT, Map<String, MinionT>> e : this.minions.entrySet()) {
            Enum group = (Enum)e.getKey();
            for (Map.Entry<String, MinionT> e1 : e.getValue().entrySet()) {
                this.mu.addMinion(group, (Enum)e1.getValue(), e1.getKey());
            }
        }
        ((AgentCommandDictionaryService)this.subsystem.getAgentService(AgentCommandDictionaryService.class)).addCommandSetToObject(this.mu, (Object)this.subsystem);
        this.initMCM();
    }

    public void start() {
        this.mu.init();
        this.mu.addAlertObserver(this::onAlert);
        this.mu.activate();
    }

    protected MCMUtilities getMcmUtilities() {
        return this.mu;
    }

    protected abstract void initAllowedTransitions();

    protected abstract void initMCM();

    protected void setState(StateT s) {
        log.info((Object)("MCM State " + s));
        this.agentStateService.updateAgentState(new Enum[]{s});
    }

    protected abstract Class<StateT> getStateClass();

    protected void checkCommandValidity(CommandT cmd) {
        Enum state = this.agentStateService.getState(this.getStateClass());
        if (!this.allowedTransition.get(state).contains(cmd)) {
            log.error((Object)("Command " + cmd + " not allowed in state " + state));
            throw new RuntimeException("Command " + cmd + " not allowed in state " + state);
        }
    }

    public GenericMCM() {
        this("genericMCM");
    }

    public GenericMCM(String name) {
        super(name, AgentInfo.AgentType.MCM);
        this.getAgentInfo().getAgentProperties().setProperty("org.lsst.ccs.use.full.paths", "true");
    }

    public void onAlert(AlertNotification notif) {
        log.warn((Object)(notif + " " + notif.getOrigin() + " " + notif.getSubsystemType() + " " + notif.getSubsystemGroup()));
        for (Map.Entry<String, AlertDispatcher> e : this.dispatchers.entrySet()) {
            AlertDispatcher ad = e.getValue();
            boolean affectsDispatcher = false;
            if (notif.getOrigin().equals(this.subsystem.getName())) {
                String group = (String)notif.getAlert().getAlertData("group");
                if (ad.getGroupName().equals(group)) {
                    affectsDispatcher = true;
                }
            }
            if (!affectsDispatcher && !ad.getGroup().equals(notif.getSubsystemGroup())) continue;
            e.getValue().onAlert(notif);
        }
    }

    @Command
    public String[] getAlertDispatchers() {
        return this.dispatchers.keySet().toArray(new String[0]);
    }

    @Command
    public String status() {
        StringBuilder sb = new StringBuilder();
        sb.append("Dispatchers: \n");
        for (Map.Entry<String, AlertDispatcher> e : this.dispatchers.entrySet()) {
            sb.append("\n");
            sb.append(e.getValue().status("\t"));
        }
        return sb.toString();
    }

    public void publishEvent(MCMIR2Event e) {
        StatusEnum message = new StatusEnum((Enum)e, this.stateService.getState());
        this.subsystem.getMessagingAccess().sendStatusMessage((StatusMessage)message);
    }

    public Object send(GroupT g, MinionT dst, String command, Object ... parms) throws Exception {
        return this.mu.send(g, dst, command, parms);
    }

    public Object sendLongCommand(GroupT g, MinionT dst, long duration, String command, Object ... parms) throws Exception {
        return this.mu.sendLongCommand(g, dst, duration, command, parms);
    }

    public Future<Object> sendAsync(GroupT g, MinionT dst, String command, Object ... parms) {
        return this.mu.sendAsync(g, dst, command, parms);
    }

    public <MinionStateT extends Enum<MinionStateT>> Future<StatusMessage> watchForState(GroupT g, MinionT sys, MinionStateT state) {
        return this.mu.watchForState(g, sys, state);
    }

    public <MinionStateT extends Enum<MinionStateT>> void waitForState(GroupT g, MinionT sys, MinionStateT state, long timeout) {
        this.mu.waitForState(g, sys, state, timeout);
    }

    public void waitMillis(long millis) {
        this.mu.waitMillis(millis);
    }

    public <MinionStateT extends Enum<MinionStateT>> void checkState(GroupT g, MinionT sys, MinionStateT state) {
        this.mu.checkState(g, sys, state);
    }

    @SafeVarargs
    public final <MinionStateT extends Enum<MinionStateT>> void checkState(GroupT g, MinionT sys, MinionStateT ... state) {
        this.mu.checkState(g, sys, state);
    }

    public <MinionStateT extends Enum<MinionStateT>> boolean isInState(GroupT g, MinionT sys, MinionStateT state) {
        return this.mu.isInState(g, sys, state);
    }

    public <MinionStateT extends Enum<MinionStateT>> MCMUtilities.ExpectedStateCombination<MinionStateT> expectingState(GroupT g, MinionT m, MinionStateT state) {
        return this.mu.expectingState(g, m, state);
    }

    @SafeVarargs
    public final void setAbortingOnAlarmMinions(GroupT g, MinionT ... m) {
        this.mu.setAbortingOnAlarmMinions((Enum)g, (Enum[])m);
    }

    public ScheduledFuture<?> schedule(Runnable r, Duration delay) {
        return this.mu.schedule(r, delay);
    }

    public Future<?> execute(Runnable r) {
        return this.mu.execute(r);
    }
}

