/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb.sim;

import java.nio.ByteBuffer;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.drivers.reb.Image;
import org.lsst.ccs.drivers.reb.ImageClient;

public class SimulatedImage
extends Image {
    private ByteBuffer data;
    private int numberOfColums = 544;
    private int numberOfRows = 2048;

    SimulatedImage(ImageClient.Impl client) {
        super(0L, 0, 0, 0, 0, 0, 0, 0, 0L, client);
    }

    public int getNumberOfColumns() {
        return this.numberOfColums;
    }

    public void setNumberOfColumns(int numberOfColums) {
        this.numberOfColums = numberOfColums;
    }

    public int getNumberOfRows() {
        return this.numberOfRows;
    }

    public void setNumberOfRows(int numberOfRows) {
        this.numberOfRows = numberOfRows;
    }

    void setSchema(int schema) {
        this.schema = schema;
    }

    void setTag(long tag) {
        this.tag = tag;
    }

    void setLength(int length) {
        this.length = length;
    }

    void setFormat(int format) {
        this.format = format;
    }

    void setVersion(int version) {
        this.version = version;
    }

    void setAddress(int address) {
        this.address = address;
    }

    void setCluster(int cluster) {
        this.cluster = cluster;
    }

    void setElement(int element) {
        this.element = element;
    }

    void setData(ByteBuffer data) {
        this.data = data;
    }

    @Override
    public ByteBuffer getData() {
        return this.data != null && this.data.limit() > 0 ? this.data.asReadOnlyBuffer() : null;
    }

    public void setRegisters(int[] registers) {
        if (registers != null) {
            this.registers = registers;
        }
    }

    void setName(String imageName) {
        this.name = imageName;
    }

    void setRebType(int rebType) {
        String rebName = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.drivers.reb.sim.REBType", "REB");
        if ("WREB".equals(rebName)) {
            rebType = 2;
        }
        this.sensorType = rebType;
        switch (rebType) {
            case 0: {
                this.numCcds = 3;
                break;
            }
            case 2: {
                this.numCcds = 1;
                break;
            }
            case 1: {
                this.numCcds = 2;
            }
        }
    }
}

