import org.lsst.ccs.description.groovy.CCSBuilder;
import org.lsst.ccs.subsystem.mcm.MCM_IR2;
import org.lsst.ccs.subsystem.mcm.MinionIR2;
import org.lsst.ccs.subsystem.mcm.MinionIR2Group;
import org.lsst.ccs.subsystem.mcm.AlertDispatcher.AlertHandler;
import org.lsst.ccs.subsystem.mcm.AlertDispatcher.AlertAction;
import org.lsst.ccs.subsystem.mcm.AlertDispatcher.EmailAlertAction;
import org.lsst.ccs.subsystem.mcm.AlertDispatcher.EmailAlertActionFromFile;
import org.lsst.ccs.subsystem.mcm.AlertDispatcher.CommandAlertAction;
import org.lsst.ccs.subsystem.mcm.AlertDispatcher;
import org.lsst.ccs.subsystem.mcm.AlertNotification;
import org.lsst.ccs.subsystem.rafts.alerts.RaftAlert;
import org.lsst.ccs.bus.states.AlertState;
import java.util.function.Predicate;
import org.lsst.ccs.subsystem.mcm.ir2.actions.RebTemperatureTooHighAction
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;

CCSBuilder builder = ["mcm_demo"]

//Dummy AlertAction to print something
class PrintWhatToDo extends AlertAction {
    def msg;
    PrintWhatToDo(String msg) {
        this.msg = msg;
    }
        
    def void accept(AlertNotification notif) {
        System.out.println(notif.getSeverity().toString()+" "+msg);
    }        

    def String getDescription() {
        return "Prints to standard output: "+msg;
    }        
}


builder.
    main(MCM_IR2, 
        minions:[(MinionIR2Group.INFRASTRUCTURE):["demo":MinionIR2.RAFT] ]) {

    infrastructure (AlertDispatcher, group: MinionIR2Group.INFRASTRUCTURE) {
        printSomething (AlertHandler, handlerName: "someAction" ) {
            printWhatToDo2 (PrintWhatToDo, msg: "SOME ALERT: Something needs to be done")
        }
    }
    
}