/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts.fpga.xml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.lsst.ccs.subsystem.rafts.fpga.compiler.Visitor;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Call;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Callable;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Function;
import org.lsst.ccs.subsystem.rafts.fpga.xml.FunctionPointer;
import org.lsst.ccs.subsystem.rafts.fpga.xml.RepeatFunctionPointer;
import org.lsst.ccs.subsystem.rafts.fpga.xml.RepeatSubroutinePointer;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Sequencer;
import org.lsst.ccs.subsystem.rafts.fpga.xml.SubroutinePointer;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Visitable;

@XmlType(propOrder={"fullname", "calls"})
public class Subroutine
extends Callable
implements Visitable,
Serializable {
    private static final long serialVersionUID = 430725144253153130L;
    private String fullname;
    private List<Call> calls = new ArrayList<Call>();

    public Subroutine() {
    }

    public Subroutine(String id, String fullname) {
        this.setId(id);
        this.setFullname(fullname);
    }

    @XmlElement(name="fullname")
    public String getFullname() {
        return this.fullname;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }

    @XmlElement(name="call")
    public List<Call> getCalls() {
        return this.calls;
    }

    public void setCalls(List<Call> calls) {
        this.calls = calls;
    }

    @Override
    public void accept(Visitor v) {
        v.visit(this);
    }

    public void complete(Sequencer s) {
        for (Call c : this.calls) {
            String fname;
            if (c.getFunction() == null && c.getSubroutine() == null && c.getFunctionPointer() == null && c.getSubroutinePointer() == null) {
                String name;
                if (c.getFcnName() != null) {
                    name = c.getFcnName();
                    if (name.startsWith("@")) {
                        fname = name.substring(1);
                        FunctionPointer fp = s.getSequencerConfig().getFuncPtrs().stream().filter(m -> m.getId().equals(fname)).findFirst().orElseThrow(() -> new RuntimeException("cannot find function pointer " + fname));
                        c.setFunctionPointer(fp);
                    } else {
                        Function f = s.getSequencerConfig().getFunctions().stream().filter(m -> m.getId().equals(name)).findFirst().orElseThrow(() -> new RuntimeException("cannot find function  " + name));
                        c.setFunction(f);
                    }
                } else if (c.getSubName() != null) {
                    name = c.getSubName();
                    if (name.startsWith("@")) {
                        fname = name.substring(1);
                        SubroutinePointer sp = s.getSequencerConfig().getSubPtrs().stream().filter(m -> m.getId().equals(fname)).findFirst().orElseThrow(() -> new RuntimeException("cannot find subroutine pointer " + fname));
                        c.setSubroutinePointer(sp);
                    } else {
                        Subroutine sub = s.getSequencerRoutines().getSubroutines().stream().filter(m -> m.getId().equals(name)).findFirst().orElseThrow(() -> new RuntimeException("cannot find subroutine  " + name));
                        c.setSubroutine(sub);
                    }
                } else {
                    throw new RuntimeException(" nothing defined for call in subroutine " + this.getId() + " " + this.getFullname());
                }
            }
            if (c.getRepeatFcnPtr() != null || c.getRepeatSubPtr() != null || c.getRepeatValue() > 1 || c.getRepeat() == null) continue;
            String n = c.getRepeat();
            if (n.startsWith("@")) {
                fname = n.substring(1);
                if (c.getFunction() != null || c.getFunctionPointer() != null) {
                    RepeatFunctionPointer rfp = s.getSequencerConfig().getFuncRepPtrs().stream().filter(m -> m.getId().equals(fname)).findFirst().orElseThrow(() -> new RuntimeException("cannot find repeat function pointer  " + fname));
                    c.setRepeat(null);
                    c.setRepeatFcnPtr(rfp);
                    continue;
                }
                RepeatSubroutinePointer rsp = s.getSequencerConfig().getSubRepPtrs().stream().filter(m -> m.getId().equals(fname)).findFirst().orElseThrow(() -> new RuntimeException("cannot find repeat subroutine pointer " + fname));
                c.setRepeat(null);
                c.setRepeatSubPtr(rsp);
                continue;
            }
            if (!n.matches("\\d+")) continue;
            c.setRepeatValue(Integer.parseInt(n));
        }
    }
}

