/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.image.patterns;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import org.lsst.ccs.utilities.image.patterns.GeneratedImage;

public abstract class PatternGenerator {
    private final String name;
    private static final ColorSpace cs = ColorSpace.getInstance(1003);
    private static final ComponentColorModel ccm = new ComponentColorModel(cs, false, false, 1, 3);

    PatternGenerator(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public abstract GeneratedImage generateImage(int var1, int var2, Map<String, String> var3);

    protected String getParameter(String parName, Map<String, String> parameters) {
        if (parameters == null) {
            return null;
        }
        return parameters.get(parName);
    }

    protected double getDoubleParameter(String parName, Map<String, String> parameters, double defaultValue) {
        String par = this.getParameter(parName, parameters);
        if (par == null) {
            return defaultValue;
        }
        return Double.parseDouble(par);
    }

    protected int getIntParameter(String parName, Map<String, String> parameters, int defaultValue) {
        String par = this.getParameter(parName, parameters);
        if (par == null) {
            return defaultValue;
        }
        return Integer.parseInt(par);
    }

    protected String getStringParameter(String parName, Map<String, String> parameters, String defaultValue) {
        String par = this.getParameter(parName, parameters);
        if (par == null) {
            return defaultValue;
        }
        return par;
    }

    static WritableRaster createRaster(int width, int height) {
        return ccm.createCompatibleWritableRaster(width, height);
    }

    static ComponentColorModel getComponentColorModel() {
        return ccm;
    }

    public static BufferedImage getBufferedImageFromRaster(WritableRaster r) {
        return new BufferedImage(ccm, r, false, null);
    }
}

