/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb;

import org.lsst.ccs.drivers.reb.GlobalClient;
import org.lsst.ccs.drivers.reb.Image;
import org.lsst.ccs.drivers.reb.ImageClient;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.drivers.reb.RegClient;

public class Daq2Client {
    static void loadLibrary() {
        System.loadLibrary("RebDaq2");
    }

    public static class Global
    implements GlobalClient.Impl {
        long handle;

        Global() {
            Daq2Client.loadLibrary();
        }

        @Override
        public void newGlobalClient(int[] ids, String[] ifc) {
            this.handle = this.newGlobalClient1(ifc[0]);
        }

        @Override
        public void newGlobalClient(int[] ids, String part) {
            this.handle = this.newGlobalClient1(part);
        }

        private native long newGlobalClient1(String var1);

        @Override
        public void deleteGlobalClient() {
            this.deleteGlobalClient1(this.handle);
            this.handle = 0L;
        }

        private native void deleteGlobalClient1(long var1);

        @Override
        public void setRegisterList(int rebType, int[] registers) {
            this.setRegisterList1(this.handle, rebType, registers);
        }

        private native void setRegisterList1(long var1, int var3, int[] var4);

        @Override
        public void triggerImage(String name) {
            this.triggerImage1(this.handle, name);
        }

        private native void triggerImage1(long var1, String var3);
    }

    public static class Images
    implements ImageClient.Impl {
        long handle;

        Images() {
            Daq2Client.loadLibrary();
            Images.initSys();
        }

        private static native void initSys();

        @Override
        public native void newImageClient(int var1, String var2);

        @Override
        public native void deleteImageClient();

        @Override
        public native Image waitForImage(Image var1);

        @Override
        public native boolean getImage(Image var1);

        @Override
        public native void interrupt();
    }

    public static class Registers
    implements RegClient.Impl {
        Registers() {
            Daq2Client.loadLibrary();
        }

        @Override
        public native long newRegClient(int var1, String var2);

        @Override
        public native void deleteRegClient(long var1);

        @Override
        public int readReg(long handle, int address) throws REBException {
            int[] values = new int[1];
            this.readRegs(handle, address, values, 0, 1);
            return values[0];
        }

        @Override
        public native void readRegs(long var1, int var3, int[] var4, int var5, int var6) throws REBException;

        @Override
        public void writeReg(long handle, int address, int value) throws REBException {
            int[] values = new int[]{value};
            this.writeRegs(handle, address, values, 0, 1);
        }

        @Override
        public native void writeRegs(long var1, int var3, int[] var4, int var5, int var6) throws REBException;

        @Override
        public int updateReg(long handle, int address, int mask, int value) throws REBException {
            int[] values = new int[]{0};
            this.readRegs(handle, address, values, 0, 1);
            int oldVal = values[0];
            values[0] = values[0] & ~mask | value & mask;
            this.writeRegs(handle, address, values, 0, 1);
            return oldVal;
        }

        @Override
        public native void reset(long var1, int var3) throws REBException;
    }
}

