/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.mcm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.RaisedAlertHistory;
import org.lsst.ccs.bus.data.RaisedAlertSummary;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.StatusAlert;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusRaisedAlert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.mcm.AlertNotification;
import org.lsst.ccs.subsystem.mcm.MCMUtilities;
import org.lsst.ccs.utilities.logging.Logger;

public class AlertNotifier<MinionT extends Enum<MinionT>, GroupT extends Enum<GroupT>>
implements StatusMessageListener,
AgentPresenceListener {
    static Logger log = Logger.getLogger((String)"lsst.ccs.bus");
    private Map<String, RaisedAlertSummary> raisedAlertMap = new ConcurrentHashMap<String, RaisedAlertSummary>();
    private final Object updateInProgress = new Object();
    private final ConcurrentMessagingUtils cmu;
    private final Agent a;
    private final MCMUtilities<MinionT, GroupT, ?> mcmUtils;
    ArrayList<Observer> observers = new ArrayList();

    public AlertNotifier(MCMUtilities mcmUtils, Agent agent) {
        this.cmu = new ConcurrentMessagingUtils(agent.getMessagingAccess());
        agent.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
        this.a = agent;
        this.mcmUtils = mcmUtils;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStatusMessage(StatusMessage msg) {
        if (msg.getOriginAgentInfo().getType().compareTo((Enum)AgentInfo.AgentType.WORKER) < 0) {
            return;
        }
        String origin = msg.getOriginAgentInfo().getName();
        Object object = this.updateInProgress;
        synchronized (object) {
            if (!this.raisedAlertMap.containsKey(origin)) {
                log.info((Object)("Need to fetch alert information for " + origin));
                RaisedAlertSummary summary = null;
                if (origin.equals(this.a.getName())) {
                    summary = this.a.getAlertService().getRaisedAlertSummary();
                } else {
                    CommandRequest cmd = new CommandRequest(origin, "getRaisedAlertSummary", null);
                    try {
                        summary = (RaisedAlertSummary)this.cmu.sendSynchronousCommand(cmd);
                    }
                    catch (Exception e) {
                        log.severe((Object)("Problem fetching raised alert summary for " + origin), (Throwable)e);
                    }
                }
                if (summary != null) {
                    this.raisedAlertMap.put(origin, summary);
                }
            }
            if (msg instanceof StatusAlert) {
                this.raisedAlertMap.put(origin, ((StatusAlert)msg).getRaisedAlertSummary());
            }
        }
        if (!(msg instanceof StatusRaisedAlert)) {
            return;
        }
        Serializable o = msg.getObject();
        log.info((Object)("Got a raised alert message from " + origin));
        if (!(o instanceof Alert)) {
            log.severe((Object)("How did we get here? Why is the content of a StatusRaisedAlert not an Alert???? " + o.getClass()));
            return;
        }
        Alert alert = (Alert)o;
        AlertState severity = ((StatusRaisedAlert)msg).getRaisedAlertSummary().getRaisedAlert(alert.getAlertId()).getLatestAlertState();
        String cause = ((StatusRaisedAlert)msg).getCause();
        try {
            GroupT g = this.mcmUtils.getSubsystemGroup(origin);
            MinionT m = this.mcmUtils.getSubsystemType(origin);
            this.notifyObservers(new AlertNotification(origin, (Enum)g, (Enum)m, cause, alert, severity, msg.getTimeStamp()));
        }
        catch (Exception e) {
            log.warning((Object)("Could not process alert notification from " + origin), (Throwable)e);
        }
    }

    public void connecting(AgentInfo agent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnecting(AgentInfo agent) {
        Object object = this.updateInProgress;
        synchronized (object) {
            log.info((Object)("Agent " + agent.getName() + " has disconnected. Removing the corresponding alert history"));
            this.raisedAlertMap.remove(agent.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserver(Observer o) {
        Object object = this.updateInProgress;
        synchronized (object) {
            this.observers.add(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteObserver(Observer o) {
        Object object = this.updateInProgress;
        synchronized (object) {
            this.observers.remove(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyObservers(AlertNotification notif) {
        Object object = this.updateInProgress;
        synchronized (object) {
            ArrayList<Observer> obs = new ArrayList<Observer>(this.observers);
            obs.forEach(o -> this.notifyObserver((Observer)o, notif));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyObservers(String origin, RaisedAlertSummary summary) {
        Object object = this.updateInProgress;
        synchronized (object) {
            ArrayList<Observer> obs = new ArrayList<Observer>(this.observers);
            obs.forEach(o -> this.notifyObserver((Observer)o, origin, summary));
        }
    }

    private void notifyObserver(Observer o, AlertNotification notif) {
        o.alertRaised(notif);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyObserver(Observer o, String origin, RaisedAlertSummary summary) {
        Object object = this.updateInProgress;
        synchronized (object) {
            for (RaisedAlertHistory hist : summary.getAllRaisedAlertHistories()) {
                if (hist.getLatestAlertState() == AlertState.NOMINAL) continue;
                try {
                    GroupT g = this.mcmUtils.getSubsystemGroup(origin);
                    MinionT m = this.mcmUtils.getSubsystemType(origin);
                    this.notifyObserver(o, new AlertNotification(origin, (Enum)g, (Enum)m, hist.getLatestAlertCause(), hist.getLatestAlert(), hist.getLatestAlertState(), hist.getLatestAlertTimestamp()));
                }
                catch (Exception e) {
                    log.warning((Object)("Could not process alert notification from " + origin), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateObserver(Observer o) {
        Object object = this.updateInProgress;
        synchronized (object) {
            for (Map.Entry<String, RaisedAlertSummary> e : this.raisedAlertMap.entrySet()) {
                this.notifyObserver(o, e.getKey(), e.getValue());
            }
        }
    }

    public static interface Observer {
        public void alertRaised(AlertNotification var1);
    }
}

