/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.mcm;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.StatusEnum;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusRaisedAlert;
import org.lsst.ccs.bus.states.OperationalState;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.AgentPresenceManager;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.messaging.StateBundleAggregator;
import org.lsst.ccs.messaging.StatusAggregator;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.mcm.AlarmException;
import org.lsst.ccs.subsystem.mcm.Minion;
import org.lsst.ccs.subsystem.mcm.data.CCSOperationalState;
import org.lsst.ccs.subsystem.mcm.data.CCSSalState;
import org.lsst.ccs.subsystem.mcm.data.CameraOperationalState;
import org.lsst.ccs.subsystem.mcm.data.InvalidStateException;
import org.lsst.ccs.subsystem.mcm.data.MCMEvent;
import org.lsst.ccs.subsystem.mcm.data.OperationTimeoutException;
import org.lsst.ccs.subsystem.mcm.data.RaftState;
import org.lsst.ccs.subsystem.mcm.data.ShutterState;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.utilities.logging.Logger;

public final class MCMUtilities
implements AgentPresenceListener {
    private ConcurrentMessagingUtils cmu;
    private AgentPresenceManager apm;
    private StatusAggregator sa = new StatusAggregator();
    private StateBundleAggregator sba = new StateBundleAggregator();
    private long defaultTimeout = 1000L;
    private Logger log = Logger.getLogger((String)"org.lsst.ccs.subsystem.mcm");
    private Agent mcm;
    private AgentMessagingLayer agentMessagingLayer;
    private final Map<Minion, String> minionNames = new EnumMap<Minion, String>(Minion.class);
    private final Map<String, Minion> name2minion = new HashMap<String, Minion>();
    private final Set<Minion> presentMinions = new HashSet<Minion>();
    private final Set<Minion> abortingOnAlarmMinions = new HashSet<Minion>();
    private Predicate<BusMessage<? extends Serializable, ?>> alarmFilter;
    private final ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(4);
    List<StateChangeToEventRule> eventRules = new ArrayList<StateChangeToEventRule>();
    private CCSOperationalState ccsState = CCSOperationalState.NORMAL;
    private CameraOperationalState camState = CameraOperationalState.NORMAL;
    private CCSSalState salState = CCSSalState.PUBLISH_ONLY;

    public StatusAggregator getStatusAggregator() {
        return this.sa;
    }

    public MCMUtilities(Agent agent) {
        this.mcm = agent;
        this.agentMessagingLayer = agent.getMessagingAccess();
        this.cmu = new ConcurrentMessagingUtils(this.agentMessagingLayer);
        this.apm = this.agentMessagingLayer.getAgentPresenceManager();
        this.apm.addAgentPresenceListener((AgentPresenceListener)this);
        this.agentMessagingLayer.addStatusMessageListener((StatusMessageListener)this.sa);
        this.agentMessagingLayer.addStatusMessageListener((StatusMessageListener)this.sba);
        this.minionNames.put(Minion.RAFTS, "raftsim");
        this.minionNames.put(Minion.SHUTTER, "shuttersim");
        this.minionNames.put(Minion.FILTER, "filtersim");
        for (String string : this.minionNames.values()) {
            this.sba.addOrigin(string);
        }
        for (Map.Entry entry : this.minionNames.entrySet()) {
            this.name2minion.put((String)entry.getValue(), (Minion)((Object)entry.getKey()));
        }
        for (AgentInfo agentInfo : this.apm.listConnectedAgents()) {
            Minion m = this.name2minion.get(agentInfo.getName());
            if (m == null) continue;
            this.presentMinions.add(m);
        }
        this.execute(() -> {
            this.waitMillis(5000L);
            this.checkCamOpState();
            this.checkPresence();
        });
        this.sba.addObserver((source, old, change) -> this.minionStateChange(source, old, change));
        this.initEventRules();
        this.sa.setAggregate("raftsim/temperature", 10000, 60000);
    }

    public Object send(Minion dst, String command, Object ... parms) throws Exception {
        CommandRequest cmd = new CommandRequest(this.minionNames.get((Object)dst), command, parms);
        return this.cmu.sendSynchronousCommand(cmd, Duration.ofMillis(this.defaultTimeout));
    }

    public Object sendLongCommand(Minion dst, long timeout, String command, Object ... parms) throws Exception {
        CommandRequest cmd = new CommandRequest(this.minionNames.get((Object)dst), command, parms);
        return this.cmu.sendSynchronousCommand(cmd, Duration.ofMillis(timeout));
    }

    public Future<Object> sendAsync(Minion dst, String command, Object ... parms) {
        CommandRequest cmd = new CommandRequest(this.minionNames.get((Object)dst), command, parms);
        return this.cmu.sendAsynchronousCommand(cmd);
    }

    public void setAbortingOnAlarmMinions(Minion ... m) {
        this.abortingOnAlarmMinions.clear();
        this.abortingOnAlarmMinions.addAll(Arrays.asList(m));
        this.createAlarmFilter();
    }

    private void createAlarmFilter() {
        this.alarmFilter = this.abortingOnAlarmMinions.stream().map(mm -> BusMessageFilterFactory.messageOrigin((String)this.minionNames.get(mm))).reduce(Predicate::and).orElse(x -> false).and(BusMessageFilterFactory.embeddedObjectClass(Alert.class));
    }

    public ScheduledFuture<?> schedule(Runnable r, Duration delay) {
        return this.scheduler.schedule(r, delay.toMillis(), TimeUnit.MILLISECONDS);
    }

    public Future<?> execute(Runnable r) {
        return this.scheduler.submit(r);
    }

    public Future<StatusMessage> watchForState(Minion sys, Enum state) {
        Predicate<Object> f = BusMessageFilterFactory.messageOrigin((String)this.minionNames.get((Object)sys)).and(BusMessageFilterFactory.messageClass(StatusMessage.class));
        Predicate<BusMessage> p = m -> ((StatusMessage)m).getState().isInState(state);
        f = f.and(p);
        for (Minion m2 : this.abortingOnAlarmMinions) {
            Predicate x = BusMessageFilterFactory.embeddedObjectClass(Alert.class).and(BusMessageFilterFactory.messageOrigin((String)this.minionNames.get((Object)m2)));
            f = f.or(x);
        }
        return this.cmu.startListeningForStatusBusMessage(f);
    }

    public <T extends Enum<T>> void checkState(Minion sys, T state) {
        StateBundle current = this.sba.getState(this.minionNames.get((Object)sys));
        if (current == null || !current.isInState(state)) {
            throw new InvalidStateException(current == null ? "null" : current.toString(), " expecting " + state);
        }
    }

    @SafeVarargs
    public final <T extends Enum<T>> void checkState(Minion sys, T ... state) {
        StateBundle current = this.sba.getState(this.minionNames.get((Object)sys));
        if (current != null) {
            for (T s : state) {
                if (!current.isInState(s)) continue;
                return;
            }
        }
        StringBuilder expected = new StringBuilder("current state ");
        expected.append(current == null ? "null" : current.toString());
        expected.append(" expecting one of [");
        for (int i = 0; i < state.length; ++i) {
            expected.append(((Enum)state[i]).toString());
            if (i >= state.length - 1) continue;
            expected.append(", ");
        }
        expected.append("]");
        throw new InvalidStateException(expected.toString());
    }

    public <T extends Enum<T>> boolean isInState(Minion sys, T state) {
        StateBundle current = this.sba.getState(this.minionNames.get((Object)sys));
        if (current == null) {
            return false;
        }
        return current.isInState(state);
    }

    public <T extends Enum<T>> void waitForState(Minion sys, T state, long timeout) {
        Future<StatusMessage> f = this.watchForState(sys, state);
        StateBundle current = this.sba.getState(this.minionNames.get((Object)sys));
        if (current != null && current.isInState(state)) {
            this.log.info((Object)("state for " + (Object)((Object)sys) + " already ok for " + state));
            return;
        }
        this.log.debug((Object)("current state for " + (Object)((Object)sys) + " : " + current));
        try {
            StatusMessage m = f.get(timeout, TimeUnit.MILLISECONDS);
            if (m != null) {
                this.log.debug((Object)("received " + m.getState()));
            }
            if (m == null) {
                if (this.sba.getState(this.minionNames.get((Object)sys)).isInState(state)) {
                    this.log.info((Object)"null future, but in state");
                } else {
                    this.log.info((Object)"null future, not in state");
                    this.log.info((Object)this.sba.getState(this.minionNames.get((Object)sys)));
                    throw new OperationTimeoutException("waiting for state " + state + " on " + (Object)((Object)sys));
                }
            }
            if (m instanceof StatusRaisedAlert) {
                throw new AlarmException("interrupted waitForState", (Alert)((StatusRaisedAlert)m).getObject());
            }
        }
        catch (TimeoutException e) {
            throw new OperationTimeoutException("waiting for state " + state + " on " + (Object)((Object)sys), (Throwable)e);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public <T extends Enum<T>> ExpectedStateCombination expectingState(Minion m, T state) {
        return new ExpectedStateCombination(m, state);
    }

    public void waitMillis(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            this.log.error((Object)"wait interrupted ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void connecting(AgentInfo agent) {
        Minion m = this.name2minion.get(agent.getName());
        if (m != null) {
            this.presentMinions.add(m);
            this.checkPresence();
        }
    }

    public void disconnecting(AgentInfo agent) {
        Minion m = this.name2minion.get(agent.getName());
        if (m != null) {
            this.presentMinions.remove((Object)m);
            this.checkPresence();
        }
    }

    public void initEventRules() {
        this.eventRules.add(new SingleStateChangeToEventRule(Minion.FILTER, (Enum)FcsEnumerations.FilterState.ONLINE_U, MCMEvent.filterULoaded));
        this.eventRules.add(new SingleStateChangeToEventRule(Minion.FILTER, (Enum)FcsEnumerations.FilterState.ONLINE_G, MCMEvent.filterGLoaded));
        this.eventRules.add(new SingleStateChangeToEventRule(Minion.FILTER, (Enum)FcsEnumerations.FilterState.ONLINE_R, MCMEvent.filterRLoaded));
        this.eventRules.add(new SingleStateChangeToEventRule(Minion.FILTER, (Enum)FcsEnumerations.FilterState.ONLINE_I, MCMEvent.filterILoaded));
        this.eventRules.add(new SingleStateChangeToEventRule(Minion.FILTER, (Enum)FcsEnumerations.FilterState.ONLINE_Z, MCMEvent.filterZLoaded));
        this.eventRules.add(new SingleStateChangeToEventRule(Minion.FILTER, (Enum)FcsEnumerations.FilterState.ONLINE_Y, MCMEvent.filterYLoaded));
        this.eventRules.add(new SingleStateChangeToEventRule(Minion.FILTER, (Enum)FcsEnumerations.FilterState.ONLINE_NONE, MCMEvent.filterNoneLoaded));
        this.eventRules.add(new DefaultStateChangeToEventRule(Minion.FILTER, FcsEnumerations.FilterState.class, MCMEvent.filterSystemMoving));
        this.eventRules.add(new SingleStateChangeToEventRule(Minion.RAFTS, (Enum)RaftState.QUIESCENT, MCMEvent.ccdCleared));
        this.eventRules.add(new SingleStateChangeToEventRule(Minion.RAFTS, (Enum)RaftState.INTEGRATING, MCMEvent.startIntegration));
        this.eventRules.add(new SingleStateChangeToEventRule(Minion.RAFTS, (Enum)RaftState.READING_OUT, MCMEvent.startReadout));
        this.eventRules.add(new SingleStateChangeOutToEventRule(Minion.RAFTS, (Enum)RaftState.READING_OUT, MCMEvent.endReadout));
        this.eventRules.add(new SingleStateChangeToEventRule(Minion.RAFTS, (Enum)RaftState.NEEDS_CLEAR, MCMEvent.ccdNotReady));
        this.eventRules.add(new SingleStateChangeToEventRule(Minion.SHUTTER, (Enum)ShutterState.OPENING, MCMEvent.startShutterOpen));
        this.eventRules.add(new SingleStateChangeToEventRule(Minion.SHUTTER, (Enum)ShutterState.OPEN, MCMEvent.endShutterOpen));
        this.eventRules.add(new SingleStateChangeToEventRule(Minion.SHUTTER, (Enum)ShutterState.CLOSING, MCMEvent.startShutterClose));
        this.eventRules.add(new SingleStateChangeToEventRule(Minion.SHUTTER, (Enum)ShutterState.CLOSED, MCMEvent.endShutterClose));
    }

    public void checkEventRules(StateBundle out, StateBundle change) {
        MCMEvent bestEvent = null;
        int level = 0;
        for (StateChangeToEventRule rule : this.eventRules) {
            int l = rule.matches(out, change);
            if (l <= level) continue;
            level = l;
            bestEvent = rule.getEvent();
        }
        if (bestEvent != null) {
            this.log.info((Object)("sending MCM event " + bestEvent));
            StatusEnum message = new StatusEnum((Enum)bestEvent, this.mcm.getState());
            this.mcm.getMessagingAccess().sendStatusMessage((StatusMessage)message);
        }
    }

    public void minionStateChange(String source, StateBundle out, StateBundle change) {
        this.log.info((Object)("from " + source + " state change " + change));
        if (change.getState(OperationalState.class) != null) {
            this.checkCamOpState();
        }
        this.checkEventRules(out, change);
    }

    void checkPresence() {
        CCSOperationalState newS = this.ccsState;
        newS = this.presentMinions.size() < this.minionNames.size() ? CCSOperationalState.MISSING_SUBSYSTEM : CCSOperationalState.NORMAL;
        if (this.ccsState != newS) {
            this.ccsState = newS;
            this.mcm.updateAgentState(new Enum[]{this.ccsState});
            this.log.info((Object)("MCM state: " + this.ccsState));
        }
    }

    void checkCamOpState() {
        CameraOperationalState newS = this.camState;
        for (String mn : this.minionNames.values()) {
            StateBundle sb = this.sba.getState(mn);
            if (sb != null) {
                OperationalState s = (OperationalState)sb.getState(OperationalState.class);
                if (s == null) {
                    newS = CameraOperationalState.ENGINEERING_FAULT;
                    break;
                }
                if (s.equals((Object)OperationalState.ENGINEERING_FAULT)) {
                    newS = CameraOperationalState.ENGINEERING_FAULT;
                    break;
                }
                if (!s.equals((Object)OperationalState.ENGINEERING_OK)) continue;
                newS = CameraOperationalState.ENGINEERING_OK;
                continue;
            }
            newS = CameraOperationalState.ENGINEERING_FAULT;
            break;
        }
        if (!newS.equals((Object)this.camState)) {
            this.log.info((Object)("camera operational state " + this.camState + " -> " + newS));
            this.camState = newS;
            this.mcm.updateAgentState(new Enum[]{this.camState});
        }
    }

    void checkSalState() {
        CCSSalState newS = this.salState;
        if (this.camState == CameraOperationalState.ENGINEERING_FAULT) {
            this.salState = CCSSalState.FAULT;
        }
        if (!newS.equals((Object)this.salState)) {
            this.log.info((Object)("camera SAL state " + this.salState + " -> " + newS));
            this.salState = newS;
            this.mcm.updateAgentState(new Enum[]{this.salState});
        }
    }

    private class CombinedStatesChangeToEventRule
    extends StateChangeToEventRule {
        Map<Minion, Enum> states;

        public CombinedStatesChangeToEventRule(Minion m, Enum state, MCMEvent e) {
            super(e);
            this.states = new EnumMap<Minion, Enum>(Minion.class);
            this.states.put(m, state);
        }

        public CombinedStatesChangeToEventRule addState(Minion m, Enum state) {
            this.states.put(m, state);
            return this;
        }

        @Override
        public int matches(StateBundle out, StateBundle changes) {
            throw new RuntimeException("not implemented");
        }
    }

    private class SingleStateChangeOutToEventRule
    extends StateChangeToEventRule {
        Minion minion;
        Enum outState;

        public SingleStateChangeOutToEventRule(Minion m, Enum out, MCMEvent e) {
            super(e);
            this.minion = m;
            this.outState = out;
        }

        @Override
        public int matches(StateBundle out, StateBundle changes) {
            return out.isInState(this.outState) ? 2 : 0;
        }
    }

    private class SingleStateChangeToEventRule
    extends StateChangeToEventRule {
        Minion minion;
        Enum state;

        public SingleStateChangeToEventRule(Minion m, Enum s, MCMEvent e) {
            super(e);
            this.minion = m;
            this.state = s;
        }

        @Override
        public int matches(StateBundle out, StateBundle changes) {
            return changes.isInState(this.state) ? 2 : 0;
        }
    }

    private class DefaultStateChangeToEventRule
    extends StateChangeToEventRule {
        Minion minion;
        Class<FcsEnumerations.FilterState> stateClass;

        public DefaultStateChangeToEventRule(Minion m, Class<FcsEnumerations.FilterState> s, MCMEvent e) {
            super(e);
            this.stateClass = s;
            this.minion = m;
        }

        @Override
        public int matches(StateBundle out, StateBundle changes) {
            return changes.getState(this.stateClass) == null ? 0 : 1;
        }
    }

    private abstract class StateChangeToEventRule {
        protected MCMEvent event;

        public StateChangeToEventRule(MCMEvent e) {
            this.event = e;
        }

        public MCMEvent getEvent() {
            return this.event;
        }

        public abstract int matches(StateBundle var1, StateBundle var2);
    }

    public final class ExpectedStateCombination {
        private Map<Minion, Enum> states = new EnumMap<Minion, Enum>(Minion.class);

        private ExpectedStateCombination(Minion m, Enum<?> state) {
            this.states.put(m, state);
        }

        private ExpectedStateCombination(ExpectedStateCombination src, Minion m, Enum<?> state) {
            this.states.putAll(src.states);
            this.states.put(m, state);
        }

        public ExpectedStateCombination expectingState(Minion m, Enum<?> state) {
            return new ExpectedStateCombination(this, m, state);
        }

        private <T extends Enum<T>> Predicate<BusMessage<? extends Serializable, ?>> filter(Minion sys, T state) {
            return BusMessageFilterFactory.messageOrigin((String)((String)MCMUtilities.this.minionNames.get((Object)sys))).and(m -> ((StatusMessage)m).getState().isInState(state));
        }

        private Predicate<BusMessage<? extends Serializable, ?>> createFilter(Minion sys) {
            return this.filter(sys, this.states.get((Object)sys)).or(MCMUtilities.this.alarmFilter);
        }

        public void waitForAllStatesHappening(long timeout) {
            HashSet<Minion> waitingFor = new HashSet<Minion>(this.states.keySet());
            for (Map.Entry<Minion, Enum> e : this.states.entrySet()) {
                if (!MCMUtilities.this.sba.getState((String)MCMUtilities.this.minionNames.get((Object)e.getKey())).isInState(e.getValue())) continue;
                waitingFor.remove((Object)e.getKey());
            }
            MCMUtilities.this.log.debug((Object)("waiting for subsystems " + waitingFor + " timeout " + timeout));
            if (waitingFor.isEmpty()) {
                MCMUtilities.this.log.debug((Object)"waitForAllStatesHappening: already all in state");
                return;
            }
            int timeoutseconds = timeout > 1000L ? (int)timeout / 1000 : 1;
            HashSet<Future> futures = new HashSet<Future>();
            for (Minion m : waitingFor) {
                Predicate<BusMessage<? extends Serializable, ?>> f = this.createFilter(m);
                futures.add(MCMUtilities.this.cmu.startListeningForStatusBusMessage(f, Duration.ofMillis(timeoutseconds)));
            }
            for (Future f : futures) {
                try {
                    f.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    MCMUtilities.this.log.warn((Object)"interrupted");
                    throw new RuntimeException(e);
                }
            }
        }

        public void waitForAllStates(long timeout) {
            long endTimeout = System.currentTimeMillis() + timeout;
            block0: while (System.currentTimeMillis() < endTimeout) {
                this.waitForAllStatesHappening(endTimeout - System.currentTimeMillis());
                for (Map.Entry<Minion, Enum> e : this.states.entrySet()) {
                    if (MCMUtilities.this.sba.getState((String)MCMUtilities.this.minionNames.get((Object)e.getKey())).isInState(e.getValue())) continue;
                    continue block0;
                }
                return;
            }
            throw new OperationTimeoutException("waitForAllStates");
        }
    }
}

