/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.mcm;

import java.io.Serializable;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.lsst.ccs.Agent;
import org.lsst.ccs.UsesSubsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.StatusEnum;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystem.mcm.AlarmException;
import org.lsst.ccs.subsystem.mcm.MCMUtilities;
import org.lsst.ccs.subsystem.mcm.Minion;
import org.lsst.ccs.subsystem.mcm.data.CameraStatus;
import org.lsst.ccs.subsystem.mcm.data.InvalidStateException;
import org.lsst.ccs.subsystem.mcm.data.MCMEvent;
import org.lsst.ccs.subsystem.mcm.data.MCMState;
import org.lsst.ccs.subsystem.mcm.data.OperationTimeoutException;
import org.lsst.ccs.subsystem.mcm.data.RaftState;
import org.lsst.ccs.subsystem.mcm.data.ShutterState;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.utilities.logging.Logger;

public class MCM
extends Module
implements UsesSubsystem {
    protected MCMUtilities mu;
    Map<MCMState, Set<MCMCommand>> allowedTransition = new HashMap<MCMState, Set<MCMCommand>>();
    protected Random random = new Random();
    protected static final Logger log = Logger.getLogger((String)"org.lsst.ccs.subsystem.mcm");
    private final ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(4);
    volatile ScheduledFuture<?> imageTimeoutFuture = null;

    public void initModule() {
        this.initAllowedTransitions();
        this.mu = new MCMUtilities((Agent)this.getSubsystem());
        this.setState(MCMState.IDLE);
    }

    protected void setState(MCMState s) {
        log.info((Object)("MCM State " + s));
        this.getSubsystem().updateAgentState(new Enum[]{s});
    }

    protected void initAllowedTransitions() {
        HashSet<MCMCommand> s = new HashSet<MCMCommand>();
        s.addAll(Arrays.asList(MCMCommand.values()));
        s.remove((Object)MCMCommand.DISCARDROWS);
        s.remove((Object)MCMCommand.ENDIMAGE);
        this.allowedTransition.put(MCMState.IDLE, s);
        s = new HashSet();
        s.add(MCMCommand.INITGUIDER);
        this.allowedTransition.put(MCMState.TAKINGIMAGES, s);
        s = new HashSet();
        s.add(MCMCommand.INITIMAGES);
        this.allowedTransition.put(MCMState.SETTINGFILTER, s);
        s = new HashSet();
        this.allowedTransition.put(MCMState.PREPARING, s);
        s = new HashSet();
        s.add(MCMCommand.INITGUIDER);
        s.add(MCMCommand.ENDIMAGE);
        s.add(MCMCommand.DISCARDROWS);
        this.allowedTransition.put(MCMState.IMAGESTARTED, s);
        s = new HashSet();
        this.allowedTransition.put(MCMState.CONFIGURING, s);
    }

    protected void checkCommandValidity(MCMCommand cmd) {
        MCMState state = (MCMState)this.getSubsystem().getState(MCMState.class);
        if (!this.allowedTransition.get(state).contains((Object)cmd)) {
            log.error((Object)("Command " + (Object)((Object)cmd) + " not allowed in state " + state));
            throw new RuntimeException("Command " + (Object)((Object)cmd) + " not allowed in state " + state);
        }
    }

    @Command
    public void initImages(long delay) {
        this.checkCommandValidity(MCMCommand.INITIMAGES);
        this.setState(MCMState.PREPARING);
        this.doInitImages(delay);
        this.setState(MCMState.IDLE);
    }

    protected void doInitImages(long delay) {
        this.setAbortingOnAlarmMinions(new Minion[0]);
        if (delay < 70L) {
            log.info((Object)"sending clear to rafts");
            this.sendAsync(Minion.RAFTS, "clear", new Object[0]);
            log.info((Object)"sending prepare to shutter");
            this.sendAsync(Minion.SHUTTER, "prepare", new Object[0]);
        } else {
            this.schedule(() -> this.sendAsync(Minion.RAFTS, "clear", new Object[0]), Duration.ofMillis(delay - 70L));
            if (delay < 150L) {
                this.sendAsync(Minion.SHUTTER, "prepare", new Object[0]);
            } else {
                this.schedule(() -> this.sendAsync(Minion.SHUTTER, "prepare", new Object[0]), Duration.ofMillis(delay - 150L));
            }
        }
    }

    @Command
    public void configureCamera(String configId) {
        this.checkCommandValidity(MCMCommand.CONFIGURECAMERA);
        this.setState(MCMState.CONFIGURING);
        Future<?> e1 = this.execute(() -> {
            log.info((Object)"e1 - start");
            this.waitMillis(1000L);
            log.info((Object)"e1 - end");
        });
        Future<?> e2 = this.execute(() -> {
            log.info((Object)"e2 - start");
            this.waitMillis(1500L);
            log.info((Object)"e2 - end");
        });
        try {
            e2.get();
            e1.get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.error((Object)e);
        }
        log.info((Object)"done");
        this.setState(MCMState.IDLE);
    }

    @Command
    public void setFilter(String filterName) {
        this.setFilterSync(filterName);
    }

    @Command
    public void setFilterAsync(String filterName) {
        FcsEnumerations.FilterState goal;
        this.checkCommandValidity(MCMCommand.SETFILTER);
        this.setAbortingOnAlarmMinions(Minion.FILTER);
        filterName = filterName.toUpperCase();
        FcsEnumerations.FilterState filterState = goal = "NONE".equals(filterName) ? FcsEnumerations.FilterState.ONLINE_NONE : FcsEnumerations.FilterState.valueOf((String)("ONLINE_" + filterName));
        if (this.isInState(Minion.FILTER, goal)) {
            log.info((Object)("MCM : filter already ok for " + filterName));
            return;
        }
        this.setState(MCMState.SETTINGFILTER);
        log.info((Object)("MCM : sending command to fcs : setFilter filter" + filterName));
        this.sendAsync(Minion.FILTER, "setFilter", filterName);
        this.execute(() -> {
            try {
                this.waitForState(Minion.FILTER, goal, 60000L);
            }
            catch (OperationTimeoutException e) {
                log.error((Object)"timeout while waiting", (Throwable)e);
                throw e;
            }
            catch (AlarmException e) {
                log.error((Object)("alarm occurred - cause= " + e.alarm.getDescription()));
                throw new RuntimeException("alarm occurred " + e.getMessage() + " while setFilter Alert description=" + e.alarm.getDescription());
            }
            catch (Exception e) {
                log.error((Object)"error", (Throwable)e);
                throw new RuntimeException("error ", e);
            }
            finally {
                this.setState(MCMState.IDLE);
            }
        });
    }

    @Command
    public void setFilterSync(String filterName) {
        FcsEnumerations.FilterState goal;
        this.checkCommandValidity(MCMCommand.SETFILTER);
        this.setAbortingOnAlarmMinions(Minion.FILTER);
        filterName = filterName.toUpperCase();
        FcsEnumerations.FilterState filterState = goal = "NONE".equals(filterName) ? FcsEnumerations.FilterState.ONLINE_NONE : FcsEnumerations.FilterState.valueOf((String)("ONLINE_" + filterName));
        if (this.isInState(Minion.FILTER, goal)) {
            log.info((Object)("MCM : filter already ok for " + filterName));
            return;
        }
        this.setState(MCMState.SETTINGFILTER);
        log.info((Object)("MCM : sending command to fcs : setFilter filter" + filterName));
        try {
            this.sendLongCommand(Minion.FILTER, 60000L, "setFilter", filterName);
            this.waitForState(Minion.FILTER, goal, 60000L);
        }
        catch (OperationTimeoutException e) {
            log.error((Object)"timeout while waiting", (Throwable)e);
            throw e;
        }
        catch (AlarmException e) {
            log.error((Object)("alarm occurred - cause= " + e.alarm.getDescription()));
            throw new RuntimeException("alarm occurred " + e.getMessage() + " while setFilter Alert description=" + e.alarm.getDescription());
        }
        catch (Exception e) {
            log.error((Object)"error", (Throwable)e);
            throw new RuntimeException("error ", e);
        }
        finally {
            this.setState(MCMState.IDLE);
        }
        log.info((Object)("filter " + filterName + " is ONLINE."));
    }

    @Command
    public void takeImages(int n, int exposureMillis, boolean openShutter, boolean scienceActive, boolean guidingActive, boolean WFSActive, String seqName) {
        this.takeImagesSync(n, exposureMillis, openShutter, scienceActive, guidingActive, WFSActive, seqName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(level=1)
    public void takeImagesSync(int n, int exposureMillis, boolean openShutter, boolean scienceActive, boolean guidingActive, boolean WFSActive, String seqName) {
        this.checkCommandValidity(MCMCommand.TAKEIMAGES);
        if (openShutter && exposureMillis < 1000) {
            throw new RuntimeException("cannot handle opening the shutter for less that 1 second");
        }
        this.checkState(Minion.FILTER, (Enum)FcsEnumerations.FilterReadinessState.READY);
        this.setState(MCMState.TAKINGIMAGES);
        if (!this.isInState(Minion.RAFTS, RaftState.QUIESCENT)) {
            this.doInitImages(0L);
            this.waitForState(Minion.RAFTS, RaftState.QUIESCENT, 200L);
        }
        try {
            for (int i = 0; i < n; ++i) {
                try {
                    log.info((Object)"MCM: send raft integrate");
                    this.send(Minion.RAFTS, "integrate", new Object[0]);
                    this.waitForState(Minion.RAFTS, RaftState.INTEGRATING, 200L);
                    log.info((Object)"MCM: raft is integrating");
                    if (openShutter) {
                        log.info((Object)"MCM: send shutter expose");
                        this.sendAsync(Minion.SHUTTER, "expose", exposureMillis);
                        this.waitForState(Minion.SHUTTER, ShutterState.OPEN, 1200L);
                        log.info((Object)"MCM: shutter is open");
                        this.waitForState(Minion.SHUTTER, ShutterState.CLOSED, (long)exposureMillis + 3000L);
                        log.info((Object)"MCM: shutter is closed");
                    } else {
                        this.waitMillis(exposureMillis);
                        log.info((Object)"MCM: exposure time elapsed, with closed shutter");
                    }
                    log.info((Object)"MCM: send raft readout");
                    this.send(Minion.RAFTS, "readout", new Object[0]);
                    this.waitForState(Minion.RAFTS, RaftState.READING_OUT, 200L);
                    log.info((Object)"MCM: raft is reading out");
                    this.waitForState(Minion.RAFTS, RaftState.QUIESCENT, 3000L);
                    log.info((Object)"MCM: raft is quiescent");
                    continue;
                }
                catch (OperationTimeoutException e) {
                    log.error((Object)"timeout while waiting", (Throwable)e);
                    throw e;
                }
                catch (Exception e) {
                    log.error((Object)"error", (Throwable)e);
                    throw new RuntimeException("error ", e);
                }
            }
        }
        finally {
            this.setState(MCMState.IDLE);
        }
    }

    @Command(level=1)
    public void takeImagesAsync(int n, int exposureMillis, boolean openShutter, boolean scienceActive, boolean guidingActive, boolean WFSActive, String seqName) {
        this.checkCommandValidity(MCMCommand.TAKEIMAGES);
        if (openShutter && exposureMillis < 1000) {
            throw new RuntimeException("cannot handle opening the shutter for less that 1 second");
        }
        this.checkState(Minion.FILTER, (Enum)FcsEnumerations.FilterReadinessState.READY);
        this.setState(MCMState.TAKINGIMAGES);
        if (!this.isInState(Minion.RAFTS, RaftState.QUIESCENT)) {
            this.doInitImages(0L);
            this.waitForState(Minion.RAFTS, RaftState.QUIESCENT, 200L);
        }
        this.execute(() -> {
            try {
                for (int i = 0; i < n; ++i) {
                    try {
                        log.info((Object)"MCM: send raft integrate");
                        this.send(Minion.RAFTS, "integrate", new Object[0]);
                        this.waitForState(Minion.RAFTS, RaftState.INTEGRATING, 200L);
                        log.info((Object)"MCM: raft is integrating");
                        if (openShutter) {
                            log.info((Object)"MCM: send shutter expose");
                            this.sendAsync(Minion.SHUTTER, "expose", exposureMillis);
                            this.waitForState(Minion.SHUTTER, ShutterState.OPEN, 1200L);
                            log.info((Object)"MCM: shutter is open");
                            this.waitForState(Minion.SHUTTER, ShutterState.CLOSED, (long)exposureMillis + 3000L);
                            log.info((Object)"MCM: shutter is closed");
                        } else {
                            this.waitMillis(exposureMillis);
                            log.info((Object)"MCM: exposure time elapsed, with closed shutter");
                        }
                        log.info((Object)"MCM: send raft readout");
                        this.send(Minion.RAFTS, "readout", new Object[0]);
                        this.waitForState(Minion.RAFTS, RaftState.READING_OUT, 200L);
                        log.info((Object)"MCM: raft is reading out");
                        this.waitForState(Minion.RAFTS, RaftState.QUIESCENT, 3000L);
                        log.info((Object)"MCM: raft is quiescent");
                        continue;
                    }
                    catch (OperationTimeoutException e) {
                        log.error((Object)"timeout while waiting", (Throwable)e);
                        throw e;
                    }
                    catch (Exception e) {
                        log.error((Object)"error", (Throwable)e);
                        throw new RuntimeException("error ", e);
                    }
                }
            }
            finally {
                this.setState(MCMState.IDLE);
            }
        });
    }

    @Command
    public void initGuiders() {
        this.checkCommandValidity(MCMCommand.INITGUIDER);
    }

    @Command
    public void clear(int n) {
        this.checkCommandValidity(MCMCommand.CLEAR);
        try {
            this.send(Minion.RAFTS, "clear", n);
        }
        catch (OperationTimeoutException e) {
            log.error((Object)"timeout while waiting", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.error((Object)"error", (Throwable)e);
            throw new RuntimeException("error ", e);
        }
    }

    @Command
    public void startImage(String seqName, boolean openShutter, boolean scienceActive, boolean WFSActive, boolean guidingActive, int timeoutMillis) {
        this.checkCommandValidity(MCMCommand.STARTIMAGE);
        this.checkState(Minion.FILTER, (Enum)FcsEnumerations.FilterReadinessState.READY);
        this.setState(MCMState.IMAGESTARTED);
        if (!this.isInState(Minion.RAFTS, RaftState.QUIESCENT)) {
            this.doInitImages(0L);
            this.waitForState(Minion.RAFTS, RaftState.QUIESCENT, 200L);
        }
        try {
            log.info((Object)"MCM: send raft integrate");
            this.send(Minion.RAFTS, "integrate", new Object[0]);
            this.waitForState(Minion.RAFTS, RaftState.INTEGRATING, 200L);
            log.info((Object)"MCM: raft is integrating");
            if (openShutter) {
                log.info((Object)"MCM: send shutter expose");
                this.sendAsync(Minion.SHUTTER, "expose", timeoutMillis);
                this.waitForState(Minion.SHUTTER, ShutterState.OPEN, 1200L);
                log.info((Object)"MCM: shutter is open");
            }
            this.imageTimeoutFuture = this.scheduler.schedule(() -> this.startImageTimeout(), (long)timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (OperationTimeoutException e) {
            log.error((Object)"timeout while waiting", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.error((Object)"error", (Throwable)e);
            throw new RuntimeException("error ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startImageTimeout() {
        ScheduledFuture<?> scheduledFuture = this.imageTimeoutFuture;
        synchronized (scheduledFuture) {
            if (this.imageTimeoutFuture == null) {
                return;
            }
            this.imageTimeoutFuture = null;
            log.info((Object)"MCM: timeout on startImage");
            this.sendAsync(Minion.SHUTTER, "close", new Object[0]);
            this.sendAsync(Minion.RAFTS, "clear", new Object[0]);
            this.waitForState(Minion.SHUTTER, ShutterState.CLOSED, 2000L);
            log.info((Object)"MCM: shutter is closed");
            this.setState(MCMState.IDLE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command
    public void endImage() {
        ScheduledFuture<?> scheduledFuture = this.imageTimeoutFuture;
        synchronized (scheduledFuture) {
            if (this.imageTimeoutFuture == null) {
                return;
            }
            this.imageTimeoutFuture.cancel(false);
            this.imageTimeoutFuture = null;
            this.checkCommandValidity(MCMCommand.ENDIMAGE);
            log.info((Object)"MCM: endImage, closing shutter");
            this.sendAsync(Minion.SHUTTER, "close", new Object[0]);
            this.waitForState(Minion.SHUTTER, ShutterState.CLOSED, 2000L);
            log.info((Object)"MCM: shutter is closed, send raft readout");
            this.sendAsync(Minion.RAFTS, "readout", new Object[0]);
            this.waitForState(Minion.RAFTS, RaftState.READING_OUT, 200L);
            log.info((Object)"MCM: raft is reading out");
            this.setState(MCMState.IDLE);
        }
    }

    @Command
    public void discardRows(int n) {
        this.checkCommandValidity(MCMCommand.DISCARDROWS);
        try {
            this.send(Minion.RAFTS, "discardRows", n);
        }
        catch (OperationTimeoutException e) {
            log.error((Object)"timeout while waiting", (Throwable)e);
            throw e;
        }
        catch (InvalidStateException e) {
            log.error((Object)"subsytem not valid state for command", (Throwable)e);
            throw new RuntimeException("subsytem not valid state for command (" + e.getMessage() + ")");
        }
        catch (Exception e) {
            log.error((Object)"error ", (Throwable)e);
            throw new RuntimeException("error ", e);
        }
    }

    public void tick() {
        Map last = this.mu.getStatusAggregator().getAllLast();
        for (Map.Entry ke : last.entrySet()) {
            log.debug((Object)("   status " + (String)ke.getKey() + " last " + ke.getValue() + " avg " + this.mu.getStatusAggregator().getAverage((String)ke.getKey()) + " hist " + this.mu.getStatusAggregator().getHistory((String)ke.getKey()).size()));
            CameraStatus cs = new CameraStatus();
            cs.setRaftTemperature(this.mu.getStatusAggregator().getAverage("raftsim/temperature"));
            log.info((Object)("publish raft avg temp " + cs.getRaftTemperature()));
            KeyValueData d = new KeyValueData("cameraStatus", (Serializable)cs);
            this.getSubsystem().publishSubsystemDataOnStatusBus(d);
        }
    }

    public void publishEvent(MCMEvent e) {
        StatusEnum message = new StatusEnum((Enum)e, this.getSubsystem().getState());
        this.getSubsystem().getMessagingAccess().sendStatusMessage((StatusMessage)message);
    }

    public Object send(Minion dst, String command, Object ... parms) throws Exception {
        return this.mu.send(dst, command, parms);
    }

    public Object sendLongCommand(Minion dst, long duration, String command, Object ... parms) throws Exception {
        return this.mu.sendLongCommand(dst, duration, command, parms);
    }

    public Future<Object> sendAsync(Minion dst, String command, Object ... parms) {
        return this.mu.sendAsync(dst, command, parms);
    }

    public Future<StatusMessage> watchForState(Minion sys, Enum<?> state) {
        return this.mu.watchForState(sys, state);
    }

    public <T extends Enum<T>> void waitForState(Minion sys, T state, long timeout) {
        this.mu.waitForState(sys, state, timeout);
    }

    public void waitMillis(long millis) {
        this.mu.waitMillis(millis);
    }

    public <T extends Enum<T>> void checkState(Minion sys, T state) {
        this.mu.checkState(sys, state);
    }

    @SafeVarargs
    public final <T extends Enum<T>> void checkState(Minion sys, T ... state) {
        this.mu.checkState(sys, state);
    }

    public <T extends Enum<T>> boolean isInState(Minion sys, T state) {
        return this.mu.isInState(sys, state);
    }

    public void setAbortingOnAlarmMinions(Minion ... m) {
        this.mu.setAbortingOnAlarmMinions(m);
    }

    public ScheduledFuture<?> schedule(Runnable r, Duration delay) {
        return this.mu.schedule(r, delay);
    }

    public Future<?> execute(Runnable r) {
        return this.mu.execute(r);
    }

    public <T extends Enum<T>> MCMUtilities.ExpectedStateCombination expectingState(Minion m, T state) {
        return this.mu.expectingState(m, state);
    }

    public static enum MCMCommand {
        INITIMAGES,
        CONFIGURECAMERA,
        SETFILTER,
        TAKEIMAGES,
        INITGUIDER,
        CLEAR,
        STARTIMAGE,
        ENDIMAGE,
        DISCARDROWS;

    }
}

