/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.mcm;

import java.io.Serializable;
import java.time.Duration;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystem.mcm.AlarmException;
import org.lsst.ccs.subsystem.mcm.MCMUtilities;
import org.lsst.ccs.subsystem.mcm.Minion;
import org.lsst.ccs.subsystem.mcm.data.CameraStatus;
import org.lsst.ccs.subsystem.mcm.data.FilterReadinessState;
import org.lsst.ccs.subsystem.mcm.data.FilterState;
import org.lsst.ccs.subsystem.mcm.data.OperationTimeoutException;
import org.lsst.ccs.subsystem.mcm.data.RaftState;
import org.lsst.ccs.subsystem.mcm.data.ShutterReadinessState;
import org.lsst.ccs.subsystem.mcm.data.ShutterState;
import org.lsst.ccs.utilities.logging.Logger;

public class MCM
extends Module {
    protected MCMUtilities mu;
    protected Random random = new Random();
    protected static final Logger log = Logger.getLogger((String)"org.lsst.ccs.subsystem.mcm");

    public MCM(String name, int tickMillis) {
        super(name, tickMillis);
    }

    public void initModule() {
        this.mu = new MCMUtilities((Agent)this.getSubsystem());
    }

    @Command
    public void initImages(long delay) {
        this.setAbortingOnAlarmMinions(new Minion[0]);
        if (delay < 70L) {
            log.info((Object)"sending clear to rafts");
            this.sendAsync(Minion.RAFTS, "clear", new Object[0]);
            log.info((Object)"sending prepare to shutter");
            this.sendAsync(Minion.SHUTTER, "prepare", new Object[0]);
            log.info((Object)"waiting for RAFTS quiescent and shutter READY");
            try {
                int sel = this.random.nextInt() % 4;
                sel = 3;
                switch (sel) {
                    case 0: {
                        this.waitForState(Minion.SHUTTER, ShutterReadinessState.READY, 200L);
                        this.waitForState(Minion.RAFTS, RaftState.QUIESCENT, 200L);
                        break;
                    }
                    case 1: {
                        this.waitForState(Minion.RAFTS, RaftState.QUIESCENT, 200L);
                        this.waitForState(Minion.SHUTTER, ShutterReadinessState.READY, 200L);
                        break;
                    }
                    case 2: {
                        this.expectingState(Minion.SHUTTER, ShutterReadinessState.READY).expectingState(Minion.RAFTS, (Enum<?>)RaftState.QUIESCENT).waitForAllStatesHappening(200L);
                        break;
                    }
                    case 3: {
                        this.expectingState(Minion.SHUTTER, ShutterReadinessState.READY).expectingState(Minion.RAFTS, (Enum<?>)RaftState.QUIESCENT).waitForAllStates(200L);
                    }
                }
            }
            catch (OperationTimeoutException e) {
                log.error((Object)"timeout while waiting", (Throwable)e);
                throw new RuntimeException(e);
            }
            log.info((Object)"Raft and shutter ready");
        } else {
            this.schedule(() -> this.sendAsync(Minion.RAFTS, "clear", new Object[0]), Duration.ofMillis(delay - 70L));
            if (delay < 150L) {
                this.sendAsync(Minion.SHUTTER, "prepare", new Object[0]);
            } else {
                this.schedule(() -> this.sendAsync(Minion.SHUTTER, "prepare", new Object[0]), Duration.ofMillis(delay - 150L));
            }
            try {
                this.waitForState(Minion.RAFTS, RaftState.QUIESCENT, delay + 200L);
                this.waitForState(Minion.SHUTTER, ShutterReadinessState.READY, delay + 200L);
            }
            catch (OperationTimeoutException e) {
                log.error((Object)"timeout while waiting", (Throwable)e);
                throw new RuntimeException(e);
            }
            log.info((Object)"Raft and shutter ready");
        }
    }

    @Command
    public void configureCamera(String configId) {
        Future<?> e1 = this.execute(() -> {
            log.info((Object)"e1 - start");
            this.waitMillis(1000L);
            log.info((Object)"e1 - end");
        });
        Future<?> e2 = this.execute(() -> {
            log.info((Object)"e2 - start");
            this.waitMillis(1500L);
            log.info((Object)"e2 - end");
        });
        try {
            e2.get();
            e1.get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.error((Object)e);
        }
        log.info((Object)"done");
    }

    @Command
    public void setFilter(String filterName) {
        FilterState goal;
        this.setAbortingOnAlarmMinions(Minion.FILTER);
        filterName = filterName.toUpperCase();
        FilterState filterState = goal = "NONE".equals(filterName) ? FilterState.UNLOADED : FilterState.valueOf((String)("LOADED_" + filterName));
        if (this.isInState(Minion.FILTER, goal)) {
            log.info((Object)("MCM : filter already ok for " + filterName));
            return;
        }
        try {
            this.send(Minion.FILTER, "loadFilter", filterName);
            this.waitForState(Minion.FILTER, goal, 60000L);
        }
        catch (OperationTimeoutException e) {
            log.error((Object)"timeout while waiting", (Throwable)e);
            throw e;
        }
        catch (AlarmException e) {
            log.error((Object)"alarm occurred ", (Throwable)e);
            throw new RuntimeException("alarm occurred " + e.getMessage() + " while setFilter");
        }
        catch (Exception e) {
            log.error((Object)"error", (Throwable)e);
            throw new RuntimeException("error ", e);
        }
        log.info((Object)("filter " + filterName + " loaded"));
    }

    @Command
    public void takeImages(int n, int exposureMillis, boolean openShutter, boolean scienceActive, boolean guidingActive, boolean WFSActive) {
        if (openShutter && exposureMillis < 1000) {
            throw new RuntimeException("cannot handle opening the shutter for less that 1 second");
        }
        this.checkState(Minion.RAFTS, (Enum)RaftState.QUIESCENT);
        this.checkState(Minion.FILTER, (Enum)FilterReadinessState.READY);
        for (int i = 0; i < n; ++i) {
            try {
                log.info((Object)"MCM: send raft integrate");
                this.send(Minion.RAFTS, "integrate", new Object[0]);
                this.waitForState(Minion.RAFTS, RaftState.INTEGRATING, 200L);
                log.info((Object)"MCM: raft is integrating");
                if (openShutter) {
                    log.info((Object)"MCM: send shutter expose");
                    this.sendAsync(Minion.SHUTTER, "expose", exposureMillis);
                    this.waitForState(Minion.SHUTTER, ShutterState.OPEN, 1200L);
                    log.info((Object)"MCM: shutter is open");
                    this.waitForState(Minion.SHUTTER, ShutterState.CLOSED, (long)exposureMillis + 3000L);
                    log.info((Object)"MCM: shutter is closed");
                } else {
                    this.waitMillis(exposureMillis);
                    log.info((Object)"MCM: exposure time elapsed, with closed shutter");
                }
                log.info((Object)"MCM: send raft readout");
                this.send(Minion.RAFTS, "readout", new Object[0]);
                if (i == n - 1) break;
                this.waitForState(Minion.RAFTS, RaftState.READING_OUT, 200L);
                log.info((Object)"MCM: raft is reading out");
                this.waitForState(Minion.RAFTS, RaftState.QUIESCENT, 3000L);
                log.info((Object)"MCM: raft is quiescent");
                continue;
            }
            catch (OperationTimeoutException e) {
                log.error((Object)"timeout while waiting", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                log.error((Object)"error", (Throwable)e);
                throw new RuntimeException("error ", e);
            }
        }
    }

    @Command
    public void initGuiders() {
    }

    public void tick() {
        Map last = this.mu.getStatusAggregator().getAllLast();
        for (Map.Entry ke : last.entrySet()) {
            log.debug((Object)("   status " + (String)ke.getKey() + " last " + ke.getValue() + " avg " + this.mu.getStatusAggregator().getAverage((String)ke.getKey()) + " hist " + this.mu.getStatusAggregator().getHistory((String)ke.getKey()).size()));
            CameraStatus cs = new CameraStatus();
            cs.setRaftTemperature(this.mu.getStatusAggregator().getAverage("raftsim/temperature"));
            log.info((Object)("publish raft avg temp " + cs.getRaftTemperature()));
            KeyValueData d = new KeyValueData("cameraStatus", (Serializable)cs);
            this.getSubsystem().publishSubsystemDataOnStatusBus(d);
        }
    }

    public Object send(Minion dst, String command, Object ... parms) throws Exception {
        return this.mu.send(dst, command, parms);
    }

    public Future<Object> sendAsync(Minion dst, String command, Object ... parms) {
        return this.mu.sendAsync(dst, command, parms);
    }

    public Future<StatusMessage> watchForState(Minion sys, Enum<?> state) {
        return this.mu.watchForState(sys, state);
    }

    public <T extends Enum<T>> void waitForState(Minion sys, T state, long timeout) {
        this.mu.waitForState(sys, state, timeout);
    }

    public void waitMillis(long millis) {
        this.mu.waitMillis(millis);
    }

    public <T extends Enum<T>> void checkState(Minion sys, T state) {
        this.mu.checkState(sys, state);
    }

    @SafeVarargs
    public final <T extends Enum<T>> void checkState(Minion sys, T ... state) {
        this.mu.checkState(sys, state);
    }

    public <T extends Enum<T>> boolean isInState(Minion sys, T state) {
        return this.mu.isInState(sys, state);
    }

    public void setAbortingOnAlarmMinions(Minion ... m) {
        this.mu.setAbortingOnAlarmMinions(m);
    }

    public ScheduledFuture<?> schedule(Runnable r, Duration delay) {
        return this.mu.schedule(r, delay);
    }

    public Future<?> execute(Runnable r) {
        return this.mu.execute(r);
    }

    public <T extends Enum<T>> MCMUtilities.ExpectedStateCombination expectingState(Minion m, T state) {
        return this.mu.expectingState(m, state);
    }
}

