package org.lsst.ccs.subsystem.mcm.alerts;

import java.util.HashMap;
import org.lsst.ccs.bus.data.Alert;

/**
 * MCM level Alerts.
 * 
 * @author The LSST CCS Team
 */
public enum McmAlerts {

    MissingSubsystem("MissingSubsystems","Alert raised by the MCM when subsystems are missing");
    
    private final String id, description;
    
    McmAlerts(String id, String description) {
        this.id = id;
        this.description = description;
    }
    
    public String getAlertId() {
        return id;
    }
    
    public String getDescription() {
        return description;
    }
    
    public Alert getAlert(Enum group, Object... parameters) {
        String alertId = id+"/"+group;
        HashMap<String,Object> data = new HashMap<>();
        data.put("group", group.name());
        
        if ( id.equals(MissingSubsystem.id) ) {
            data.put("missing",parameters[0]);
        }
        return new Alert(alertId,description,data);
    }
        
}
