/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.gruth.reports;

import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.gruth.grutils.AnnotatedReport;
import org.lsst.gruth.grutils.Modification;
import org.lsst.gruth.grutils.RawDiagnostic;
import org.lsst.gruth.grutils.TztReport;
import org.lsst.gruth.reports.StoreAgent;

public class AutomaticModifier {
    StoreAgent store;
    String bundle;
    String versionString;
    int lastVersion;
    int previousVersion;
    TreeMap<String, ComparedAnnotation> lastTree = new TreeMap();
    TreeMap<String, ComparedAnnotation> previousTree = new TreeMap();
    int warnings;
    int errors;
    Logger logger = Logger.getLogger("global");

    public AutomaticModifier(StoreAgent store) {
        this.store = store;
    }

    public void compareAndModify(String bundleName, String versionString) throws Exception {
        this.warnings = 0;
        this.errors = 0;
        if (versionString == null) {
            this.lastVersion = this.store.getVersionNumberFor(bundleName);
            this.previousVersion = this.store.getVersion() - 1;
        } else {
            this.lastVersion = Integer.parseInt(versionString);
            this.previousVersion = this.lastVersion - 1;
        }
        this.store.setBundle(this.bundle, this.previousVersion);
        this.previousTree.clear();
        int maxSizePrevious = this.store.size();
        int ix = 0;
        while (ix < maxSizePrevious) {
            AnnotatedReport aReport = this.store.get(ix);
            ComparedAnnotation comparedAnnotation = new ComparedAnnotation(aReport);
            this.previousTree.put(comparedAnnotation.getUniqueKey(), comparedAnnotation);
            ++ix;
        }
        this.store.setBundle(bundleName, this.lastVersion);
        this.lastTree.clear();
        int maxSizeLast = this.store.size();
        int ix2 = 0;
        while (ix2 < maxSizeLast) {
            AnnotatedReport aReport = this.store.get(ix2);
            ComparedAnnotation comparedAnnotation = new ComparedAnnotation(aReport);
            this.lastTree.put(comparedAnnotation.getUniqueKey(), comparedAnnotation);
            ++ix2;
        }
        for (ComparedAnnotation comparedAnnotation : this.lastTree.values()) {
            ComparedAnnotation otherAnnotation = this.previousTree.get(comparedAnnotation.getUniqueKey());
            if (otherAnnotation == null) continue;
            AnnotatedReport lastAnnotated = comparedAnnotation.annotatedReport;
            AnnotatedReport previousAnnotated = otherAnnotation.annotatedReport;
            lastAnnotated.automaticModification(previousAnnotated, this.lastVersion, this.previousVersion);
            Modification modification = lastAnnotated.getModification();
            if (modification == null || modification == Modification.CONFUSING_COMPARISON) {
                TztReport report = lastAnnotated.getReport();
                RawDiagnostic diagnostic = report.getRawDiagnostic();
                if (diagnostic.compareTo(RawDiagnostic.OK_MARK) < 0) {
                    this.logger.log(Level.SEVERE, String.valueOf(report.getUniqueKey()) + " " + (modification != null ? modification : "") + " " + (Object)((Object)report.getRawDiagnostic()));
                    ++this.errors;
                } else if (diagnostic.compareTo(RawDiagnostic.OK_DONE_MARK) < 0) {
                    this.logger.log(Level.WARNING, String.valueOf(report.getUniqueKey()) + " " + (modification != null ? modification : "") + " " + (Object)((Object)report.getRawDiagnostic()));
                    ++this.warnings;
                } else if (modification == Modification.CONFUSING_COMPARISON) {
                    this.logger.log(Level.WARNING, String.valueOf(report.getUniqueKey()) + " " + (modification != null ? modification : "") + " " + (Object)((Object)report.getRawDiagnostic()));
                    ++this.warnings;
                }
            } else {
                switch (modification.getImportance()) {
                    case WARNING: {
                        String message = String.valueOf(comparedAnnotation.getUniqueKey()) + " " + (Object)((Object)lastAnnotated.getModification()) + " " + (Object)((Object)lastAnnotated.getAdvice());
                        this.logger.log(Level.WARNING, message);
                        ++this.warnings;
                        break;
                    }
                    case ERROR: {
                        String messageErr = String.valueOf(comparedAnnotation.getUniqueKey()) + " " + (Object)((Object)lastAnnotated.getModification()) + " " + (Object)((Object)lastAnnotated.getAdvice());
                        this.logger.log(Level.SEVERE, messageErr);
                        ++this.errors;
                    }
                }
            }
            lastAnnotated.setBeenThroughAutomaticComparison(true);
            comparedAnnotation.compared = true;
            otherAnnotation.compared = true;
        }
        for (ComparedAnnotation comparedAnnotation : this.previousTree.values()) {
            if (comparedAnnotation.compared) continue;
            String message = String.valueOf(comparedAnnotation.getUniqueKey()) + " lost with this new test";
            this.logger.log(Level.WARNING, message);
            ++this.warnings;
        }
        this.store.save();
        if (this.warnings > 0 || this.errors > 0) {
            System.out.println(" warnings : " + this.warnings + "\n errors : " + this.errors);
        }
    }

    public static class ComparedAnnotation {
        boolean compared;
        final AnnotatedReport annotatedReport;

        public ComparedAnnotation(AnnotatedReport annotatedReport) {
            this.annotatedReport = annotatedReport;
        }

        public String getUniqueKey() {
            return this.annotatedReport.getReport().getUniqueKey();
        }
    }
}

