/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.gruth.jutils;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.lsst.gruth.jutils.IndirectMap;
import org.lsst.gruth.jutils.MapArgs;

public class BuiltParm
implements Serializable {
    private MapArgs args;
    private final Type type;

    public BuiltParm(Type type, MapArgs args) {
        this.args = args;
        this.type = type;
    }

    public MapArgs getArgs() {
        return this.args;
    }

    public Type getType() {
        return this.type;
    }

    public static BuiltParm bldArray(MapArgs.LEntry ... entries) {
        BuiltParm res = new BuiltParm(Type.ARRAY, MapArgs.argMap(entries));
        return res;
    }

    public static BuiltParm bldArray(Object ... obj) {
        BuiltParm res = new BuiltParm(Type.ARRAY, MapArgs.argList(obj));
        return res;
    }

    public static BuiltParm bldArray(Map<?, ?> map, Object ... obj) {
        BuiltParm res = new BuiltParm(Type.ARRAY, MapArgs.argList(obj));
        return res;
    }

    public static BuiltParm bldList(MapArgs.LEntry ... entries) {
        BuiltParm res = new BuiltParm(Type.LIST, MapArgs.argMap(entries));
        return res;
    }

    public static BuiltParm bldList(Object ... obj) {
        BuiltParm res = new BuiltParm(Type.LIST, MapArgs.argList(obj));
        return res;
    }

    public static BuiltParm bldMap(MapArgs.LEntry ... entries) {
        BuiltParm res = new BuiltParm(Type.MAP, MapArgs.argMap(entries));
        return res;
    }

    public boolean isSafe() {
        return this.args.isSafe();
    }

    public boolean isValuesOnly() {
        return this.args.isValuesOnly();
    }

    public Object fullValue(IndirectMap<String, Object> objectDictionary) {
        switch (this.type) {
            case ARRAY: {
                return this.args.asFullArray(objectDictionary);
            }
            case LIST: {
                return this.args.asFullList(objectDictionary);
            }
            case MAP: 
            case SET: {
                return this.args.asFullMap(objectDictionary);
            }
        }
        throw new Error(" BuiltParm type: should not happen");
    }

    public void overlap(boolean acceptNullvalues, Object[] array) {
        this.args = this.args.overlap(acceptNullvalues, array);
    }

    public void overlap(boolean acceptNullvalues, List<Object> list) {
        this.args = this.args.overlap(acceptNullvalues, list);
    }

    public void overlap(boolean acceptNullvalues, MapArgs map) {
        this.args = this.args.overlap(acceptNullvalues, map);
    }

    public String toString() {
        return String.valueOf(this.args);
    }

    public static enum Type {
        ARRAY,
        LIST,
        MAP,
        SET;

    }
}

