/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.annotations.common.test.reflection.java;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import junit.framework.AssertionFailedError;
import org.hibernate.annotations.common.reflection.Filter;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.annotations.common.reflection.java.JavaReflectionManager;
import org.hibernate.annotations.common.test.reflection.java.XAnnotatedElementTestCase;
import org.hibernate.annotations.common.test.reflection.java.generics.Dad;
import org.hibernate.annotations.common.test.reflection.java.generics.Son;

public class JavaXPropertyTest
extends XAnnotatedElementTestCase {
    private ReflectionManager factory = new JavaReflectionManager();
    private XClass dadAsSeenFromItself = this.factory.toXClass(Dad.class);
    private XClass dadAsSeenFromSon = this.factory.toXClass(Son.class).getSuperclass();

    public void testFollowsJavaBeansConventionsForPropertyNames() throws Exception {
        LinkedList<String> properties = new LinkedList<String>();
        properties.add("collectionProperty");
        properties.add("methodProperty");
        properties.add("primitiveProperty");
        properties.add("primitiveArrayProperty");
        properties.add("arrayProperty");
        properties.add("genericCollectionProperty");
        properties.add("nongenericCollectionProperty");
        properties.add("propertyStartingWithIs");
        properties.add("language");
        List methodProperties = this.dadAsSeenFromSon.getDeclaredProperties("property");
        JavaXPropertyTest.assertEquals((int)properties.size(), (int)methodProperties.size());
        for (XProperty member : methodProperties) {
            JavaXPropertyTest.assertTrue((boolean)properties.contains(member.getName()));
        }
        List fieldProperties = this.dadAsSeenFromSon.getDeclaredProperties("field");
        XProperty field = (XProperty)fieldProperties.get(0);
        JavaXPropertyTest.assertEquals((String)"fieldProperty", (String)field.getName());
    }

    public void testReturnsPropertiesWithUnresolvedParametricTypes() {
        JavaXPropertyTest.assertEquals((int)9, (int)this.dadAsSeenFromItself.getDeclaredProperties("property").size());
    }

    public void testKnowsWhetherItsTypeIsFullyResolved() {
        XProperty notFullyResolvedProperty = this.getPropertyNamed_from("collectionProperty", this.dadAsSeenFromItself.getDeclaredProperties("property"));
        JavaXPropertyTest.assertFalse((boolean)notFullyResolvedProperty.isTypeResolved());
        XProperty fullyResolvedProperty = this.getPropertyNamed_from("collectionProperty", this.dadAsSeenFromSon.getDeclaredProperties("property"));
        JavaXPropertyTest.assertTrue((boolean)fullyResolvedProperty.isTypeResolved());
    }

    public void testCanBeFiltered() {
        JavaXPropertyTest.assertEquals((int)10, (int)this.dadAsSeenFromSon.getDeclaredProperties("property", new Filter(){

            public boolean returnStatic() {
                return true;
            }

            public boolean returnTransient() {
                return false;
            }
        }).size());
    }

    public void testCanBeASimpleType() {
        List declaredProperties = this.dadAsSeenFromSon.getDeclaredProperties("field");
        XProperty p = this.getPropertyNamed_from("fieldProperty", declaredProperties);
        JavaXPropertyTest.assertTrue((boolean)this.factory.equals(p.getType(), String.class));
        JavaXPropertyTest.assertTrue((boolean)this.factory.equals(p.getElementClass(), String.class));
        JavaXPropertyTest.assertTrue((boolean)this.factory.equals(p.getClassOrElementClass(), String.class));
        JavaXPropertyTest.assertNull((Object)p.getCollectionClass());
        JavaXPropertyTest.assertFalse((boolean)p.isArray());
        JavaXPropertyTest.assertFalse((boolean)p.isCollection());
    }

    public void testResolveInterfaceType() {
        List declaredProperties = this.dadAsSeenFromSon.getDeclaredProperties("property");
        XProperty p = this.getPropertyNamed_from("language", declaredProperties);
        JavaXPropertyTest.assertTrue((boolean)this.factory.equals(p.getType(), String.class));
        JavaXPropertyTest.assertTrue((boolean)this.factory.equals(p.getElementClass(), String.class));
        JavaXPropertyTest.assertTrue((boolean)this.factory.equals(p.getClassOrElementClass(), String.class));
        JavaXPropertyTest.assertNull((Object)p.getCollectionClass());
        JavaXPropertyTest.assertNull((Object)p.getMapKey());
        JavaXPropertyTest.assertFalse((boolean)p.isArray());
        JavaXPropertyTest.assertFalse((boolean)p.isCollection());
    }

    public void testCanBeAnArray() {
        List declaredProperties = this.dadAsSeenFromSon.getDeclaredProperties("property");
        XProperty p = this.getPropertyNamed_from("arrayProperty", declaredProperties);
        JavaXPropertyTest.assertTrue((boolean)this.factory.equals(p.getType(), String[].class));
        JavaXPropertyTest.assertTrue((boolean)this.factory.equals(p.getElementClass(), String.class));
        JavaXPropertyTest.assertTrue((boolean)this.factory.equals(p.getClassOrElementClass(), String.class));
        JavaXPropertyTest.assertNull((Object)p.getCollectionClass());
        JavaXPropertyTest.assertNull((Object)p.getMapKey());
        JavaXPropertyTest.assertTrue((boolean)p.isArray());
        JavaXPropertyTest.assertFalse((boolean)p.isCollection());
    }

    public void testCanBeAnArrayOfPrimitives() {
        List declaredProperties = this.dadAsSeenFromSon.getDeclaredProperties("property");
        XProperty p = this.getPropertyNamed_from("primitiveArrayProperty", declaredProperties);
        JavaXPropertyTest.assertTrue((boolean)this.factory.equals(p.getType(), int[].class));
        JavaXPropertyTest.assertTrue((boolean)this.factory.equals(p.getElementClass(), Integer.TYPE));
        JavaXPropertyTest.assertTrue((boolean)this.factory.equals(p.getClassOrElementClass(), Integer.TYPE));
        JavaXPropertyTest.assertNull((Object)p.getCollectionClass());
        JavaXPropertyTest.assertNull((Object)p.getMapKey());
        JavaXPropertyTest.assertTrue((boolean)p.isArray());
        JavaXPropertyTest.assertFalse((boolean)p.isCollection());
    }

    public void testCanBeACollection() {
        List declaredProperties = this.dadAsSeenFromSon.getDeclaredProperties("property");
        XProperty p = this.getPropertyNamed_from("collectionProperty", declaredProperties);
        JavaXPropertyTest.assertTrue((boolean)this.factory.equals(p.getType(), Map.class));
        JavaXPropertyTest.assertTrue((boolean)this.factory.equals(p.getElementClass(), String.class));
        JavaXPropertyTest.assertTrue((boolean)this.factory.equals(p.getClassOrElementClass(), Map.class));
        JavaXPropertyTest.assertTrue((boolean)this.factory.equals(p.getMapKey(), Double.class));
        JavaXPropertyTest.assertEquals(Map.class, (Object)p.getCollectionClass());
        JavaXPropertyTest.assertFalse((boolean)p.isArray());
        JavaXPropertyTest.assertTrue((boolean)p.isCollection());
    }

    private XProperty getPropertyNamed_from(String name, List<XProperty> properties) {
        for (XProperty p : properties) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        throw new AssertionFailedError("No property '" + name + "' found");
    }

    public void testSupportsMethodsStartingWithIs() throws Exception {
        JavaXPropertyTest.assertEquals((String)"methodProperty", (String)this.getConcreteInstance().getName());
    }

    protected XProperty getConcreteInstance() {
        XClass xClass = this.factory.toXClass(Dad.class);
        List properties = xClass.getDeclaredProperties("property");
        for (XProperty p : properties) {
            if (!p.getName().equals("methodProperty")) continue;
            return p;
        }
        throw new AssertionFailedError("Cannot find Foo.getMethodProperty()");
    }
}

