/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.lockmanager;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.bootstrap.BootstrapTestUtils;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.subsystem.lockmanager.LockManager;
import org.testng.Assert;

public class LockManagerTest
extends CcsTestCaseTemplate {
    private static Map<String, Map<String, String>> maxLevelConfig;
    private static LockManager lockMan;

    @BeforeClass
    public static void setupClass() throws InterruptedException, TimeoutException {
        maxLevelConfig = new HashMap<String, Map<String, String>>();
        HashMap<String, String> userMap = new HashMap<String, String>();
        userMap.put("a1 ", " 10");
        userMap.put(" b* ", " 66 ");
        userMap.put("b1 ", " ENGINEERING_ADVANCED ");
        userMap.put("b2 ", "MAX");
        userMap.put("*b3*", " NORMAL ");
        maxLevelConfig.put("user0", userMap);
        userMap = new HashMap();
        userMap.put("a1", " 2");
        userMap.put(" group0 ", "  ");
        userMap.put("a3 ", " 3 ");
        maxLevelConfig.put("user1", userMap);
        userMap = new HashMap();
        userMap.put("group1", "");
        maxLevelConfig.put("user2", userMap);
        userMap = new HashMap();
        userMap.put("group1", "");
        userMap.put("b2", "2");
        userMap.put("group2", "");
        maxLevelConfig.put("user3", userMap);
        userMap = new HashMap();
        userMap.put("group3", "");
        userMap.put("a* ", "5");
        userMap.put(" a3", "2");
        userMap.put("b*", "10 ");
        maxLevelConfig.put("user4", userMap);
        userMap = new HashMap();
        userMap.put("* ", " 1");
        maxLevelConfig.put("@group0", userMap);
        userMap = new HashMap();
        userMap.put("a*", "2");
        userMap.put("group0", "");
        userMap.put("b1", "3");
        userMap.put("group2", " ");
        maxLevelConfig.put("@group1", userMap);
        userMap = new HashMap();
        userMap.put("b2", "3");
        userMap.put("group1", "");
        maxLevelConfig.put("@group2", userMap);
        userMap = new HashMap();
        userMap.put(" a*", " 6");
        userMap.put("a3 ", "3");
        userMap.put("*b", "16");
        userMap.put("c* ", "3");
        userMap.put(" group4", " ");
        maxLevelConfig.put("@group3", userMap);
        userMap = new HashMap();
        userMap.put(" c* ", " 10 ");
        userMap.put("c4", "20");
        userMap.put("b2", "30");
        maxLevelConfig.put("@group4", userMap);
        maxLevelConfig = LockManager.normalizeLevelsConfig(maxLevelConfig);
        BootstrapTestUtils.setDefaultProperty((String)"org.lsst.ccs.lockservice.enforceLevel", (String)"STRICT");
        System.out.println("Starting Lock Manager.");
        lockMan = new LockManager();
        lockMan.startAgent();
        ((AgentStateService)lockMan.getAgentService(AgentStateService.class)).waitForStatePredicate(state -> state.isInState((Enum)PhaseState.OPERATIONAL), 120L, TimeUnit.SECONDS);
        ((ConfigurationService)lockMan.getAgentService(ConfigurationService.class)).change("/", "maxLevelMap", maxLevelConfig);
        System.out.println(lockMan.printMaxLevels("", false));
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        maxLevelConfig = null;
        System.out.println("Shutting down Lock Manager.");
        lockMan.shutdownAgent();
        BootstrapTestUtils.setDefaultProperty((String)"org.lsst.ccs.lockservice.enforceLevel", (String)"OFF");
        Thread.sleep(1000L);
    }

    @Before
    public void setupTest() {
        LockManagerTest.resetConfig();
    }

    @After
    public void tearDownTest() throws Exception {
    }

    @Test
    public void testPrintMaxLevels() {
        Assert.assertEquals((String)lockMan.printMaxLevels("", false), (String)String.join((CharSequence)System.lineSeparator(), "Groups:", "  group0 : [*:1]", "  group1 : [group0:, group2:, a*:2, b1:3]", "  group2 : [group1:, b2:3]", "  group3 : [group4:, *b:16, a*:6, a3:3, c*:3]", "  group4 : [b2:30, c*:10, c4:20]", "Users:", "  user0 : [*b3*:NORMAL, a1:10, b*:66, b1:ENGINEERING_ADVANCED, b2:MAX]", "  user1 : [group0:, a1:2, a3:3]", "  user2 : [group1:]", "  user3 : [group1:, group2:, b2:2]", "  user4 : [group3:, a*:5, a3:2, b*:10]", ""));
        Assert.assertEquals((String)lockMan.printMaxLevels("", true), (String)String.join((CharSequence)System.lineSeparator(), "@group0 : [* : 1]", "@group1 : [* : 1, a* : 2, b1 : 3, b2 : 3]", "@group2 : [* : 1, a* : 2, b1 : 3, b2 : 3]", "@group3 : [*b : 16, a* : 6, a3 : 3, b2 : 30, c* : 3]", "@group4 : [b2 : 30, c* : 10, c4 : 20]", "user0 : [*b3* : 0, a1 : 10, b* : 66, b1 : 2, b2 : 99]", "user1 : [* : 1, a1 : 2, a3 : 3]", "user2 : [* : 1, a* : 2, b1 : 3, b2 : 3]", "user3 : [* : 1, a* : 2, b1 : 3, b2 : 2]", "user4 : [*b : 16, a* : 5, a3 : 2, b* : 10, c* : 3]"));
        Assert.assertEquals((String)lockMan.printMaxLevels("group1", false), (String)String.join((CharSequence)", ", "group0:", "group2:", "a*:2", "b1:3"));
        Assert.assertEquals((String)lockMan.printMaxLevels("user0 ", true), (String)String.join((CharSequence)System.lineSeparator(), "*b3* : 0", "a1 : 10", "b* : 66", "b1 : 2", "b2 : 99"));
    }

    @Test
    public void testSetUser() {
        Assert.assertEquals((String)lockMan.setUser("user4", " "), (String)"Removed user user4.");
        Assert.assertEquals((String)lockMan.maxLevel("user4", "b2"), (String)"0");
        Assert.assertEquals((String)lockMan.group("group3"), (String)".");
        lockMan.setUser("user4", " [a1 : 2, group3:, * : 1, a3 : 3]");
        String s = "group3:, *:1, a1:2, a3:3";
        Assert.assertEquals((String)lockMan.printMaxLevels("user4", false), (String)s);
        lockMan.setUser("user4", "group3 : ,  a1 : 2, *: 1, a3:3 ");
        Assert.assertEquals((String)lockMan.printMaxLevels(" user4 ", false), (String)s);
    }

    @Test
    public void testSetGroup() {
        lockMan.setGroup(" group0", "");
        Assert.assertEquals((String)lockMan.maxLevel("user1", "x"), (String)"0", (String)"maxLevel(user1,x)");
        lockMan.setGroup(" group0", "*:2");
        Assert.assertEquals((String)lockMan.maxLevel("user1", "x"), (String)"2", (String)"maxLevel(user1,x)");
    }

    @Test
    public void testSetMaxLevel() {
        try {
            lockMan.setMaxLevel("x", "a1", "10");
            Assert.fail();
        }
        catch (IllegalArgumentException x) {
            Assert.assertEquals((String)x.getMessage(), (String)"No such user or group: x");
        }
        lockMan.setMaxLevel("user1", "a1", "5");
        Assert.assertEquals((String)lockMan.printMaxLevels("user1", false), (String)"group0:, a1:5, a3:3");
        lockMan.setMaxLevel("user1", "a2", "2");
        Assert.assertEquals((String)lockMan.printMaxLevels("user1", false), (String)"group0:, a1:5, a2:2, a3:3");
    }

    @Test
    public void testGroups() {
        String s = lockMan.groups();
        Assert.assertEquals((String)lockMan.groups(), (String)String.join((CharSequence)System.lineSeparator(), "group0 : [*:1]", "group1 : [group0:, group2:, a*:2, b1:3]", "group2 : [group1:, b2:3]", "group3 : [group4:, *b:16, a*:6, a3:3, c*:3]", "group4 : [b2:30, c*:10, c4:20]", ""));
    }

    @Test
    public void testGroup() {
        try {
            lockMan.group("x");
            Assert.fail((String)"Failed to detect non-existent group.");
        }
        catch (IllegalArgumentException x) {
            Assert.assertEquals((String)x.getMessage(), (String)"No such group: x", (String)"Detecting non-existent group");
        }
        Assert.assertEquals((String)lockMan.group(" group0 "), (String)"user1, user2, user3.", (String)"Testing group(0)");
        Assert.assertEquals((String)lockMan.group("group1 "), (String)"user2, user3.", (String)"Testing group(1)");
        Assert.assertEquals((String)lockMan.group("group2"), (String)"user2, user3.", (String)"Testing group(2)");
        Assert.assertEquals((String)lockMan.group("group3"), (String)"user4.", (String)"Testing group(3)");
        Assert.assertEquals((String)lockMan.group("group4"), (String)"user4.", (String)"Testing group(4)");
    }

    @Test
    public void testMaxLevel() {
        Assert.assertEquals((String)lockMan.maxLevel("user0", "a1"), (String)"10", (String)"maxLevel(user0,a1)");
        Assert.assertEquals((String)lockMan.maxLevel("user0", "b0"), (String)"66", (String)"maxLevel(user0,b0)");
        Assert.assertEquals((String)lockMan.maxLevel("user0", "b1"), (String)"2", (String)"maxLevel(user0,b1)");
        Assert.assertEquals((String)lockMan.maxLevel("user0", "b2"), (String)"99", (String)"maxLevel(user0,b2)");
        Assert.assertEquals((String)lockMan.maxLevel("user0", "ab3"), (String)"0", (String)"maxLevel(user0,ab3)");
        Assert.assertEquals((String)lockMan.maxLevel("user0", "b3"), (String)"66", (String)"maxLevel(user0,b3)");
        Assert.assertEquals((String)lockMan.maxLevel("user0", "x"), (String)"0", (String)"maxLevel(user0,x)");
        Assert.assertEquals((String)lockMan.maxLevel("user1", "a1"), (String)"2", (String)"maxLevel(user1,a1)");
        Assert.assertEquals((String)lockMan.maxLevel("user1", "a3"), (String)"3", (String)"maxLevel(user1,a3)");
        Assert.assertEquals((String)lockMan.maxLevel("user1", "x"), (String)"1", (String)"maxLevel(user1,x)");
        Assert.assertEquals((String)lockMan.maxLevel("user2", "x"), (String)"1", (String)"maxLevel(user2,x)");
        Assert.assertEquals((String)lockMan.maxLevel("user2", "a1"), (String)"2", (String)"maxLevel(user2,a1)");
        Assert.assertEquals((String)lockMan.maxLevel("user2", "b1"), (String)"3", (String)"maxLevel(user2,b1)");
        Assert.assertEquals((String)lockMan.maxLevel("user2", "b2"), (String)"3", (String)"maxLevel(user2,b2)");
        Assert.assertEquals((String)lockMan.maxLevel("user3", "x"), (String)"1", (String)"maxLevel(user2,x)");
        Assert.assertEquals((String)lockMan.maxLevel("user3", "b2"), (String)"2", (String)"maxLevel(user2,b2)");
        Assert.assertEquals((String)lockMan.maxLevel("@group1", "a"), (String)"2", (String)"maxLevel(@group1,a)");
        Assert.assertEquals((String)lockMan.maxLevel("user4", "a0"), (String)"5", (String)"maxLevel(user4,a0)");
        Assert.assertEquals((String)lockMan.maxLevel("user4", "a3"), (String)"2", (String)"maxLevel(user4,a3)");
        Assert.assertEquals((String)lockMan.maxLevel("user4", "b2"), (String)"10", (String)"maxLevel(user4,b2)");
        Assert.assertEquals((String)lockMan.maxLevel("user4", "a0"), (String)"5", (String)"maxLevel(user4,a0)");
        Assert.assertEquals((String)lockMan.maxLevel("user4", "cb"), (String)"16", (String)"maxLevel(user4,cb)");
        Assert.assertEquals((String)lockMan.maxLevel("user4", "ca"), (String)"3", (String)"maxLevel(user4,ca)");
        Assert.assertEquals((String)lockMan.maxLevel("user4", "c4"), (String)"3", (String)"maxLevel(user4,c4)");
    }

    private static void resetConfig() {
        ((ConfigurationService)lockMan.getAgentService(ConfigurationService.class)).change("/", "maxLevelMap", maxLevelConfig);
    }
}

