/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Properties;
import java.util.Set;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.config.WriterProvider;
import org.lsst.ccs.utilities.logging.Logger;

class FileWriterProvider
extends WriterProvider {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.config");

    FileWriterProvider() {
    }

    @Override
    public PrintWriter getPrintWriter(String fileName) throws IOException {
        String tmpFileName = fileName;
        String pathInBootstrap = BootstrapResourceUtils.getPathOfPropertiesFileInUserResourceDirectories((String)fileName);
        if (pathInBootstrap == null) {
            String topMostUserDirectory = BootstrapResourceUtils.getTopUserResourceDirectory();
            if (topMostUserDirectory == null) {
                throw new RuntimeException("There is no external resource directory in which to write the file. Please make sure to define one using environment variable CCS_RESOURCE_PATH.");
            }
            fileName = topMostUserDirectory + fileName;
        } else {
            fileName = pathInBootstrap;
        }
        log.info((Object)("Saving " + tmpFileName + " to " + fileName));
        return new PrintWriter(fileName, "ISO-8859-1");
    }

    @Override
    public Properties getProperties(String fileName) throws IOException {
        Properties configProps = new Properties();
        InputStream propsIs = null;
        propsIs = BootstrapResourceUtils.getBootstrapResource((String)fileName);
        if (propsIs == null) {
            return null;
        }
        String path = BootstrapResourceUtils.getPathOfPropertiesFileInUserResourceDirectories((String)fileName);
        log.info((Object)("Found configuration file : " + path));
        configProps.load(propsIs);
        return configProps;
    }

    @Override
    Set<String> findMatchingPropertiesFiles(String pattern) {
        return BootstrapResourceUtils.findMatchingResources((String)pattern);
    }

    @Override
    String locateFile(String fileName) {
        return BootstrapResourceUtils.getPathOfPropertiesFileInUserResourceDirectories((String)fileName);
    }
}

