/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.lockmanager;

import java.io.Serializable;
import java.time.Instant;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.lsst.ccs.Agent;
import org.lsst.ccs.PersistencyService;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.AgentLockInfo;
import org.lsst.ccs.bus.messages.StatusLock;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.Persist;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.services.AgentLockService;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class LockManager
extends Subsystem
implements HasLifecycle {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.subsystem.lockmanager");
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    AgentLockService agentLockService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    AgentStateService agentStateService;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    private AgentMessagingLayer aml;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private PersistencyService localPersistenceService;
    @Persist
    ConcurrentHashMap<String, AgentLockInfoString> locks = new ConcurrentHashMap();
    ConcurrentHashMap<String, CountDownLatch> latches = new ConcurrentHashMap();
    StatusMessageListener sml = new StatusMessageListener(){

        public void onStatusMessage(StatusMessage msg) {
            Serializable o = msg.getObject();
            if (!(o instanceof AgentLockInfo)) {
                return;
            }
            AgentLockInfo lock = (AgentLockInfo)o;
            log.finest((Object)msg);
            CountDownLatch latch = LockManager.this.latches.get(lock.getAgentName());
            if (latch == null) {
                return;
            }
            if (lock.getStatus() != AgentLockInfo.Status.ACKNOWLEDGED && lock.getStatus() != AgentLockInfo.Status.REJECTED) {
                return;
            }
            if (lock.getStatus() == AgentLockInfo.Status.REJECTED) {
                log.warning((Object)("Rejected lock " + lock));
                LockManager.this.latches.remove(lock.getAgentName());
                LockManager.this.locks.remove(lock.getAgentName());
                latch.countDown();
                return;
            }
            if (!LockManager.this.locks.containsKey(lock.getAgentName()) && LockManager.this.locks.get(lock.getAgentName()).getMyInfo().getStatus() != AgentLockInfo.Status.REQUESTED) {
                log.error((Object)("Inconsistent state, received " + lock + " with latch " + latch + " and request " + LockManager.this.locks.get(lock.getAgentName())));
                LockManager.this.latches.remove(lock.getAgentName());
                LockManager.this.locks.remove(lock.getAgentName());
                latch.countDown();
                return;
            }
            log.debug((Object)"received acknowledged lock");
            LockManager.this.locks.put(lock.getAgentName(), new AgentLockInfoString(lock));
            LockManager.this.localPersistenceService.persistNow();
            latch.countDown();
        }
    };

    public LockManager(String name) {
        super(name, AgentInfo.AgentType.LOCK_MANAGER);
    }

    public LockManager() {
        super("lockmanager", AgentInfo.AgentType.LOCK_MANAGER);
    }

    public void init() {
        boolean loadAtStartup = true;
        boolean persistAtShutdown = true;
        this.localPersistenceService.setAutomatic(loadAtStartup, persistAtShutdown);
    }

    public void postInit() {
    }

    public void postStart() {
        this.aml = this.agent.getMessagingAccess();
        this.aml.addStatusMessageListener(this.sml, BusMessageFilterFactory.embeddedObjectClass(AgentLockInfo.class));
    }

    @Command(type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM, description="locks a subsystem", level=0)
    public AgentLockInfo lockAgent(@Argument(name="lock", description="Lock request") AgentLockInfo lock) {
        log.debug((Object)("got lock command for " + lock.getAgentName() + " from " + lock.getOwnerName()));
        AgentLockInfo lockInfo = this.getLockInfo(lock.getAgentName());
        log.debug((Object)("current lock " + lockInfo));
        if (lockInfo != null && !lock.getOwnerName().equals(lockInfo.getOwnerName())) {
            throw new RuntimeException("lock owned by another user/agent: " + lockInfo.getOwnerName());
        }
        AgentLockInfoString old = this.locks.putIfAbsent(lock.getAgentName(), new AgentLockInfoString(lock));
        if (old != null) {
            return null;
        }
        CountDownLatch latch = new CountDownLatch(1);
        this.latches.put(lock.getAgentName(), latch);
        StatusLock msg = new StatusLock(lock);
        msg.setState(this.agentStateService.getState());
        this.aml.sendStatusMessage((StatusMessage)msg);
        log.debug((Object)"sent message, waiting");
        try {
            latch.await(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        AgentLockInfo updatedLock = this.getLockInfo(lock.getAgentName());
        log.debug((Object)("got lock ack " + updatedLock));
        assert (updatedLock == null || updatedLock.getStatus() == AgentLockInfo.Status.ACKNOWLEDGED);
        this.latches.remove(lock.getAgentName());
        return updatedLock;
    }

    @Command(type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM, description="unlocks a subsystem", level=0)
    public void unlockAgent(@Argument(name="lock", description="Unlock request") AgentLockInfo lock) {
        log.debug((Object)("got unlock command for " + lock.getAgentName() + " from " + lock.getOwnerName()));
        AgentLockInfo lockInfo = this.getLockInfo(lock.getAgentName());
        if (lockInfo == null) {
            throw new RuntimeException("no existing lock");
        }
        if (!lockInfo.getOwnerName().equals(lock.getOwnerName())) {
            throw new RuntimeException("lock owned by another user/agent: " + lockInfo.getOwnerName());
        }
        this.locks.remove(lock.getAgentName());
        StatusLock msg = new StatusLock(lock);
        msg.setState(this.agentStateService.getState());
        this.aml.sendStatusMessage((StatusMessage)msg);
    }

    @Command(type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM, description="updates lock level", level=0)
    public void updateLevel(@Argument(name="lock", description="lock info") AgentLockInfo lock, @Argument(name="level", description="new level") int level) {
        log.debug((Object)"got updateLevel command");
        AgentLockInfo lockInfo = this.getLockInfo(lock.getAgentName());
        if (!lockInfo.getOwnerName().equals(lock.getOwnerName())) {
            throw new RuntimeException("lock owned by another user/agent: " + lockInfo.getOwnerName());
        }
        StatusLock msg = new StatusLock(lock, level);
        msg.setState(this.agentStateService.getState());
        this.aml.sendStatusMessage((StatusMessage)msg);
    }

    private AgentLockInfo getLockInfo(String agentName) {
        AgentLockInfoString lockInfoString = this.locks.get(agentName);
        return lockInfoString == null ? null : lockInfoString.getMyInfo();
    }

    public static class AgentLockInfoString {
        private AgentLockInfo myInfo;
        static String delimiter = ";";

        public AgentLockInfoString(AgentLockInfo info) {
            this.myInfo = info;
        }

        public AgentLockInfoString(String stringArgs) {
            String[] args = stringArgs.split(delimiter);
            String agentName = args[0];
            String ownerAgent = args[1];
            String userId = args[2];
            int maxLevel = Integer.parseInt(args[3]);
            AgentLockInfo.Status status = AgentLockInfo.Status.valueOf((String)args[4]);
            CCSTimeStamp timeStamp = CCSTimeStamp.currentTimeFromMillis((long)Instant.parse(args[5]).toEpochMilli());
            this.myInfo = new AgentLockInfo(agentName, ownerAgent, userId, maxLevel, status, timeStamp);
        }

        public AgentLockInfo getMyInfo() {
            return this.myInfo;
        }

        public String toString() {
            StringJoiner lockInfo = new StringJoiner(delimiter);
            lockInfo.add(this.myInfo.getAgentName());
            lockInfo.add(this.myInfo.getOwnerAgentName());
            lockInfo.add(this.myInfo.getUserID());
            lockInfo.add(String.valueOf(this.myInfo.getMaxLevel()));
            lockInfo.add(this.myInfo.getStatus().name());
            lockInfo.add(this.myInfo.getTimeStamp().getUTCInstant().toString());
            return lockInfo.toString();
        }
    }
}

