/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.services.aggregator;

import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lsst.ccs.gconsole.services.aggregator.ChannelSelector;
import org.lsst.ccs.gconsole.util.MatchPredicate;

final class PathPattern
implements ChannelSelector {
    static final Pattern pAgent = Pattern.compile("([\\w\\-]+)/.*");
    private final String agent;
    private final Predicate<String> pattern;

    PathPattern(String rawTemplate) {
        if (rawTemplate.startsWith("/")) {
            rawTemplate = "[\\w\\-]+" + rawTemplate;
            this.agent = null;
        } else {
            Matcher m = pAgent.matcher(rawTemplate);
            String string = this.agent = m.matches() ? m.group(1) : null;
        }
        if (rawTemplate.endsWith("/")) {
            rawTemplate = rawTemplate + ".+";
        }
        this.pattern = new MatchPredicate(rawTemplate);
    }

    @Override
    public String getAgent() {
        return this.agent;
    }

    @Override
    public boolean match(String originPath) {
        return this.pattern.test(originPath);
    }
}

