/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.propertysheet;

import com.l2fprod.common.propertysheet.Property;
import com.l2fprod.common.propertysheet.PropertyDescriptorAdapter;
import com.l2fprod.common.propertysheet.PropertyEditorFactory;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.util.HashMap;
import java.util.Map;

public class PropertyEditorRegistry
implements PropertyEditorFactory {
    private Map typeToEditor = new HashMap();
    private Map propertyToEditor = new HashMap();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$l2fprod$common$beans$editor$StringPropertyEditor;
    static /* synthetic */ Class class$com$l2fprod$common$beans$editor$DoublePropertyEditor;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$com$l2fprod$common$beans$editor$FloatPropertyEditor;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$com$l2fprod$common$beans$editor$IntegerPropertyEditor;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$com$l2fprod$common$beans$editor$LongPropertyEditor;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$com$l2fprod$common$beans$editor$ShortPropertyEditor;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$com$l2fprod$common$beans$editor$BooleanAsCheckBoxPropertyEditor;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$com$l2fprod$common$beans$editor$FilePropertyEditor;
    static /* synthetic */ Class class$java$awt$Color;
    static /* synthetic */ Class class$com$l2fprod$common$beans$editor$ColorPropertyEditor;
    static /* synthetic */ Class class$java$awt$Dimension;
    static /* synthetic */ Class class$com$l2fprod$common$beans$editor$DimensionPropertyEditor;
    static /* synthetic */ Class class$java$awt$Insets;
    static /* synthetic */ Class class$com$l2fprod$common$beans$editor$InsetsPropertyEditor;
    static /* synthetic */ Class class$java$awt$Font;
    static /* synthetic */ Class class$java$awt$Rectangle;
    static /* synthetic */ Class class$com$l2fprod$common$beans$editor$RectanglePropertyEditor;
    static /* synthetic */ Class class$java$util$Date;

    public PropertyEditorRegistry() {
        this.registerDefaults();
    }

    public PropertyEditor createPropertyEditor(Property property) {
        return this.getEditor(property);
    }

    public synchronized PropertyEditor getEditor(Property property) {
        Class<?> clz;
        PropertyDescriptor descriptor;
        PropertyEditor editor = null;
        if (property instanceof PropertyDescriptorAdapter && (descriptor = ((PropertyDescriptorAdapter)property).getDescriptor()) != null && (clz = descriptor.getPropertyEditorClass()) != null) {
            editor = this.loadPropertyEditor(clz);
        }
        if (editor == null) {
            Object value = this.propertyToEditor.get(property);
            editor = value instanceof PropertyEditor ? (PropertyEditor)value : (value instanceof Class ? this.loadPropertyEditor((Class)value) : this.getEditor(property.getType()));
        }
        if (editor == null && property instanceof PropertyDescriptorAdapter) {
            descriptor = ((PropertyDescriptorAdapter)property).getDescriptor();
            clz = descriptor.getPropertyType();
            editor = PropertyEditorManager.findEditor(clz);
        }
        return editor;
    }

    private PropertyEditor loadPropertyEditor(Class clz) {
        PropertyEditor editor = null;
        try {
            editor = (PropertyEditor)clz.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return editor;
    }

    public synchronized PropertyEditor getEditor(Class type) {
        PropertyEditor editor = null;
        Object value = this.typeToEditor.get(type);
        if (value instanceof PropertyEditor) {
            editor = (PropertyEditor)value;
        } else if (value instanceof Class) {
            try {
                editor = (PropertyEditor)((Class)value).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return editor;
    }

    public synchronized void registerEditor(Class type, Class editorClass) {
        this.typeToEditor.put(type, editorClass);
    }

    public synchronized void registerEditor(Class type, PropertyEditor editor) {
        this.typeToEditor.put(type, editor);
    }

    public synchronized void unregisterEditor(Class type) {
        this.typeToEditor.remove(type);
    }

    public synchronized void registerEditor(Property property, Class editorClass) {
        this.propertyToEditor.put(property, editorClass);
    }

    public synchronized void registerEditor(Property property, PropertyEditor editor) {
        this.propertyToEditor.put(property, editor);
    }

    public synchronized void unregisterEditor(Property property) {
        this.propertyToEditor.remove(property);
    }

    public void registerDefaults() {
        this.typeToEditor.clear();
        this.propertyToEditor.clear();
        this.registerEditor(class$java$lang$String == null ? (class$java$lang$String = PropertyEditorRegistry.class$("java.lang.String")) : class$java$lang$String, class$com$l2fprod$common$beans$editor$StringPropertyEditor == null ? (class$com$l2fprod$common$beans$editor$StringPropertyEditor = PropertyEditorRegistry.class$("com.l2fprod.common.beans.editor.StringPropertyEditor")) : class$com$l2fprod$common$beans$editor$StringPropertyEditor);
        this.registerEditor(Double.TYPE, class$com$l2fprod$common$beans$editor$DoublePropertyEditor == null ? (class$com$l2fprod$common$beans$editor$DoublePropertyEditor = PropertyEditorRegistry.class$("com.l2fprod.common.beans.editor.DoublePropertyEditor")) : class$com$l2fprod$common$beans$editor$DoublePropertyEditor);
        this.registerEditor(class$java$lang$Double == null ? (class$java$lang$Double = PropertyEditorRegistry.class$("java.lang.Double")) : class$java$lang$Double, class$com$l2fprod$common$beans$editor$DoublePropertyEditor == null ? (class$com$l2fprod$common$beans$editor$DoublePropertyEditor = PropertyEditorRegistry.class$("com.l2fprod.common.beans.editor.DoublePropertyEditor")) : class$com$l2fprod$common$beans$editor$DoublePropertyEditor);
        this.registerEditor(Float.TYPE, class$com$l2fprod$common$beans$editor$FloatPropertyEditor == null ? (class$com$l2fprod$common$beans$editor$FloatPropertyEditor = PropertyEditorRegistry.class$("com.l2fprod.common.beans.editor.FloatPropertyEditor")) : class$com$l2fprod$common$beans$editor$FloatPropertyEditor);
        this.registerEditor(class$java$lang$Float == null ? (class$java$lang$Float = PropertyEditorRegistry.class$("java.lang.Float")) : class$java$lang$Float, class$com$l2fprod$common$beans$editor$FloatPropertyEditor == null ? (class$com$l2fprod$common$beans$editor$FloatPropertyEditor = PropertyEditorRegistry.class$("com.l2fprod.common.beans.editor.FloatPropertyEditor")) : class$com$l2fprod$common$beans$editor$FloatPropertyEditor);
        this.registerEditor(Integer.TYPE, class$com$l2fprod$common$beans$editor$IntegerPropertyEditor == null ? (class$com$l2fprod$common$beans$editor$IntegerPropertyEditor = PropertyEditorRegistry.class$("com.l2fprod.common.beans.editor.IntegerPropertyEditor")) : class$com$l2fprod$common$beans$editor$IntegerPropertyEditor);
        this.registerEditor(class$java$lang$Integer == null ? (class$java$lang$Integer = PropertyEditorRegistry.class$("java.lang.Integer")) : class$java$lang$Integer, class$com$l2fprod$common$beans$editor$IntegerPropertyEditor == null ? (class$com$l2fprod$common$beans$editor$IntegerPropertyEditor = PropertyEditorRegistry.class$("com.l2fprod.common.beans.editor.IntegerPropertyEditor")) : class$com$l2fprod$common$beans$editor$IntegerPropertyEditor);
        this.registerEditor(Long.TYPE, class$com$l2fprod$common$beans$editor$LongPropertyEditor == null ? (class$com$l2fprod$common$beans$editor$LongPropertyEditor = PropertyEditorRegistry.class$("com.l2fprod.common.beans.editor.LongPropertyEditor")) : class$com$l2fprod$common$beans$editor$LongPropertyEditor);
        this.registerEditor(class$java$lang$Long == null ? (class$java$lang$Long = PropertyEditorRegistry.class$("java.lang.Long")) : class$java$lang$Long, class$com$l2fprod$common$beans$editor$LongPropertyEditor == null ? (class$com$l2fprod$common$beans$editor$LongPropertyEditor = PropertyEditorRegistry.class$("com.l2fprod.common.beans.editor.LongPropertyEditor")) : class$com$l2fprod$common$beans$editor$LongPropertyEditor);
        this.registerEditor(Short.TYPE, class$com$l2fprod$common$beans$editor$ShortPropertyEditor == null ? (class$com$l2fprod$common$beans$editor$ShortPropertyEditor = PropertyEditorRegistry.class$("com.l2fprod.common.beans.editor.ShortPropertyEditor")) : class$com$l2fprod$common$beans$editor$ShortPropertyEditor);
        this.registerEditor(class$java$lang$Short == null ? (class$java$lang$Short = PropertyEditorRegistry.class$("java.lang.Short")) : class$java$lang$Short, class$com$l2fprod$common$beans$editor$ShortPropertyEditor == null ? (class$com$l2fprod$common$beans$editor$ShortPropertyEditor = PropertyEditorRegistry.class$("com.l2fprod.common.beans.editor.ShortPropertyEditor")) : class$com$l2fprod$common$beans$editor$ShortPropertyEditor);
        this.registerEditor(Boolean.TYPE, class$com$l2fprod$common$beans$editor$BooleanAsCheckBoxPropertyEditor == null ? (class$com$l2fprod$common$beans$editor$BooleanAsCheckBoxPropertyEditor = PropertyEditorRegistry.class$("com.l2fprod.common.beans.editor.BooleanAsCheckBoxPropertyEditor")) : class$com$l2fprod$common$beans$editor$BooleanAsCheckBoxPropertyEditor);
        this.registerEditor(class$java$lang$Boolean == null ? (class$java$lang$Boolean = PropertyEditorRegistry.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$com$l2fprod$common$beans$editor$BooleanAsCheckBoxPropertyEditor == null ? (class$com$l2fprod$common$beans$editor$BooleanAsCheckBoxPropertyEditor = PropertyEditorRegistry.class$("com.l2fprod.common.beans.editor.BooleanAsCheckBoxPropertyEditor")) : class$com$l2fprod$common$beans$editor$BooleanAsCheckBoxPropertyEditor);
        this.registerEditor(class$java$io$File == null ? (class$java$io$File = PropertyEditorRegistry.class$("java.io.File")) : class$java$io$File, class$com$l2fprod$common$beans$editor$FilePropertyEditor == null ? (class$com$l2fprod$common$beans$editor$FilePropertyEditor = PropertyEditorRegistry.class$("com.l2fprod.common.beans.editor.FilePropertyEditor")) : class$com$l2fprod$common$beans$editor$FilePropertyEditor);
        this.registerEditor(class$java$awt$Color == null ? (class$java$awt$Color = PropertyEditorRegistry.class$("java.awt.Color")) : class$java$awt$Color, class$com$l2fprod$common$beans$editor$ColorPropertyEditor == null ? (class$com$l2fprod$common$beans$editor$ColorPropertyEditor = PropertyEditorRegistry.class$("com.l2fprod.common.beans.editor.ColorPropertyEditor")) : class$com$l2fprod$common$beans$editor$ColorPropertyEditor);
        this.registerEditor(class$java$awt$Dimension == null ? (class$java$awt$Dimension = PropertyEditorRegistry.class$("java.awt.Dimension")) : class$java$awt$Dimension, class$com$l2fprod$common$beans$editor$DimensionPropertyEditor == null ? (class$com$l2fprod$common$beans$editor$DimensionPropertyEditor = PropertyEditorRegistry.class$("com.l2fprod.common.beans.editor.DimensionPropertyEditor")) : class$com$l2fprod$common$beans$editor$DimensionPropertyEditor);
        this.registerEditor(class$java$awt$Insets == null ? (class$java$awt$Insets = PropertyEditorRegistry.class$("java.awt.Insets")) : class$java$awt$Insets, class$com$l2fprod$common$beans$editor$InsetsPropertyEditor == null ? (class$com$l2fprod$common$beans$editor$InsetsPropertyEditor = PropertyEditorRegistry.class$("com.l2fprod.common.beans.editor.InsetsPropertyEditor")) : class$com$l2fprod$common$beans$editor$InsetsPropertyEditor);
        try {
            Class<?> fontEditor = Class.forName("com.l2fprod.common.beans.editor.FontPropertyEditor");
            this.registerEditor(class$java$awt$Font == null ? (class$java$awt$Font = PropertyEditorRegistry.class$("java.awt.Font")) : class$java$awt$Font, fontEditor);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.registerEditor(class$java$awt$Rectangle == null ? (class$java$awt$Rectangle = PropertyEditorRegistry.class$("java.awt.Rectangle")) : class$java$awt$Rectangle, class$com$l2fprod$common$beans$editor$RectanglePropertyEditor == null ? (class$com$l2fprod$common$beans$editor$RectanglePropertyEditor = PropertyEditorRegistry.class$("com.l2fprod.common.beans.editor.RectanglePropertyEditor")) : class$com$l2fprod$common$beans$editor$RectanglePropertyEditor);
        boolean foundDateEditor = false;
        try {
            Class.forName("com.toedter.calendar.JDateChooser");
            this.registerEditor(class$java$util$Date == null ? (class$java$util$Date = PropertyEditorRegistry.class$("java.util.Date")) : class$java$util$Date, Class.forName("com.l2fprod.common.beans.editor.JCalendarDatePropertyEditor"));
            foundDateEditor = true;
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (!foundDateEditor) {
            try {
                Class.forName("net.sf.nachocalendar.components.DateField");
                this.registerEditor(class$java$util$Date == null ? (class$java$util$Date = PropertyEditorRegistry.class$("java.util.Date")) : class$java$util$Date, Class.forName("com.l2fprod.common.beans.editor.NachoCalendarDatePropertyEditor"));
                foundDateEditor = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

