/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.integrationgantrygui;

import java.io.IOException;
import java.time.Duration;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.integrationgantrygui.Main;
import org.lsst.ccs.services.AgentPeriodicTaskService;

public class IGGUISubsystem
extends Subsystem
implements HasLifecycle {
    private static final Logger LOG = Logger.getLogger(IGGUISubsystem.class.getName());
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem subsys;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService pts;
    private final Main main = new Main();
    private final long[] lastUpdateTime = new long[4];

    public IGGUISubsystem() {
        super("ig-gui", AgentInfo.AgentType.WORKER);
    }

    public void postStart() {
        try {
            this.main.start(false);
        }
        catch (IOException ex) {
            throw new RuntimeException("Error calling start", ex);
        }
    }

    public void build() {
        this.pts.scheduleAgentPeriodicTask(new AgentPeriodicTask("publish-trending", () -> {
            for (int i = 0; i < 4; ++i) {
                KeyValueData data = this.main.getTrendingForCamera(i);
                if (data == null || data.getCCSTimeStamp().getUTCInstant().toEpochMilli() <= this.lastUpdateTime[i]) continue;
                this.subsys.publishSubsystemDataOnStatusBus(data);
                this.lastUpdateTime[i] = data.getCCSTimeStamp().getUTCInstant().toEpochMilli();
            }
        }).withPeriod(Duration.ofSeconds(15L)));
    }
}

