/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.integrationgantrygui;

import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.integrationgantrygui.ScalableImageProvider;
import org.lsst.ccs.integrationgantrygui.ScalingUtils;

public class ScalingUtilsTest {
    private int[] counts = new int[]{0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0, 0, 0};

    @Test
    public void linearByteTest() {
        ScalingUtils.ByteScalingUtils utils = new ScalingUtils.ByteScalingUtils(this.counts);
        Assert.assertEquals((long)3L, (long)utils.getMin());
        Assert.assertEquals((long)21L, (long)utils.getMax());
        byte[] buildArray = utils.buildArray(0, ScalableImageProvider.Scaling.LINEAR);
        Assert.assertEquals((double)128.0, (double)this.mean(buildArray, utils.getMin(), utils.getMax()), (double)1.0);
        buildArray = utils.buildArray(0, ScalableImageProvider.Scaling.LOG);
        Assert.assertEquals((double)179.0, (double)this.mean(buildArray, utils.getMin(), utils.getMax()), (double)1.0);
        buildArray = utils.buildArray(0, ScalableImageProvider.Scaling.HIST);
        Assert.assertEquals((double)132.6, (double)this.mean(buildArray, utils.getMin(), utils.getMax()), (double)1.0);
    }

    @Test
    public void linearShortTest() {
        ScalingUtils.ShortScalingUtils utils = new ScalingUtils.ShortScalingUtils(this.counts);
        Assert.assertEquals((long)3L, (long)utils.getMin());
        Assert.assertEquals((long)21L, (long)utils.getMax());
        short[] buildArray = utils.buildArray(0, ScalableImageProvider.Scaling.LINEAR);
        Assert.assertEquals((double)32768.0, (double)this.mean(buildArray, utils.getMin(), utils.getMax()), (double)1.0);
        buildArray = utils.buildArray(0, ScalableImageProvider.Scaling.LOG);
        Assert.assertEquals((double)46083.0, (double)this.mean(buildArray, utils.getMin(), utils.getMax()), (double)256.0);
        buildArray = utils.buildArray(0, ScalableImageProvider.Scaling.HIST);
        Assert.assertEquals((double)33945.6, (double)this.mean(buildArray, utils.getMin(), utils.getMax()), (double)256.0);
    }

    double mean(byte[] array, int first, int last) {
        double sum = 0.0;
        int n = 0;
        for (int i = first; i <= last; ++i) {
            sum += (double)(array[i] & 0xFF);
            ++n;
        }
        return sum / (double)n;
    }

    double mean(short[] array, int first, int last) {
        double sum = 0.0;
        int n = 0;
        for (int i = first; i <= last; ++i) {
            sum += (double)(array[i] & 0xFFFF);
            ++n;
        }
        return sum / (double)n;
    }
}

