package org.lsst.ccs.integrationgantrygui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;

/**
 *
 * @author tonyj
 */
public class IntegrationGantryFrame extends javax.swing.JFrame {

    private static final long serialVersionUID = 1L;
    private static final int ICON_SIZE = 24;

    private final CameraPanel[] cameraPanels;
    private final ScalableImageProvider[] imageProvider;
    private ScalableImageProvider.Scaling scaling = ScalableImageProvider.Scaling.LOG;
    private final JLabel[] axes;

    private enum GridSize {
        ONE_CM("1cm", 400), FIVE_MM("5mm", 200), TWO_MM("2mm", 80), ONE_MM("1mm", 40);
        private final int size;
        private final String text;

        GridSize(String name, int size) {
            this.text = name;
            this.size = size;
        }

        public int getSize() {
            return size;
        }

        @Override
        public String toString() {
            return text;
        }

    }
    private GridSize gridSize = GridSize.ONE_CM;

    /**
     * Creates new form IntegrationGantryFrame
     */
    public IntegrationGantryFrame() {
        initComponents();
        displayComboBox.setModel(new DefaultComboBoxModel(ScalableImageProvider.Scaling.values()));
        ButtonGroup scaleGroup = new ButtonGroup();
        for (ScalableImageProvider.Scaling scale : ScalableImageProvider.Scaling.values()) {
            final JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(scale.toString(), scale == scaling);
            scaleGroup.add(menuItem);
            imageScalingMenu.add(menuItem);
            menuItem.addActionListener((evt) -> setScaling(scale));
        }
        displayComboBox.setSelectedItem(scaling);

        gridSizeComboBox.setModel(new DefaultComboBoxModel(GridSize.values()));
        ButtonGroup gridSizeGroup = new ButtonGroup();
        for (GridSize gs : GridSize.values()) {
            final JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(gs.toString(), gs == gridSize);
            gridSizeGroup.add(menuItem);
            gridSizeMenu.add(menuItem);
            menuItem.addActionListener((evt) -> setGridSize(gs));
        }
        gridSizeComboBox.setSelectedItem(gridSize);

        cameraPanels = new CameraPanel[]{cameraPanel1, cameraPanel2, cameraPanel3, cameraPanel4};
        axes = new JLabel[]{topCoordinateLabel, bottomCoordinateLabel, rightCoordinateLabel, leftCoordinateLabel};
        imageProvider = new ScalableImageProvider[4];
    }

    void setImage(int i, ScalableImageProvider image) {
        imageProvider[i] = image;
        cameraPanels[i].setImage(image.createScaledImage(scaling));
    }

    void setLabel(int i, double h1, double h2, double v1, double v2) {
        cameraPanels[i].setLabels(h1, h2, v1, v2);
    }

    void setFPS(int fps) {
        SwingUtilities.invokeLater(() -> {
            fpsTextBox.setText(String.valueOf(fps));
            fpsTextBox.setForeground(fps < 1 ? Color.RED : fpsTextBox.getParent().getForeground());
        });
    }

    void setROI(boolean horizontal, int index, List<Number> roi) {
        cameraPanels[index].setROI(horizontal, roi);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        javax.swing.JPanel jPanel6 = new javax.swing.JPanel();
        displayComboBox = new javax.swing.JComboBox<>();
        fpsTextBox = new javax.swing.JTextField();
        javax.swing.JLabel jLabel5 = new javax.swing.JLabel();
        javax.swing.JLabel jLabel6 = new javax.swing.JLabel();
        zoomCheckBox = new javax.swing.JCheckBox();
        showEdgesCheckBox = new javax.swing.JCheckBox();
        showGridCheckBox = new javax.swing.JCheckBox();
        jLabel1 = new javax.swing.JLabel();
        gridSizeComboBox = new javax.swing.JComboBox<>();
        coordinatePanel = new javax.swing.JPanel();
        imagePanel = new javax.swing.JPanel();
        cameraPanel1 = new org.lsst.ccs.integrationgantrygui.CameraPanel();
        cameraPanel2 = new org.lsst.ccs.integrationgantrygui.CameraPanel();
        cameraPanel3 = new org.lsst.ccs.integrationgantrygui.CameraPanel();
        cameraPanel4 = new org.lsst.ccs.integrationgantrygui.CameraPanel();
        topCoordinateLabel = new javax.swing.JLabel();
        bottomCoordinateLabel = new javax.swing.JLabel();
        rightCoordinateLabel = new javax.swing.JLabel();
        leftCoordinateLabel = new javax.swing.JLabel();
        jMenuBar1 = new javax.swing.JMenuBar();
        fileMenu = new javax.swing.JMenu();
        exitMenuItem = new javax.swing.JMenuItem();
        viewMenu = new javax.swing.JMenu();
        viewCoordinatesMenuItem = new javax.swing.JCheckBoxMenuItem();
        showROIMenuItem = new javax.swing.JCheckBoxMenuItem();
        zoomToROIMenuItem = new javax.swing.JCheckBoxMenuItem();
        showEdgesMenuItem = new javax.swing.JCheckBoxMenuItem();
        showGridMenuItem = new javax.swing.JCheckBoxMenuItem();
        presevereAspectRatioMenuItem = new javax.swing.JCheckBoxMenuItem();
        imageScalingMenu = new javax.swing.JMenu();
        gridSizeMenu = new javax.swing.JMenu();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("Integration Gantry Cameras");

        displayComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                displayComboBoxActionPerformed(evt);
            }
        });

        fpsTextBox.setEditable(false);
        fpsTextBox.setColumns(3);
        fpsTextBox.setText("100");

        jLabel5.setText("Frames Per Second:");

        jLabel6.setText("Image scaling:");

        zoomCheckBox.setText("Zoom to ROI");
        zoomCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                zoomCheckBoxActionPerformed(evt);
            }
        });

        showEdgesCheckBox.setSelected(true);
        showEdgesCheckBox.setText("Show Edges");
        showEdgesCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                showEdgesCheckBoxActionPerformed(evt);
            }
        });

        showGridCheckBox.setModel(showGridMenuItem.getModel());
        showGridCheckBox.setText("Show Grid");

        jLabel1.setText("Grid Size:");

        gridSizeComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                gridSizeComboBoxActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel6Layout = new javax.swing.GroupLayout(jPanel6);
        jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(
            jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel6Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel6)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(displayComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addComponent(zoomCheckBox)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(showEdgesCheckBox)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(showGridCheckBox)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(gridSizeComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 586, Short.MAX_VALUE)
                .addComponent(jLabel5)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(fpsTextBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        );
        jPanel6Layout.setVerticalGroup(
            jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel6Layout.createSequentialGroup()
                .addGroup(jPanel6Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(displayComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(fpsTextBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel5)
                    .addComponent(jLabel6)
                    .addComponent(zoomCheckBox)
                    .addComponent(showEdgesCheckBox)
                    .addComponent(showGridCheckBox)
                    .addComponent(jLabel1)
                    .addComponent(gridSizeComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(0, 0, Short.MAX_VALUE))
        );

        getContentPane().add(jPanel6, java.awt.BorderLayout.SOUTH);

        coordinatePanel.setLayout(new java.awt.BorderLayout());

        imagePanel.setLayout(new java.awt.GridLayout(2, 2));

        cameraPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder("Camera 1"));
        cameraPanel1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                cameraPanel1MouseClicked(evt);
            }
        });
        imagePanel.add(cameraPanel1);

        cameraPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder("Camera 2"));
        cameraPanel2.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                cameraPanel2MouseClicked(evt);
            }
        });
        imagePanel.add(cameraPanel2);

        cameraPanel3.setBorder(javax.swing.BorderFactory.createTitledBorder("Camera 3"));
        cameraPanel3.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                cameraPanel3MouseClicked(evt);
            }
        });
        imagePanel.add(cameraPanel3);

        cameraPanel4.setBorder(javax.swing.BorderFactory.createTitledBorder("Camera 4"));
        cameraPanel4.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                cameraPanel4MouseClicked(evt);
            }
        });
        imagePanel.add(cameraPanel4);

        coordinatePanel.add(imagePanel, java.awt.BorderLayout.CENTER);

        topCoordinateLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        topCoordinateLabel.setIcon(new org.lsst.ccs.integrationgantrygui.icon.ArrowUp(ICON_SIZE,ICON_SIZE));
        topCoordinateLabel.setText("+X West");
        coordinatePanel.add(topCoordinateLabel, java.awt.BorderLayout.NORTH);

        bottomCoordinateLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        bottomCoordinateLabel.setIcon(new org.lsst.ccs.integrationgantrygui.icon.ArrowDown(ICON_SIZE,ICON_SIZE));
        bottomCoordinateLabel.setText("-X East");
        coordinatePanel.add(bottomCoordinateLabel, java.awt.BorderLayout.PAGE_END);

        rightCoordinateLabel.setIcon(new org.lsst.ccs.integrationgantrygui.icon.ArrowRight(ICON_SIZE,ICON_SIZE));
        rightCoordinateLabel.setText("<HTML><center><br>+Y<br> <br>S<br>o<br>u<br>t<br>h<br></center>");
        rightCoordinateLabel.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        rightCoordinateLabel.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        coordinatePanel.add(rightCoordinateLabel, java.awt.BorderLayout.LINE_END);

        leftCoordinateLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        leftCoordinateLabel.setIcon(new org.lsst.ccs.integrationgantrygui.icon.ArrowLeft(ICON_SIZE,ICON_SIZE));
        leftCoordinateLabel.setText("<HTML><center><br>-Y<br> <br>N<br>o<br>r<br>t<br>h<br></center>");
        leftCoordinateLabel.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        leftCoordinateLabel.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        coordinatePanel.add(leftCoordinateLabel, java.awt.BorderLayout.LINE_START);

        getContentPane().add(coordinatePanel, java.awt.BorderLayout.CENTER);

        fileMenu.setText("File");

        exitMenuItem.setText("Exit");
        exitMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                exitMenuItemActionPerformed(evt);
            }
        });
        fileMenu.add(exitMenuItem);

        jMenuBar1.add(fileMenu);

        viewMenu.setText("View");

        viewCoordinatesMenuItem.setSelected(true);
        viewCoordinatesMenuItem.setText("Show Coordinate Axes");
        viewCoordinatesMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                viewCoordinatesMenuItemActionPerformed(evt);
            }
        });
        viewMenu.add(viewCoordinatesMenuItem);

        showROIMenuItem.setSelected(true);
        showROIMenuItem.setText("Show ROIs");
        showROIMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                showROIMenuItemActionPerformed(evt);
            }
        });
        viewMenu.add(showROIMenuItem);

        zoomToROIMenuItem.setSelected(true);
        zoomToROIMenuItem.setText("Zoom to ROI");
        zoomToROIMenuItem.setModel(zoomCheckBox.getModel());
        viewMenu.add(zoomToROIMenuItem);

        showEdgesMenuItem.setSelected(true);
        showEdgesMenuItem.setText("Show Edges");
        showEdgesMenuItem.setModel(showEdgesCheckBox.getModel()
        );
        viewMenu.add(showEdgesMenuItem);

        showGridMenuItem.setSelected(true);
        showGridMenuItem.setText("Show Grid");
        showGridMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                showGridMenuItemActionPerformed(evt);
            }
        });
        viewMenu.add(showGridMenuItem);

        presevereAspectRatioMenuItem.setSelected(true);
        presevereAspectRatioMenuItem.setText("Preserve Aspect Ratio");
        presevereAspectRatioMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                presevereAspectRatioMenuItemActionPerformed(evt);
            }
        });
        viewMenu.add(presevereAspectRatioMenuItem);

        imageScalingMenu.setText("Image Scaling");
        viewMenu.add(imageScalingMenu);

        gridSizeMenu.setText("Grid Size");
        viewMenu.add(gridSizeMenu);

        jMenuBar1.add(viewMenu);

        setJMenuBar(jMenuBar1);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void displayComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_displayComboBoxActionPerformed
        ScalableImageProvider.Scaling newScaling = displayComboBox.getItemAt(displayComboBox.getSelectedIndex());
        setScaling(newScaling);
    }//GEN-LAST:event_displayComboBoxActionPerformed

    private void setScaling(ScalableImageProvider.Scaling newScaling) {
        if (newScaling != scaling) {
            this.scaling = newScaling;
            displayComboBox.setSelectedItem(newScaling);
            for (Component c : imageScalingMenu.getMenuComponents()) {
                if (c instanceof JMenuItem && ((JMenuItem) c).getText().equals(scaling.toString())) {
                    ((JMenuItem) c).setSelected(true);
                }
            }

            for (int i = 0; i < 4; i++) {
                if (cameraPanels != null) {
                    cameraPanels[i].setImage(imageProvider[i].createScaledImage(newScaling));
                }
            }
        }
    }

    private void setGridSize(GridSize gs) {
        if (gs != gridSize) {
            this.gridSize = gs;
            gridSizeComboBox.setSelectedItem(gs);
            for (Component c : gridSizeMenu.getMenuComponents()) {
                if (c instanceof JMenuItem && ((JMenuItem) c).getText().equals(gs.toString())) {
                    ((JMenuItem) c).setSelected(true);
                }
            }

            for (CameraPanel panel : cameraPanels) {
                panel.setGridSize(gs.getSize());
            }
        }

    }

    private void exitMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_exitMenuItemActionPerformed
        System.exit(0);
    }//GEN-LAST:event_exitMenuItemActionPerformed

    private void viewCoordinatesMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_viewCoordinatesMenuItemActionPerformed
        for (JLabel label : axes) {
            label.setVisible(viewCoordinatesMenuItem.isSelected());
        }
        validate();
        repaint();
    }//GEN-LAST:event_viewCoordinatesMenuItemActionPerformed

    private void showROIMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_showROIMenuItemActionPerformed
        for (CameraPanel panel : cameraPanels) {
            panel.setShowROI(showROIMenuItem.isSelected());
        }
    }//GEN-LAST:event_showROIMenuItemActionPerformed

    private void cameraPanel1MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_cameraPanel1MouseClicked
        cameraPanelMouseClicked(evt, 0);
    }//GEN-LAST:event_cameraPanel1MouseClicked

    private void cameraPanel2MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_cameraPanel2MouseClicked
        cameraPanelMouseClicked(evt, 1);
    }//GEN-LAST:event_cameraPanel2MouseClicked

    private void cameraPanel3MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_cameraPanel3MouseClicked
        cameraPanelMouseClicked(evt, 2);
    }//GEN-LAST:event_cameraPanel3MouseClicked

    private void cameraPanel4MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_cameraPanel4MouseClicked
        cameraPanelMouseClicked(evt, 3);
    }//GEN-LAST:event_cameraPanel4MouseClicked

    private void zoomCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_zoomCheckBoxActionPerformed
        for (CameraPanel panel : cameraPanels) {
            panel.setZoomToROI(zoomCheckBox.isSelected());
        }
    }//GEN-LAST:event_zoomCheckBoxActionPerformed

    private void showEdgesCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_showEdgesCheckBoxActionPerformed
        for (CameraPanel panel : cameraPanels) {
            panel.setShowEdges(showEdgesCheckBox.isSelected());
        }
    }//GEN-LAST:event_showEdgesCheckBoxActionPerformed

    private void showGridMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_showGridMenuItemActionPerformed
        for (CameraPanel panel : cameraPanels) {
            panel.setShowGrid(showGridMenuItem.isSelected());
        }
    }//GEN-LAST:event_showGridMenuItemActionPerformed

    private void presevereAspectRatioMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_presevereAspectRatioMenuItemActionPerformed
        for (CameraPanel panel : cameraPanels) {
            panel.setPreserveAspectRatio(presevereAspectRatioMenuItem.isSelected());
        }
    }//GEN-LAST:event_presevereAspectRatioMenuItemActionPerformed

    private void gridSizeComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_gridSizeComboBoxActionPerformed
        GridSize newSize = gridSizeComboBox.getItemAt(gridSizeComboBox.getSelectedIndex());
        setGridSize(newSize);
    }//GEN-LAST:event_gridSizeComboBoxActionPerformed

    private void cameraPanelMouseClicked(java.awt.event.MouseEvent evt, int position) {
        if (evt.getClickCount() == 2) {
            Component clickedPanel = evt.getComponent();
            if (clickedPanel.getParent() == coordinatePanel) {
                coordinatePanel.remove(clickedPanel);
                coordinatePanel.add(imagePanel, BorderLayout.CENTER);
                imagePanel.add(clickedPanel, position);
            } else {
                imagePanel.remove(clickedPanel);
                coordinatePanel.remove(imagePanel);
                coordinatePanel.add(clickedPanel, BorderLayout.CENTER);
            }
            coordinatePanel.validate();
            this.repaint();
        }
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException | InstantiationException | IllegalAccessException | javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(IntegrationGantryFrame.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>

        /* Create and display the form */
        java.awt.EventQueue.invokeLater(() -> {
            new IntegrationGantryFrame().setVisible(true);
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel bottomCoordinateLabel;
    private org.lsst.ccs.integrationgantrygui.CameraPanel cameraPanel1;
    private org.lsst.ccs.integrationgantrygui.CameraPanel cameraPanel2;
    private org.lsst.ccs.integrationgantrygui.CameraPanel cameraPanel3;
    private org.lsst.ccs.integrationgantrygui.CameraPanel cameraPanel4;
    private javax.swing.JPanel coordinatePanel;
    private javax.swing.JComboBox<ScalableImageProvider.Scaling> displayComboBox;
    private javax.swing.JMenuItem exitMenuItem;
    private javax.swing.JMenu fileMenu;
    private javax.swing.JTextField fpsTextBox;
    private javax.swing.JComboBox<GridSize> gridSizeComboBox;
    private javax.swing.JMenu gridSizeMenu;
    private javax.swing.JPanel imagePanel;
    private javax.swing.JMenu imageScalingMenu;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JMenuBar jMenuBar1;
    private javax.swing.JLabel leftCoordinateLabel;
    private javax.swing.JCheckBoxMenuItem presevereAspectRatioMenuItem;
    private javax.swing.JLabel rightCoordinateLabel;
    private javax.swing.JCheckBox showEdgesCheckBox;
    private javax.swing.JCheckBoxMenuItem showEdgesMenuItem;
    private javax.swing.JCheckBox showGridCheckBox;
    private javax.swing.JCheckBoxMenuItem showGridMenuItem;
    private javax.swing.JCheckBoxMenuItem showROIMenuItem;
    private javax.swing.JLabel topCoordinateLabel;
    private javax.swing.JCheckBoxMenuItem viewCoordinatesMenuItem;
    private javax.swing.JMenu viewMenu;
    private javax.swing.JCheckBox zoomCheckBox;
    private javax.swing.JCheckBoxMenuItem zoomToROIMenuItem;
    // End of variables declaration//GEN-END:variables

}
