/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.integrationgantrygui;

import java.awt.EventQueue;
import java.io.IOException;
import java.io.Serializable;
import java.nio.BufferUnderflowException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.script.ScriptException;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.integrationgantrygui.FitsFast;
import org.lsst.ccs.integrationgantrygui.IntegrationGantryFrame;
import org.lsst.ccs.integrationgantrygui.JSONParser;
import org.lsst.ccs.integrationgantrygui.ScalableImageProvider;
import org.lsst.ccs.integrationgantrygui.Timed;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class Main {
    private static final Logger LOG = Logger.getLogger(Main.class.getName());
    static final int NCAMERAS = 4;
    private final Path watchDir = Paths.get(System.getProperty("watchDir", "/mnt/ramdisk"), new String[0]);
    private final Pattern watchPattern = Pattern.compile(System.getProperty("watchPattern", "[a-z|A-Z|_]+(\\d)_rng\\d+.*"));
    private final Pattern textPattern = Pattern.compile("((horiz)?\\s*((\\d|\\.)*)?\\s*((\\d|\\.)*)?.*)\\s+\\|\\s+((vert)?\\s*((\\d|\\.)*)?\\s*((\\d|\\.)*)?.*)");
    private final Map<Integer, Integer> cameraMap = new HashMap<Integer, Integer>();
    private int totalFiles = 0;
    private int processFiles = 0;
    private final AtomicInteger count = new AtomicInteger();
    private JSONParser parser;
    private IntegrationGantryFrame frame;
    private LinkedBlockingQueue[] queues;
    private final Map<Integer, KeyValueDataList> trendingMap = new ConcurrentHashMap<Integer, KeyValueDataList>();
    private List<Number>[][] rois = new List[2][4];

    Main() {
        this.cameraMap.put(0, 2);
        this.cameraMap.put(1, 3);
        this.cameraMap.put(2, 0);
        this.cameraMap.put(3, 1);
    }

    void start(boolean startGUI) throws IOException {
        Path fullPath;
        int i;
        ExecutorService workQueue = Executors.newCachedThreadPool();
        if (startGUI) {
            this.frame = new IntegrationGantryFrame();
            EventQueue.invokeLater(() -> this.frame.setVisible(true));
            this.queues = new LinkedBlockingQueue[4];
            for (int i2 = 0; i2 < this.queues.length; ++i2) {
                LinkedBlockingQueue queue = new LinkedBlockingQueue(1);
                int index = i2;
                this.queues[i2] = queue;
                Runnable runnable = () -> {
                    while (true) {
                        try {
                            while (true) {
                                Path path = (Path)queue.take();
                                Timed.execute(() -> {
                                    ScalableImageProvider image = FitsFast.readFits(path.toFile());
                                    this.frame.setImage(index, image);
                                    this.count.getAndIncrement();
                                    return null;
                                }, "Processing image took %dms", new Object[0]);
                            }
                        }
                        catch (InterruptedException | BufferUnderflowException ex) {
                            LOG.log(Level.SEVERE, "Exception in animation thread", ex);
                            continue;
                        }
                        break;
                    }
                };
                workQueue.execute(runnable);
            }
            Runnable runnable = () -> {
                while (true) {
                    try {
                        while (true) {
                            this.frame.setFPS(this.count.getAndSet(0));
                            Thread.sleep(1000L);
                        }
                    }
                    catch (InterruptedException ex) {
                        LOG.log(Level.SEVERE, "Exception in timer thread", ex);
                        continue;
                    }
                    break;
                }
            };
            workQueue.execute(runnable);
        }
        this.parser = new JSONParser();
        Stream<Path> pathList = Files.list(this.watchDir);
        Path[] fitsFiles = new Path[4];
        Path[] textFiles = new Path[4];
        Path[] jsonFiles = new Path[2];
        pathList.forEach(path -> {
            Path fullPath = this.watchDir.resolve((Path)path);
            String fileName = fullPath.getFileName().toString();
            Matcher matcher = this.watchPattern.matcher(fileName);
            if (matcher.matches()) {
                int index = Integer.parseInt(matcher.group(1));
                int mappedIndex = this.cameraMap.get(index);
                if (fileName.endsWith(".fits")) {
                    if (fitsFiles[mappedIndex] == null || fullPath.toFile().lastModified() > fitsFiles[mappedIndex].toFile().lastModified()) {
                        fitsFiles[mappedIndex] = fullPath;
                    }
                } else if (fileName.endsWith(".txt") && (textFiles[mappedIndex] == null || fullPath.toFile().lastModified() > textFiles[mappedIndex].toFile().lastModified())) {
                    textFiles[mappedIndex] = fullPath;
                }
            } else if (fileName.endsWith(".json")) {
                int mappedIndex;
                boolean isHorizontal = fileName.contains("horiz");
                int n = mappedIndex = isHorizontal ? 0 : 1;
                if (jsonFiles[mappedIndex] == null || fullPath.toFile().lastModified() > jsonFiles[mappedIndex].toFile().lastModified()) {
                    jsonFiles[mappedIndex] = fullPath;
                }
            }
        });
        if (startGUI) {
            for (i = 0; i < 4; ++i) {
                fullPath = fitsFiles[i];
                if (fullPath == null) continue;
                this.handleFitsFile(fullPath, i);
            }
        }
        for (i = 0; i < 2; ++i) {
            fullPath = jsonFiles[i];
            if (fullPath == null) continue;
            this.handleJSONFile(fullPath.getFileName().toString(), fullPath);
        }
        for (i = 0; i < 4; ++i) {
            fullPath = textFiles[i];
            if (fullPath == null) continue;
            this.handleTextFile(fullPath, i);
        }
        Runnable fileWatcher = () -> {
            try {
                WatchService watchService = this.watchDir.getFileSystem().newWatchService();
                try {
                    this.watchDir.register(watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY);
                    while (true) {
                        WatchKey take = watchService.take();
                        take.pollEvents().stream().map(event -> (Path)event.context()).forEach(path -> {
                            Path fullPath = this.watchDir.resolve((Path)path);
                            String fileName = fullPath.getFileName().toString();
                            Matcher matcher = this.watchPattern.matcher(fileName);
                            if (matcher.matches()) {
                                int index = Integer.parseInt(matcher.group(1));
                                int mappedIndex = this.cameraMap.get(index);
                                if (fileName.endsWith(".fits") && startGUI) {
                                    this.handleFitsFile(fullPath, mappedIndex);
                                } else if (fileName.endsWith(".txt")) {
                                    this.handleTextFile(fullPath, mappedIndex);
                                }
                            } else if (fileName.endsWith(".json")) {
                                this.handleJSONFile(fileName, fullPath);
                            }
                        });
                        take.reset();
                    }
                }
                catch (Throwable throwable) {
                    if (watchService != null) {
                        try {
                            watchService.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            catch (IOException | InterruptedException x) {
                throw new RuntimeException("Error in watch loop", x);
            }
        };
        workQueue.submit(fileWatcher);
    }

    private void handleFitsFile(Path fullPath, int index) {
        if (fullPath.toFile().length() == 5071680L || fullPath.toFile().length() == 10137600L) {
            LinkedBlockingQueue queue = this.queues[index];
            Path poll = (Path)queue.poll();
            if (poll == null) {
                ++this.processFiles;
            }
            queue.add(fullPath);
            ++this.totalFiles;
            if (this.totalFiles % 100 == 0) {
                LOG.log(Level.FINE, "{0}% of files were processed\n", this.processFiles);
                this.processFiles = 0;
            }
        }
    }

    private void handleTextFile(Path fullPath, int index) {
        try {
            Matcher matcher;
            FileTime lastModifiedTime = Files.getLastModifiedTime(fullPath, new LinkOption[0]);
            List<String> text = Files.readAllLines(fullPath);
            if (!text.isEmpty() && (matcher = this.textPattern.matcher(text.get(0))).matches()) {
                int findex = index;
                double h1 = this.parseDouble(matcher.group(3));
                double h2 = this.parseDouble(matcher.group(5));
                double v1 = this.parseDouble(matcher.group(9));
                double v2 = this.parseDouble(matcher.group(11));
                this.storeTrendingData(index, lastModifiedTime, h1, h2, v1, v2);
                if (this.frame != null) {
                    SwingUtilities.invokeLater(() -> this.frame.setLabel(findex, h1, h2, v1, v2));
                }
            }
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, "Error reading text file", ex);
        }
    }

    private void handleJSONFile(String fileName, Path fullPath) {
        boolean isHorizontal = fileName.contains("horiz");
        try {
            Map<String, List<Number>> rois = this.parser.parseROI(Files.readAllLines(fullPath));
            rois.forEach((t, u) -> {
                int index = Integer.parseInt(t);
                int mappedIndex = this.cameraMap.get(index);
                this.storeROI(isHorizontal, index, (List<Number>)u);
                if (this.frame != null) {
                    SwingUtilities.invokeLater(() -> this.frame.setROI(isHorizontal, mappedIndex, (List<Number>)u));
                }
            });
        }
        catch (IOException | ScriptException ex) {
            LOG.log(Level.SEVERE, "Error reading json file", ex);
        }
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        Main main = new Main();
        main.start(true);
    }

    private double parseDouble(String string) {
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException x) {
            return Double.NaN;
        }
    }

    private void storeROI(boolean isHorizontal, int index, List<Number> roi) {
        LOG.log(Level.FINE, "Setting {0} roi index {1} to {2}", new Object[]{isHorizontal, index, roi});
        this.rois[isHorizontal ? 0 : 1][index] = roi;
    }

    private void storeTrendingData(int index, FileTime lastModifiedTime, double h1, double h2, double v1, double v2) {
        LOG.log(Level.FINE, "storeTrendingData index {0} date {1} to {2},{3},{4},{5}", new Object[]{index, lastModifiedTime, h1, h2, v1, v2});
        KeyValueDataList dl = new KeyValueDataList(CCSTimeStamp.currentTimeFromMillis((long)lastModifiedTime.toMillis()));
        List<Number> horizontalROI = this.rois[0][index];
        List<Number> verticalROI = this.rois[1][index];
        if (horizontalROI != null && verticalROI != null) {
            String prefix = "Camera" + (index + 1) + "/";
            dl.addData(prefix + "h1", (Serializable)Double.valueOf(h1 + horizontalROI.get(1).doubleValue()));
            dl.addData(prefix + "h2", (Serializable)Double.valueOf(h2 + horizontalROI.get(1).doubleValue()));
            dl.addData(prefix + "hGap", (Serializable)Double.valueOf(25.0 * (h2 - h1)));
            dl.addData(prefix + "v1", (Serializable)Double.valueOf(v1 + verticalROI.get(0).doubleValue()));
            dl.addData(prefix + "v2", (Serializable)Double.valueOf(v2 + verticalROI.get(0).doubleValue()));
            dl.addData(prefix + "vGap", (Serializable)Double.valueOf(25.0 * (v2 - v1)));
            this.trendingMap.put(index, dl);
        }
    }

    KeyValueData getTrendingForCamera(int index) {
        return (KeyValueData)this.trendingMap.get(index);
    }
}

