/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.integrationgantrygui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.lsst.ccs.integrationgantrygui.Timed;

public class ImageComponent
extends JComponent {
    private static final long serialVersionUID = 1L;
    private BufferedImage originalImage;
    private Rectangle2D.Double horizontalROI;
    private Rectangle2D.Double verticalROI;
    private boolean showROI = true;
    private boolean zoomToROI = false;
    private Color verticalColor = new Color(1.0f, 0.0f, 0.0f, 0.5f);
    private Color horizontalColor = new Color(1.0f, 0.0f, 0.0f, 0.5f);
    private Color edgeColor = Color.RED;
    private boolean preserveAspectRatio = true;
    private boolean showGrid = true;
    private final Color gridColor = Color.BLACK;
    private final Stroke gridStroke = new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{10.0f, 20.0f}, 0.0f);
    private int gridSize = 400;
    private VolatileImage volatileImage;
    private Rectangle2D.Double zoomRegion;
    private boolean showEdges = true;
    private double hEdge1;
    private double hEdge2;
    private double vEdge1;
    private double vEdge2;

    public ImageComponent() {
        this.originalImage = null;
        this.setPreferredSize(new Dimension(300, 300));
    }

    ImageComponent(BufferedImage image) {
        this.setImage(image);
    }

    final void setImage(BufferedImage image) {
        VolatileImage newImage = this.createVolatileImage(this.getWidth(), this.getHeight());
        this.renderOffscreen(image, newImage);
        SwingUtilities.invokeLater(() -> {
            this.originalImage = image;
            this.volatileImage = newImage;
            this.repaint();
        });
    }

    BufferedImage getImage() {
        return this.originalImage;
    }

    public void setShowROI(boolean showROI) {
        this.showROI = showROI;
        this.renderOffscreen();
        this.repaint();
    }

    void setShowEdges(boolean show) {
        this.showEdges = show;
        this.renderOffscreen();
        this.repaint();
    }

    void setEdges(double hEdge1, double hEdge2, double vEdge1, double vEdge2) {
        this.hEdge1 = hEdge1;
        this.hEdge2 = hEdge2;
        this.vEdge1 = vEdge1;
        this.vEdge2 = vEdge2;
    }

    void setROI(boolean horizontal, List<Number> roi) {
        Rectangle2D.Double rect = new Rectangle2D.Double(roi.get(0).doubleValue(), roi.get(1).doubleValue(), roi.get(2).doubleValue() - roi.get(0).doubleValue(), roi.get(3).doubleValue() - roi.get(1).doubleValue());
        if (horizontal) {
            this.horizontalROI = rect;
        } else {
            this.verticalROI = rect;
        }
        Rectangle2D.Double zoom = null;
        if (this.horizontalROI != null && this.verticalROI != null) {
            zoom = new Rectangle2D.Double();
            Rectangle2D.union(this.horizontalROI, this.verticalROI, zoom);
        } else if (this.horizontalROI != null) {
            zoom = this.horizontalROI;
        } else if (this.verticalROI != null) {
            zoom = this.verticalROI;
        }
        if (zoom != null) {
            Point2D.Double border = new Point2D.Double(0.1 * zoom.width, 0.1 * zoom.height);
            this.zoomRegion = new Rectangle2D.Double(zoom.x - border.x, zoom.y - border.y, zoom.width + 2.0 * border.x, zoom.height + 2.0 * border.y);
        } else {
            this.zoomRegion = null;
        }
        this.renderOffscreen();
        this.repaint();
    }

    void renderOffscreen() {
        if (this.volatileImage == null || this.volatileImage.validate(this.getGraphicsConfiguration()) == 2) {
            this.volatileImage = this.createVolatileImage(this.getWidth(), this.getHeight());
        }
        this.renderOffscreen(this.originalImage, this.volatileImage);
    }

    void renderOffscreen(BufferedImage sourceImage, VolatileImage destinationImage) {
        if (sourceImage != null && destinationImage != null) {
            Graphics2D g2 = destinationImage.createGraphics();
            if (this.preserveAspectRatio) {
                g2.setColor(this.getBackground());
                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            if (this.zoomToROI && this.zoomRegion != null) {
                hScale = (double)this.getWidth() / this.zoomRegion.getWidth();
                vScale = (double)this.getHeight() / this.zoomRegion.getHeight();
                if (this.preserveAspectRatio) {
                    vScale = hScale = Math.min(hScale, vScale);
                }
                g2.scale(hScale, -vScale);
                g2.translate(-this.zoomRegion.x, -this.zoomRegion.y);
                g2.translate(0.0, -this.zoomRegion.getHeight());
            } else {
                hScale = (double)this.getWidth() / (double)sourceImage.getWidth();
                vScale = (double)this.getHeight() / (double)sourceImage.getHeight();
                if (this.preserveAspectRatio) {
                    vScale = hScale = Math.min(hScale, vScale);
                }
                g2.scale(hScale, -vScale);
                g2.translate(0, -sourceImage.getHeight());
            }
            Timed.execute(() -> g2.drawImage((Image)sourceImage, 0, 0, null), "Offscreen paint image of type %d and size %dx%d took %dms", sourceImage.getType(), sourceImage.getWidth(), sourceImage.getHeight());
            if (this.showROI) {
                Line2D.Double line2;
                if (this.horizontalROI != null) {
                    g2.setColor(this.horizontalColor);
                    g2.fill(this.horizontalROI);
                    if (this.showEdges) {
                        g2.setColor(this.edgeColor);
                        Line2D.Double line1 = new Line2D.Double(this.horizontalROI.x, this.horizontalROI.y + this.hEdge1, this.horizontalROI.x + this.horizontalROI.width, this.horizontalROI.y + this.hEdge1);
                        g2.draw(line1);
                        line2 = new Line2D.Double(this.horizontalROI.x, this.horizontalROI.y + this.hEdge2, this.horizontalROI.x + this.horizontalROI.width, this.horizontalROI.y + this.hEdge2);
                        g2.draw(line2);
                    }
                }
                if (this.verticalROI != null) {
                    g2.setColor(this.verticalColor);
                    g2.fill(this.verticalROI);
                    if (this.showEdges) {
                        g2.setColor(this.edgeColor);
                        Line2D.Double line1 = new Line2D.Double(this.verticalROI.x + this.vEdge1, this.verticalROI.y, this.verticalROI.x + this.vEdge1, this.verticalROI.y + this.verticalROI.height);
                        g2.draw(line1);
                        line2 = new Line2D.Double(this.verticalROI.x + this.vEdge2, this.verticalROI.y, this.verticalROI.x + this.vEdge2, this.verticalROI.y + this.verticalROI.height);
                        g2.draw(line2);
                    }
                }
            }
            if (this.showGrid) {
                Path2D.Double grid = new Path2D.Double();
                for (double x = 0.0; x < (double)sourceImage.getWidth(); x += (double)this.gridSize) {
                    grid.moveTo(x, 0.0);
                    grid.lineTo(x, sourceImage.getHeight());
                }
                for (double y = 0.0; y < (double)sourceImage.getHeight(); y += (double)this.gridSize) {
                    grid.moveTo(0.0, y);
                    grid.lineTo(sourceImage.getWidth(), y);
                }
                g2.setColor(this.gridColor);
                g2.setXORMode(this.getBackground());
                g2.setStroke(this.gridStroke);
                g2.draw(grid);
            }
            g2.dispose();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        do {
            int returnCode;
            if ((returnCode = this.volatileImage == null ? 2 : (this.volatileImage.getWidth() != this.getWidth() || this.volatileImage.getHeight() != this.getHeight() ? 2 : this.volatileImage.validate(this.getGraphicsConfiguration()))) == 1) {
                this.renderOffscreen();
            } else if (returnCode == 2) {
                this.volatileImage = this.createVolatileImage(this.getWidth(), this.getHeight());
                this.renderOffscreen();
            }
            Timed.execute(() -> g.drawImage(this.volatileImage, 0, 0, this), "paint image of size %dx%d took %dms", this.volatileImage.getWidth(), this.volatileImage.getHeight());
        } while (this.volatileImage.contentsLost());
    }

    public Color getVerticalColor() {
        return this.verticalColor;
    }

    public void setVerticalColor(Color verticalColor) {
        this.verticalColor = ImageComponent.deriveAlpha(verticalColor);
    }

    public Color getHorizontalColor() {
        return this.horizontalColor;
    }

    public void setHorizontalColor(Color horizontalColor) {
        this.horizontalColor = ImageComponent.deriveAlpha(horizontalColor);
    }

    public Color getEdgeColor() {
        return this.edgeColor;
    }

    public void setEdgeColor(Color edgeColor) {
        this.edgeColor = edgeColor;
        this.renderOffscreen();
        this.repaint();
    }

    public boolean isPreserveAspectRatio() {
        return this.preserveAspectRatio;
    }

    public void setPreserveAspectRatio(boolean preserveAspectRatio) {
        this.preserveAspectRatio = preserveAspectRatio;
        this.renderOffscreen();
        this.repaint();
    }

    public boolean isShowGrid() {
        return this.showGrid;
    }

    public void setShowGrid(boolean showGrid) {
        this.showGrid = showGrid;
        this.renderOffscreen();
        this.repaint();
    }

    private static Color deriveAlpha(Color color) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), 128);
    }

    void setZoomToROI(boolean zoom) {
        this.zoomToROI = zoom;
        this.renderOffscreen();
        this.repaint();
    }

    void setGridSize(int size) {
        this.gridSize = size;
        this.renderOffscreen();
        this.repaint();
    }
}

