/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.integrationgantrygui;

import java.awt.Point;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import nom.tam.fits.Header;
import nom.tam.fits.TruncatedFileException;
import nom.tam.fits.header.Standard;
import nom.tam.util.BufferedFile;
import org.lsst.ccs.integrationgantrygui.IndexedScalableImageProvider;
import org.lsst.ccs.integrationgantrygui.LookupScalableImageProvider;
import org.lsst.ccs.integrationgantrygui.ScalableImageProvider;
import org.lsst.ccs.integrationgantrygui.Timed;

public class FitsFast {
    static ScalableImageProvider readFits(File in) throws IOException, TruncatedFileException {
        try (BufferedFile file = new BufferedFile(in);){
            Header header = new Header(file);
            int nAxis1 = header.getIntValue(Standard.NAXIS1);
            int nAxis2 = header.getIntValue(Standard.NAXIS2);
            int bitpix = header.getIntValue(Standard.BITPIX);
            int bZero = header.getIntValue(Standard.BZERO);
            int bScale = header.getIntValue(Standard.BSCALE, 1);
            int imageSize = nAxis1 * nAxis2;
            ByteBuffer bb = ByteBuffer.allocateDirect(nAxis1 * nAxis2 * bitpix / 8);
            FileChannel channel = file.getChannel();
            channel.position(file.getFilePointer());
            Timed.execute(() -> {
                int l;
                while (bb.hasRemaining() && (l = channel.read(bb)) >= 0) {
                }
                return null;
            }, "Read image of type %d size %dx%d in %dms", bitpix, nAxis1, nAxis2);
            bb.flip();
            WritableRaster raster = Raster.createInterleavedRaster(bitpix == 8 ? 0 : 1, nAxis1, nAxis2, 1, new Point(0, 0));
            DataBuffer db = raster.getDataBuffer();
            int[] counts = Timed.execute(() -> {
                if (bitpix == 8) {
                    int[] result = new int[256];
                    for (int i = 0; i < imageSize; ++i) {
                        int pixel;
                        int n = pixel = bb.get() & 0xFF;
                        result[n] = result[n] + 1;
                        db.setElem(i, pixel);
                    }
                    return result;
                }
                int[] result = new int[65536];
                for (int i = 0; i < imageSize; ++i) {
                    int pixel;
                    int n = pixel = bb.getShort() & 0xFFFF;
                    result[n] = result[n] + 1;
                    db.setElem(i, pixel);
                }
                return result;
            }, "Write image of type %d size %dx%d in %dms", bitpix, nAxis1, nAxis2);
            ScalableImageProvider scalableImageProvider = Boolean.getBoolean("useLookup") ? new LookupScalableImageProvider(bitpix, bZero, bScale, counts, raster) : new IndexedScalableImageProvider(bitpix, bZero, bScale, counts, raster);
            return scalableImageProvider;
        }
    }
}

