package org.lsst.ccs.integrationgantrygui;

import java.awt.image.BufferedImage;
import java.util.List;

/**
 *
 * @author tonyj
 */
public class CameraPanel extends javax.swing.JPanel {

    private static final long serialVersionUID = 1L;

    /**
     * Creates new form CameraPanel
     */
    public CameraPanel() {
        initComponents();
        imageComponent.setHorizontalColor(horizLabel.getForeground());
        imageComponent.setVerticalColor(vertLabel.getForeground());
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        InfoPanel = new javax.swing.JPanel();
        horizLabel = new javax.swing.JLabel();
        h1TextField = new javax.swing.JTextField();
        h2TextField = new javax.swing.JTextField();
        hGapTextField = new javax.swing.JTextField();
        vertLabel = new javax.swing.JLabel();
        v1TextField = new javax.swing.JTextField();
        v2TextField = new javax.swing.JTextField();
        vGapTextField = new javax.swing.JTextField();
        imageComponent = new org.lsst.ccs.integrationgantrygui.ImageComponent();

        setLayout(new java.awt.BorderLayout());

        horizLabel.setForeground(new java.awt.Color(0, 51, 255));
        horizLabel.setText("Horiz:");
        InfoPanel.add(horizLabel);

        h1TextField.setEditable(false);
        h1TextField.setColumns(4);
        InfoPanel.add(h1TextField);

        h2TextField.setEditable(false);
        h2TextField.setColumns(4);
        InfoPanel.add(h2TextField);

        hGapTextField.setEditable(false);
        hGapTextField.setColumns(6);
        InfoPanel.add(hGapTextField);

        vertLabel.setForeground(new java.awt.Color(0, 204, 0));
        vertLabel.setText("Vert:");
        InfoPanel.add(vertLabel);

        v1TextField.setEditable(false);
        v1TextField.setColumns(4);
        InfoPanel.add(v1TextField);

        v2TextField.setEditable(false);
        v2TextField.setColumns(4);
        InfoPanel.add(v2TextField);

        vGapTextField.setEditable(false);
        vGapTextField.setColumns(6);
        InfoPanel.add(vGapTextField);

        add(InfoPanel, java.awt.BorderLayout.NORTH);
        add(imageComponent, java.awt.BorderLayout.CENTER);
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel InfoPanel;
    private javax.swing.JTextField h1TextField;
    private javax.swing.JTextField h2TextField;
    private javax.swing.JTextField hGapTextField;
    private javax.swing.JLabel horizLabel;
    private org.lsst.ccs.integrationgantrygui.ImageComponent imageComponent;
    private javax.swing.JTextField v1TextField;
    private javax.swing.JTextField v2TextField;
    private javax.swing.JTextField vGapTextField;
    private javax.swing.JLabel vertLabel;
    // End of variables declaration//GEN-END:variables

    void setImage(BufferedImage scaledImage) {
        imageComponent.setImage(scaledImage);
    }

    void setLabels(double h1, double h2, double v1, double v2) {
        h1TextField.setText(formatNumber(h1));
        h2TextField.setText(formatNumber(h2));
        v1TextField.setText(formatNumber(v1));
        v2TextField.setText(formatNumber(v2));
        hGapTextField.setText(formatNumber((h2 - h1) * 25, "μm"));
        vGapTextField.setText(formatNumber((v2 - v1) * 25, "μm"));
        imageComponent.setEdges(h1, h2, v1, v2);
    }

    private static String formatNumber(double d, String units) {
        return Double.isNaN(d) ? "" : String.format("%4.4g%s", d, units);
    }

    private static String formatNumber(double d) {
        return formatNumber(d, "");
    }

    void setROI(boolean horizontal, List<Number> roi) {
        imageComponent.setROI(horizontal, roi);
    }

    void setShowROI(boolean showROI) {
        imageComponent.setShowROI(showROI);
    }

    void setZoomToROI(boolean zoom) {
        imageComponent.setZoomToROI(zoom);
    }

    void setShowEdges(boolean show) {
        imageComponent.setShowEdges(show);
    }

    void setShowGrid(boolean show) {
        imageComponent.setShowGrid(show);
    }

    void setPreserveAspectRatio(boolean selected) {
        imageComponent.setPreserveAspectRatio(selected);
    }

    void setGridSize(int size) {
        imageComponent.setGridSize(size);
    }
}
