/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.imagehandling.imagedb;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.imagehandling.CommandExecutor;
import org.lsst.ccs.subsystem.imagehandling.ImageHandlingConfig;
import org.lsst.ccs.subsystem.imagehandling.imagedb.ImageDatabaseService;
import org.lsst.ccs.subsystem.imagehandling.imagedb.ImageFileDatabase;
import org.lsst.ccs.utilities.location.SensorLocation;

public class CommandExecutorTest {
    static String createConnection() {
        return "jdbc:h2:mem:test;MODE=MYSQL";
    }

    @Test
    public void commandExecutorTest() throws SQLException, IOException {
        File logFile = File.createTempFile("testLogFile.log", null);
        FileWriter fileWriter = new FileWriter(logFile.getAbsolutePath(), true);
        try (BufferedWriter bw = new BufferedWriter(fileWriter);){
            String textToWrite = "Start: test_operation_one 1726585010082\nTelemetry: sdf_json_copy_time: 2.00\nI am successful\nEnd: test_operation_one 0 1726585012089\nStart: test_operation_two 1726585012091\nTelemetry: sdf_json_copy_time: 2.00\nI am a failure\nEnd: test_operation_two 1 1726585014097";
            bw.write(textToWrite);
        }
        ImageDatabaseService idbs = ImageDatabaseService.testInstance((String)CommandExecutorTest.createConnection());
        try (ImageFileDatabase ifdb = new ImageFileDatabase(idbs);){
            ImageName in = new ImageName("MC_C_20190610_001309");
            SensorLocation location = new SensorLocation(2, 2, 2);
            int file_id = ifdb.insertFile(in, location, "TYPE", "TEST_FILE");
            PreparedStatement stmt = ifdb.getConnection().prepareStatement("select * from ccs_image_file");
            ResultSet rs = stmt.executeQuery();
            rs.next();
            Assert.assertEquals((Object)"TYPE", (Object)rs.getString("fileType"));
            Assert.assertEquals((Object)"TEST_FILE", (Object)rs.getString("writeFile"));
            ImageHandlingConfig config = new ImageHandlingConfig();
            CommandExecutor commandExecutor = new CommandExecutor(config, null, ifdb);
            List operations = commandExecutor.scanFileForOperations(logFile, file_id);
            ifdb.insertFileOperations(operations, false);
            stmt = ifdb.getConnection().prepareStatement("select * from ccs_image_file_operation where file_id = ?");
            stmt.setInt(1, file_id);
            rs = stmt.executeQuery();
            rs.next();
            Assert.assertEquals((Object)true, (Object)rs.getBoolean("success"));
            Assert.assertEquals((Object)"test_operation_one", (Object)rs.getString("operation"));
            Assert.assertEquals((long)0L, (long)rs.getInt("operation_return_code"));
            rs.next();
            logFile.deleteOnExit();
            Assert.assertEquals((Object)false, (Object)rs.getBoolean("success"));
            Assert.assertEquals((Object)"test_operation_two", (Object)rs.getString("operation"));
            Assert.assertEquals((Object)"Telemetry: sdf_json_copy_time: 2.00\nI am a failure", (Object)rs.getString("reason").strip());
            Assert.assertEquals((long)1L, (long)rs.getInt("operation_return_code"));
        }
    }

    @Test
    public void commandExecutorRealLogTest() throws IOException, SQLException {
        File logFile = this.writeRealisticLog("testRealisticLogFile");
        ImageDatabaseService idbs = ImageDatabaseService.testInstance((String)CommandExecutorTest.createConnection());
        try (ImageFileDatabase ifdb = new ImageFileDatabase(idbs);){
            ImageName in = new ImageName("MC_C_20190610_001309");
            SensorLocation location = new SensorLocation(2, 2, 2);
            int file_id = ifdb.insertFile(in, location, "TYPE", "TEST_FILE");
            PreparedStatement stmt = ifdb.getConnection().prepareStatement("select * from ccs_image_file");
            ResultSet rs = stmt.executeQuery();
            rs.next();
            Assert.assertEquals((Object)"TYPE", (Object)rs.getString("fileType"));
            Assert.assertEquals((Object)"TEST_FILE", (Object)rs.getString("writeFile"));
            ImageHandlingConfig config = new ImageHandlingConfig();
            CommandExecutor commandExecutor = new CommandExecutor(config, null, ifdb);
            List operations = commandExecutor.scanFileForOperations(logFile, file_id);
            ifdb.insertFileOperations(operations, false);
            stmt = ifdb.getConnection().prepareStatement("select * from ccs_image_file_operation where file_id = ?");
            stmt.setInt(1, file_id);
            rs = stmt.executeQuery();
            rs.next();
            Assert.assertEquals((Object)true, (Object)rs.getBoolean("success"));
            Assert.assertEquals((Object)"compress", (Object)rs.getString("operation"));
            Assert.assertEquals((long)0L, (long)rs.getInt("operation_return_code"));
            rs.next();
            Assert.assertEquals((Object)true, (Object)rs.getBoolean("success"));
            Assert.assertEquals((Object)"generate-sidecar", (Object)rs.getString("operation"));
            Assert.assertNull((Object)rs.getString("reason"));
            rs.next();
            Assert.assertEquals((Object)false, (Object)rs.getBoolean("success"));
            Assert.assertEquals((long)2L, (long)rs.getInt("operation_return_code"));
            Assert.assertEquals((Object)"oods_fits_copy", (Object)rs.getString("operation"));
            String reasonTest = rs.getString("reason");
            boolean contains = reasonTest.contains("/data/ccs-ipa-d");
            Assert.assertEquals((Object)true, (Object)contains);
            contains = reasonTest.contains("ccs-push-nopuppet -h azar03");
            Assert.assertEquals((Object)true, (Object)contains);
            contains = reasonTest.contains("INVOCATION_ID=085eab508df24abf835afc616eb070ef");
            Assert.assertEquals((Object)false, (Object)contains);
        }
    }

    public File writeRealisticLog(String fileName) throws IOException {
        File realLogFile = File.createTempFile(fileName, null);
        FileWriter fileWriter = new FileWriter(realLogFile.getAbsolutePath(), true);
        try (BufferedWriter bw = new BufferedWriter(fileWriter);){
            String textToWrite = "SHELL=/bin/bash SLOT=S22 IMAGENAME=MC_C_20240923_001135\nCCS_RESOURCE_PATH=|/opt/lsst/ccs/20240913/org-lsst-ccs-camera-software-main-1.0.13-SNAPSHOT/../etc/|~/ccs/etc/|/etc/ccs/\nSOURCE=MC\nUSDF_BUCKET=rubin-summit\nRUNNING=302\nPWD=/home/ccs-ipa\nLOGNAME=ccs-ipa\nUSDF_USE_S3DAEMON=true\nSYSTEMD_EXEC_PID=2938953\n=/usr/bin/env\nLOGFILE=/var/log/ccs/image-handling/20240923/MC_C_20240923_001135_R22_S22.fits.log\nHOME=/home/ccs-ipa\nLANG=en_US.UTF-8\nMODE=SCIENCE\nOODS_BUCKET=rubinobs-raw-lsstcam\nINVOCATION_ID=085eab508df24abf835afc616eb070ef\nUSDF_MC_HOST=oga\nDATE=20240923\nUSER=ccs-ipa\nRAFT=R22\nDAQ_HOME=/opt/lsst/daq-sdk/ccs-production\nFILETYPE=FITS\nSHLVL=2\nSEQNO=001135\nCCS_DISTRIBUTION_HOME=/opt/lsst/ccs/20240913/org-lsst-ccs-camera-software-main-1.0.13-SNAPSHOT\nBOARD=Reb2\nLD_LIBRARY_PATH=/opt/lsst/daq-sdk/ccs-production/x86/lib:/opt/lsst/ccs/20240913/org-lsst-ccs-camera-software-main-1.0.13-SNAPSHOT/lib64/jni/:/opt/lsst/ccs/20240913/org-lsst-ccs-camera-software-main-1.0.13-SNAPSHOT/lib64/\nCONTROLLER=C\nJOURNAL_STREAM=8:189313674\nPATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin\nOODS_MC_HOST=oods\nFITSFILE=/data/ccs-ipa-data/20240923/MC_C_20240923_001135/MC_C_20240923_001135_R22_S22.fits\nFILE=/data/ccs-ipa-data/20240923/MC_C_20240923_001135/MC_C_20240923_001135_R22_S22.fits\nINSTRUMENT=LSSTCam\nStart: compress 1727142927691\nTelemetry: fpack_time: 0.38\nEnd: compress 0 1727142928078\nStart: generate-sidecar 1727142928081\nEnd: generate-sidecar 0 1727142928271\nStart: oods_fits_copy 1727142928274\nccs-push-nopuppet -h azar03 -c maintel -s 20240923/001135 -f\n/data/ccs-ipa-data/20240923/MC_C_20240923_001135/MC_C_20240923_001135_R22_S22.fits\nsss_ssh_knownhostsproxy: unable to proxy data: Connection reset by peer\nkex_exchange_identification: Connection closed by remote host\nConnection closed by UNKNOWN port 65535\nCommand exited with non-zero status 255\nTelemetry: oods_fits_copy_time: 0.02\nTelemetry: oods_fits_copy_time: 215.07\nRetries 1\nEnd: oods_fits_copy 2 1727143153377\nTelemetry: sdf_json_copy_time: 2.08\nTrack: sdf_json_copy_rc: 0\nTelemetry: sdf_fits_copy_time: 4.16\nTrack: sdf_fits_copy_rc: 0\n";
            realLogFile.deleteOnExit();
            bw.write(textToWrite);
        }
        return realLogFile;
    }
}

