/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.imagehandling;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.imagehandling.CommandExecutor;
import org.lsst.ccs.subsystem.imagehandling.ImageHandlingConfig;
import org.lsst.ccs.subsystem.imagehandling.PostImageFileHandling;
import org.lsst.ccs.subsystem.imagehandling.data.AdditionalFile;
import org.lsst.ccs.subsystem.imagehandling.data.FileList;
import org.lsst.ccs.subsystem.imagehandling.data.JsonFile;
import org.lsst.ccs.subsystem.imagehandling.data.MeasuredShutterTime;

public class PostImageFileHandlingTest {
    @Test
    public void testAdditionalFile() throws InterruptedException, ExecutionException {
        HashMap<String, String> activeSensors = new HashMap<String, String>();
        activeSensors.put("R00_SG0", "GUIDER");
        activeSensors.put("R22_S00", "SCIENCE");
        ImageName imageName = new ImageName("MC_C_20230515_000001");
        JsonFile jf = new JsonFile("activeSensors.json", "activeSensors", imageName, "activeSensors", activeSensors);
        ImageHandlingConfig config = new ImageHandlingConfig();
        CommandExecutor commandExecutor = new CommandExecutor(config, null, null);
        PostImageFileHandling pifh = new PostImageFileHandling(config, commandExecutor, null);
        CompletableFuture futureLogFile = pifh.handleAdditionalFile((AdditionalFile)jf);
        CompletionStage futureProperties = futureLogFile.thenApply(logFile -> {
            Properties props = new Properties();
            try (FileReader reader = new FileReader((File)logFile);){
                props.load(reader);
            }
            catch (IOException x) {
                throw new RuntimeException(x);
            }
            return props;
        });
        Properties props = (Properties)((CompletableFuture)futureProperties).get();
        Assert.assertEquals((Object)imageName.toString(), (Object)props.get("IMAGENAME"));
        Assert.assertEquals((Object)"activeSensors.json", (Object)props.get("FILENAME"));
        Assert.assertEquals((Object)"20230515", (Object)props.get("IMAGEDATE"));
        Assert.assertEquals((Object)"/tmp/20230515/activeSensors.json.log", (Object)props.get("LOGFILE"));
    }

    @Test
    public void testHeaderService() throws InterruptedException, ExecutionException {
        ImageHandlingConfig config = new ImageHandlingConfig();
        CommandExecutor commandExecutor = new CommandExecutor(config, null, null);
        PostImageFileHandling pifh = new PostImageFileHandling(config, commandExecutor, null);
        ImageName imageName = new ImageName("CC_C_20230515_000001");
        CompletableFuture<FileList> filesToProcess = new CompletableFuture<FileList>();
        CompletableFuture futureFilesWithHeaderData = pifh.handleAsynchronousData(filesToProcess, imageName.toString(), true, false);
        List headerData = Collections.emptyList();
        FileList inputFileList = new FileList();
        filesToProcess.complete(inputFileList);
        pifh.headerDataArrived(imageName.toString(), headerData);
        FileList fileList = (FileList)futureFilesWithHeaderData.get();
        Assert.assertNotNull((Object)fileList);
    }

    @Test
    public void testMeasuredShutterTime() throws InterruptedException, ExecutionException {
        ImageHandlingConfig config = new ImageHandlingConfig();
        CommandExecutor commandExecutor = new CommandExecutor(config, null, null);
        PostImageFileHandling pifh = new PostImageFileHandling(config, commandExecutor, null);
        ImageName imageName = new ImageName("MC_C_20230515_000001");
        CompletableFuture<FileList> filesToProcess = new CompletableFuture<FileList>();
        CompletableFuture futureFilesWithHeaderData = pifh.handleAsynchronousData(filesToProcess, imageName.toString(), false, true);
        FileList inputFileList = new FileList();
        filesToProcess.complete(inputFileList);
        MeasuredShutterTime shutterTime = new MeasuredShutterTime(imageName, 0.0);
        pifh.measuredShutterTimeArrived(shutterTime);
        FileList fileList = (FileList)futureFilesWithHeaderData.get();
        Assert.assertNotNull((Object)fileList);
    }
}

