/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.imagehandling;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentCategory;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.ImageMetaData;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.imagehandling.ImageHandlingClient;
import org.lsst.ccs.subsystem.imagehandling.data.AdditionalFile;
import org.lsst.ccs.subsystem.imagehandling.data.HeaderServiceEnabled;
import org.lsst.ccs.subsystem.imagehandling.data.ImageHeaderData;
import org.lsst.ccs.subsystem.imagehandling.data.ImageHeaderKeywords;
import org.lsst.ccs.subsystem.imagehandling.data.TriggerSimulatedImage;
import org.lsst.ccs.utilities.location.Location;
import org.lsst.ccs.utilities.location.LocationSet;

class BusMessageHandler
implements HasLifecycle {
    private volatile String[] metaDataRegisters;
    private FocalPlaneConfigurationAndDataListener focalPlaneListener;
    private OCSBridgeDataListener ocsBridgeDataListener;
    private AdditionalFileListener additionalFileListener;
    private static final Logger LOG = Logger.getLogger(BusMessageHandler.class.getName());
    private final Predicate<BusMessage<? extends Serializable, ?>> focalPlanePredicate = bm -> BusMessageHandler.isFocalPlaneAgent(bm.getOriginAgentInfo());
    private final Predicate<BusMessage<? extends Serializable, ?>> ocsBridgePredicate = bm -> BusMessageHandler.isOCSBridgeAgent(bm.getOriginAgentInfo());
    private final Predicate<BusMessage<? extends Serializable, ?>> headerKeywordsPredicate = BusMessageFilterFactory.messageClass(StatusSubsystemData.class).and(bm -> "ImageHeaderKeywords".equals(((StatusSubsystemData)bm).getDataKey()));
    private final Predicate<BusMessage<? extends Serializable, ?>> headerDataPredicate = BusMessageFilterFactory.messageClass(StatusSubsystemData.class).and(bm -> "imageHeaderData".equals(((StatusSubsystemData)bm).getDataKey()));
    private final Predicate<BusMessage<? extends Serializable, ?>> simulatedTriggerPredicate = BusMessageFilterFactory.messageClass(StatusSubsystemData.class).and(bm -> "triggerSimulatedImage".equals(((StatusSubsystemData)bm).getDataKey()));
    private final Predicate<BusMessage<? extends Serializable, ?>> headerServiceEnabledPredicate = BusMessageFilterFactory.messageClass(StatusSubsystemData.class).and(bm -> "headerServiceEnabled".equals(((StatusSubsystemData)bm).getDataKey()));
    private final Predicate<BusMessage<? extends Serializable, ?>> additionalFilePredicate = BusMessageFilterFactory.messageClass(StatusSubsystemData.class).and(bm -> "additionalFile".equals(((StatusSubsystemData)bm).getDataKey()));
    private final Predicate<BusMessage<? extends Serializable, ?>> configurationDataPredicate = BusMessageFilterFactory.messageClass(StatusConfigurationInfo.class);
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private ImageHandlingClient imageHandlingClient;

    BusMessageHandler() {
    }

    public void postStart() {
        this.focalPlaneListener = new FocalPlaneConfigurationAndDataListener();
        this.agent.getMessagingAccess().addStatusMessageListener((StatusMessageListener)this.focalPlaneListener, this.focalPlanePredicate.and(this.configurationDataPredicate.or(this.headerKeywordsPredicate).or(this.simulatedTriggerPredicate)));
        this.ocsBridgeDataListener = new OCSBridgeDataListener();
        this.agent.getMessagingAccess().addStatusMessageListener((StatusMessageListener)this.ocsBridgeDataListener, this.ocsBridgePredicate.and(this.headerDataPredicate.or(this.headerServiceEnabledPredicate)));
        if (this.imageHandlingClient.canHandleAdditionalFiles()) {
            this.additionalFileListener = new AdditionalFileListener();
            this.agent.getMessagingAccess().addStatusMessageListener((StatusMessageListener)this.additionalFileListener, this.additionalFilePredicate);
        }
    }

    public void shutdown() {
        this.agent.getMessagingAccess().removeStatusMessageListener((StatusMessageListener)this.focalPlaneListener);
        this.agent.getMessagingAccess().removeStatusMessageListener((StatusMessageListener)this.ocsBridgeDataListener);
        this.agent.getMessagingAccess().removeStatusMessageListener((StatusMessageListener)this.additionalFileListener);
    }

    public String[] getMetaDataRegisters() {
        return this.metaDataRegisters;
    }

    private static boolean isFocalPlaneAgent(AgentInfo agentInfo) {
        return AgentCategory.FOCAL_PLANE.name().equals(agentInfo.getAgentProperty("agentCategory"));
    }

    private static boolean isOCSBridgeAgent(AgentInfo agentInfo) {
        return AgentInfo.AgentType.OCS_BRIDGE.equals((Object)agentInfo.getType());
    }

    static /* synthetic */ String[] access$302(BusMessageHandler x0, String[] x1) {
        x0.metaDataRegisters = x1;
        return x1;
    }

    private class FocalPlaneConfigurationAndDataListener
    implements StatusMessageListener {
        private FocalPlaneConfigurationAndDataListener() {
        }

        public void onStatusMessage(StatusMessage msg) {
            if (msg instanceof StatusConfigurationInfo) {
                ConfigurationInfo ci = ((StatusConfigurationInfo)msg).getConfigurationInfo();
                for (ConfigurationParameterInfo cpi : ci.getAllParameterInfo()) {
                    if (!cpi.getComponentName().equals("focalPlaneConfig") || !cpi.getParameterName().equals("metaDataRegisters")) continue;
                    BusMessageHandler.access$302(BusMessageHandler.this, (String[])cpi.getCurrentValueObject());
                    LOG.log(Level.FINEST, "Updating metaDataRegister to {0}", new Object[]{Arrays.asList(BusMessageHandler.this.metaDataRegisters)});
                }
            }
            if (msg instanceof StatusSubsystemData) {
                StatusSubsystemData ssd = (StatusSubsystemData)msg;
                if (BusMessageHandler.this.headerKeywordsPredicate.test(ssd)) {
                    ImageHeaderKeywords keywords = (ImageHeaderKeywords)((KeyValueData)ssd.getObject()).getValue();
                    Map headerMap = keywords.getKeywords();
                    LOG.log(Level.INFO, () -> String.format("Received image header keywords %s", keywords));
                    BusMessageHandler.this.imageHandlingClient.addMetaData(keywords.getImageName(), keywords.getKeywords());
                    if (headerMap.containsKey("darkTime")) {
                        BusMessageHandler.this.imageHandlingClient.darkTimeArrived(keywords.getImageName());
                    } else if (headerMap.containsKey("RunNumber")) {
                        Object runNumber = headerMap.get("RunNumber");
                        BusMessageHandler.this.imageHandlingClient.runNumberArrived(runNumber == null ? null : runNumber.toString());
                    }
                } else if (BusMessageHandler.this.simulatedTriggerPredicate.test(ssd)) {
                    TriggerSimulatedImage tsi = (TriggerSimulatedImage)((KeyValueData)ssd.getObject()).getValue();
                    LOG.log(Level.INFO, "Received {0}", tsi);
                    try {
                        Location location = Location.of((String)"R00/RebW");
                        ImageMetaData meta = new ImageMetaData(tsi.getTriggeredImageName(), tsi.getTriggeredDAQFolder(), tsi.getAnnotation(), tsi.getOpCode(), (Set)new LocationSet(Collections.singleton(location)));
                        Path metaPath = Path.of(tsi.getEmulatedDataFolder(), new String[0]).resolve(tsi.getEmulatedDAQFolder()).resolve(tsi.getEmulatedImageName() + "_R00_RebW.meta");
                        if (!Files.exists(metaPath, new LinkOption[0])) {
                            throw new IllegalArgumentException("Path " + metaPath + " does not exist");
                        }
                        Path rawData = Path.of(tsi.getEmulatedDataFolder(), new String[0]).resolve(tsi.getEmulatedDAQFolder()).resolve(tsi.getEmulatedImageName() + "_R00_RebW.raw");
                        if (!Files.exists(rawData, new LinkOption[0])) {
                            throw new IllegalArgumentException("Path " + rawData + " does not exist");
                        }
                        String line = Files.newBufferedReader(metaPath).readLine();
                        int[] registerList = Arrays.stream(line.substring(1, line.length() - 1).split(",")).map(String::trim).mapToInt(Integer::parseInt).toArray();
                        BusMessageHandler.this.imageHandlingClient.simulateTrigger(location, meta, registerList, rawData);
                    }
                    catch (IOException | DAQException x) {
                        LOG.log(Level.SEVERE, "Error triggering simulated image", x);
                    }
                }
            }
        }
    }

    private class OCSBridgeDataListener
    implements StatusMessageListener {
        private OCSBridgeDataListener() {
        }

        public void onStatusMessage(StatusMessage msg) {
            if (msg instanceof StatusSubsystemData) {
                StatusSubsystemData ssd = (StatusSubsystemData)msg;
                if (BusMessageHandler.this.headerDataPredicate.test(ssd)) {
                    ImageHeaderData data = (ImageHeaderData)((KeyValueData)ssd.getObject()).getValue();
                    StringBuilder imageName = new StringBuilder("aa_b_cccccccc_dddddd");
                    for (ImageHeaderData.Header header : data.getHeaders()) {
                        if (header.getKeyword() == null) continue;
                        String value = header.getValue();
                        switch (header.getKeyword()) {
                            case "CAMCODE": {
                                imageName.replace(0, 2, value);
                                break;
                            }
                            case "CONTRLLR": {
                                imageName.replace(3, 4, value);
                                break;
                            }
                            case "DAYOBS": {
                                imageName.replace(5, 13, value);
                                break;
                            }
                            case "SEQNUM": {
                                imageName.replace(14, 20, String.format("%06d", Integer.parseInt(value)));
                            }
                        }
                    }
                    LOG.log(Level.INFO, "Received image headers for {0}: {1}", new Object[]{imageName, data.getHeaders()});
                    BusMessageHandler.this.imageHandlingClient.headerDataArrived(imageName.toString(), data.getHeaders());
                } else if (BusMessageHandler.this.headerServiceEnabledPredicate.test(ssd)) {
                    HeaderServiceEnabled headerServiceEnabled = (HeaderServiceEnabled)((KeyValueData)ssd.getObject()).getValue();
                    LOG.log(Level.INFO, "Received headerServiceEnabled: {0}", headerServiceEnabled.isEnabled());
                    BusMessageHandler.this.imageHandlingClient.setHeaderServiceEnabled(headerServiceEnabled.isEnabled());
                }
            }
        }
    }

    private class AdditionalFileListener
    implements StatusMessageListener {
        private AdditionalFileListener() {
        }

        public void onStatusMessage(StatusMessage msg) {
            if (msg instanceof StatusSubsystemData) {
                StatusSubsystemData ssd = (StatusSubsystemData)msg;
                if (BusMessageHandler.this.additionalFilePredicate.test(ssd)) {
                    AdditionalFile additionalFile = (AdditionalFile)((KeyValueData)ssd.getObject()).getValue();
                    BusMessageHandler.this.imageHandlingClient.handleAdditionFile(additionalFile);
                }
            }
        }
    }
}

